/*
 * Decompiled with CFR 0.152.
 */
package evacSim.data;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.GlobalVariables;
import evacSim.NetworkEventObject;
import evacSim.citycontext.Road;
import evacSim.citycontext.Zone;
import evacSim.data.DataConsumer;
import evacSim.data.TickSnapshot;
import evacSim.vehiclecontext.Vehicle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedDeque;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.essentials.RepastEssentials;

public class DataCollector {
    private static final DataCollector instance = new DataCollector();
    private boolean collecting = false;
    private boolean paused = false;
    private double lastTick = -1.0;
    private ConcurrentLinkedDeque<TickSnapshot> buffer = new ConcurrentLinkedDeque();
    private Vector<DataConsumer> registeredConsumers = new Vector();
    private TickSnapshot currentSnapshot = null;
    private Timer cleanupTimer;
    private TimerTask cleanupTask;
    private int cleanupCount;

    private DataCollector() {
    }

    public static DataCollector getInstance() {
        return instance;
    }

    public boolean isCollecting() {
        return this.collecting;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void startDataCollection() {
        DataCollector.printDebug("CTRL", "START COLLECTION");
        if (!this.collecting && this.paused) {
            this.resumeDataCollection();
            return;
        }
        this.collecting = true;
        this.paused = false;
        this.buffer = new ConcurrentLinkedDeque();
        this.lastTick = -1.0;
        this.currentSnapshot = null;
        if (this.cleanupTask != null) {
            this.cleanupTask.cancel();
        }
        this.cleanupTimer = new Timer(true);
        this.cleanupTask = new TimerTask(){

            @Override
            public void run() {
                DataCollector.this.cleanupBuffer();
            }
        };
        long cleanupTimeout = GlobalVariables.DATA_CLEANUP_REFRESH;
        this.cleanupTimer.schedule(this.cleanupTask, cleanupTimeout * 2L, cleanupTimeout);
        for (DataConsumer dc : this.registeredConsumers) {
            if (dc == null) continue;
            try {
                dc.startConsumer();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void stopDataCollection() {
        DataCollector.printDebug("CTRL", "STOP COLLECTION");
        this.paused = false;
        this.collecting = false;
    }

    public void pauseDataCollection() {
        DataCollector.printDebug("CTRL", "PAUSE COLLECTION");
        this.paused = true;
        this.collecting = false;
    }

    public void resumeDataCollection() {
        DataCollector.printDebug("CTRL", "RESUME COLLECTION");
        if (!this.collecting && this.paused) {
            this.paused = false;
            this.collecting = true;
        }
    }

    public void startTickCollection(double tickNumber) {
        GlobalVariables.datacollection_start = System.currentTimeMillis();
        if ((int)tickNumber % 100 == 0) {
            String message = "TICK " + tickNumber + " [" + this.buffer.size() + " ticks in buffer]";
            DataCollector.printDebug("CTRL", message);
        }
        if (tickNumber < 0.0 || tickNumber <= this.lastTick) {
            throw new IllegalArgumentException("Tick number invalid.");
        }
        this.currentSnapshot = new TickSnapshot(tickNumber);
        GlobalVariables.datacollection_total += (double)System.currentTimeMillis() - GlobalVariables.datacollection_start;
    }

    public void stopTickCollection() {
        if (this.currentSnapshot != null) {
            this.buffer.add(this.currentSnapshot);
            this.lastTick = this.currentSnapshot.getTickNumber();
        }
        this.currentSnapshot = null;
    }

    public void recordVehicleTickSnapshot(Vehicle vehicle, Coordinate coordinate) throws Throwable {
        double currentTick = RepastEssentials.GetTickCount();
        if (vehicle == null) {
            throw new IllegalArgumentException("No vehicle given.");
        }
        if (coordinate == null) {
            throw new IllegalArgumentException("No coordinate given.");
        }
        if (this.currentSnapshot == null) {
            throw new Exception("No tick snapshot being processed.");
        }
        this.currentSnapshot.recordVehicleSnapshot(vehicle, coordinate);
    }

    public void recordRoadTickSnapshot(Road road) {
        if (road == null) {
            throw new IllegalArgumentException("No road given");
        }
        if (this.currentSnapshot == null) {
            throw new RuntimeException("No tick snapshot being processed.");
        }
        this.currentSnapshot.recordRoadSnapshot(road);
    }

    public void recordShelterTickSnapshot(Zone shelt) {
        if (shelt == null) {
            throw new IllegalArgumentException("No shelter given");
        }
        if (this.currentSnapshot == null) {
            throw new RuntimeException("No tick snapshot being processed.");
        }
        this.currentSnapshot.recordShelterSnapshot(shelt);
    }

    public void recordNewVehicleTickSnapshot(Vehicle vehicle) {
        if (vehicle == null) {
            throw new IllegalArgumentException("No vehicle given.");
        }
        if (this.currentSnapshot == null) {
            throw new RuntimeException("No tick snapshot being processed.");
        }
        this.currentSnapshot.recordNewVehSnapshot(vehicle);
    }

    public void recordArrVehicleTickSnapshot(Vehicle vehicle) {
        if (vehicle == null) {
            throw new IllegalArgumentException("No vehicle given.");
        }
        if (this.currentSnapshot == null) {
            throw new RuntimeException("No tick snapshot being processed.");
        }
        this.currentSnapshot.recordArrVehSnapshot(vehicle);
    }

    public void recordEventSnapshot(NetworkEventObject event, int type) throws Throwable {
        if (event == null) {
            throw new IllegalArgumentException("No event given.");
        }
        if (this.currentSnapshot == null) {
            throw new Exception("No tick snapshot being processed.");
        }
        this.currentSnapshot.logEvent(event, type);
    }

    public void registerDataConsumer(DataConsumer consumer) {
        if (consumer == null) {
            return;
        }
        if (this.registeredConsumers == null) {
            this.registeredConsumers = new Vector();
        }
        if (this.registeredConsumers.contains(consumer)) {
            return;
        }
        this.registeredConsumers.add(consumer);
        if (this.isCollecting()) {
            try {
                consumer.startConsumer();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean deregisterDataConsumer(DataConsumer consumer) {
        if (consumer == null) {
            return true;
        }
        if (this.registeredConsumers == null) {
            return false;
        }
        if (!this.registeredConsumers.contains(consumer)) {
            return true;
        }
        boolean removed = this.registeredConsumers.remove(consumer);
        return removed;
    }

    public double firstTickAvailable() {
        if (this.buffer == null) {
            return -1.0;
        }
        if (this.buffer.isEmpty()) {
            if (this.isCollecting() || this.isPaused()) {
                return this.lastTick;
            }
            return -1.0;
        }
        TickSnapshot firstTick = this.buffer.peekFirst();
        if (firstTick == null) {
            return -1.0;
        }
        return firstTick.getTickNumber();
    }

    public double lastTickAvailable() {
        return this.lastTick;
    }

    public TickSnapshot getTick(double tickNumber) {
        TickSnapshot foundTick = this.getNextTick(tickNumber);
        if (foundTick == null) {
            return null;
        }
        if ((double)foundTick.getTickNumber() == tickNumber) {
            return foundTick;
        }
        return null;
    }

    public TickSnapshot getNextTick(double tickNumber) {
        if (tickNumber > this.lastTickAvailable()) {
            return null;
        }
        if (this.buffer == null || this.buffer.isEmpty()) {
            return null;
        }
        for (TickSnapshot tick : this.buffer) {
            if (tick == null || !((double)tick.getTickNumber() >= tickNumber)) continue;
            return tick;
        }
        return null;
    }

    private void cleanupBuffer() {
        if (this.buffer == null || this.buffer.isEmpty()) {
            if (!this.isCollecting() && !this.isPaused()) {
                this.cleanupTimer.cancel();
                this.cleanupTimer = null;
                this.cleanupTask = null;
            }
            return;
        }
        Double minimumTick = null;
        for (DataConsumer dc : this.registeredConsumers) {
            if (dc == null || minimumTick != null && !(minimumTick > dc.getTick())) continue;
            minimumTick = dc.getTick();
        }
        if (minimumTick == null) {
            minimumTick = RunEnvironment.getInstance().getCurrentSchedule().getTickCount() - 1.0;
        } else if (minimumTick < 0.0) {
            String cleanupMsg = "Cleaning #" + ++this.cleanupCount + " Nothing removed.  " + this.buffer.size() + " remain in buffer.";
            DataCollector.printDebug("CTRL", cleanupMsg);
            return;
        }
        int removed = 0;
        while (!this.buffer.isEmpty()) {
            TickSnapshot nextTick = this.buffer.peek();
            if (nextTick == null) {
                return;
            }
            if (!((double)nextTick.getTickNumber() < minimumTick)) break;
            this.buffer.remove();
            ++removed;
        }
        if (!this.isCollecting() && !this.isPaused()) {
            this.cleanupTimer.cancel();
            this.cleanupTimer = null;
            this.cleanupTask = null;
        }
        String cleanupMsg = "Cleaning #" + ++this.cleanupCount + " removed " + removed + " items.";
        DataCollector.printDebug("CTRL", cleanupMsg);
    }

    public static void printDebug(String msg) {
        DataCollector.printDebug(null, msg);
    }

    public static void printDebug(String prefix, String msg) {
        if (GlobalVariables.DEBUG_DATA_BUFFER) {
            String debugMessage = "<<DATA";
            if (prefix != null && prefix.trim().length() > 0) {
                debugMessage = String.valueOf(debugMessage) + ":" + prefix;
            }
            debugMessage = String.valueOf(debugMessage) + ">> " + msg;
            System.out.println(debugMessage);
        }
    }
}

