/*
 * Decompiled with CFR 0.152.
 */
package evacSim.data;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.data.DataCollector;
import evacSim.data.DataConsumer;
import evacSim.data.TickSnapshot;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class CsvOutputWriter
implements DataConsumer {
    private Logger logger = ContextCreator.logger;
    private boolean append;
    private boolean defaultFilenames;
    private File file;
    private BufferedWriter writer;
    private int linesWritten;
    private int fileSeriesNumber;
    private Thread writingThread;
    protected double currentTick;
    private boolean consuming;
    private boolean paused;

    public CsvOutputWriter() {
        this(new File(CsvOutputWriter.createDefaultFilePath()), false);
    }

    public CsvOutputWriter(File file, boolean append) {
        this.append = append;
        this.file = file;
        this.defaultFilenames = file == null;
        this.consuming = false;
        this.paused = false;
        this.currentTick = -1.0;
        this.writer = null;
        this.writingThread = null;
        this.fileSeriesNumber = 1;
        this.linesWritten = 0;
        DataCollector.printDebug("CSV", "FILE: " + this.file.getAbsolutePath());
    }

    public boolean isAppending() {
        return this.append;
    }

    public void setAppending(boolean append) {
        this.append = append;
    }

    public File getOutputFile() {
        return this.file;
    }

    public void setOutputfile(File file) throws IOException {
        if (this.consuming || this.paused) {
            throw new IOException("Cannot change file while running.");
        }
        this.file = file;
        this.fileSeriesNumber = 1;
        this.linesWritten = 0;
        this.defaultFilenames = this.file == null;
    }

    @Override
    public void startConsumer() throws Throwable {
        if (this.consuming) {
            if (this.paused) {
                this.paused = false;
            }
            return;
        }
        this.consuming = true;
        this.paused = false;
        if (this.defaultFilenames || this.file == null) {
            this.file = new File(CsvOutputWriter.createDefaultFilePath());
        }
        this.openOutputFileWriter();
        Runnable writingRunnable = new Runnable(){

            @Override
            public void run() {
                DataCollector collector = DataCollector.getInstance();
                int totalCount = 0;
                int writeCount = 0;
                boolean running = true;
                while (running) {
                    if (!CsvOutputWriter.this.consuming) {
                        DataCollector.printDebug("CSV", "NOT CONSUMING");
                        break;
                    }
                    if (CsvOutputWriter.this.paused) {
                        DataCollector.printDebug("CSV", "PAUSED");
                        try {
                            Thread.sleep(GlobalVariables.CSV_BUFFER_REFRESH);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    double nextTick = CsvOutputWriter.this.currentTick + (double)GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ;
                    TickSnapshot snapshot = collector.getNextTick(nextTick);
                    if (snapshot == null) {
                        if (writeCount > 0) {
                            String report = "Wrote " + writeCount + " ticks to disk (" + totalCount + " total)";
                            DataCollector.printDebug("CSV", report);
                            writeCount = 0;
                        }
                        if (!collector.isCollecting() && !collector.isPaused()) break;
                        try {
                            Thread.sleep(GlobalVariables.CSV_BUFFER_REFRESH);
                            continue;
                        }
                        catch (InterruptedException ie) {
                            break;
                        }
                    }
                    if (nextTick == (double)(GlobalVariables.SIMULATION_STOP_TIME - GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ)) {
                        CsvOutputWriter.this.logger.info((Object)"Shelter relocations:");
                    }
                    CsvOutputWriter.this.currentTick = snapshot.getTickNumber();
                    try {
                        CsvOutputWriter.this.writeTickSnapshot(snapshot);
                        ++totalCount;
                        ++writeCount;
                    }
                    catch (IOException ioe) {
                        String errMsg = "WRITE ERROR: " + ioe.getMessage();
                        DataCollector.printDebug("CSV" + errMsg);
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
                try {
                    CsvOutputWriter.this.closeOutputFileWriter();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                CsvOutputWriter.this.paused = false;
                CsvOutputWriter.this.consuming = false;
            }
        };
        this.writingThread = new Thread(writingRunnable);
        this.writingThread.start();
    }

    @Override
    public void stopConsumer() throws Throwable {
        if (!this.consuming) {
            return;
        }
        this.paused = false;
        this.consuming = false;
        this.writingThread.interrupt();
        this.writingThread.join();
        this.writingThread = null;
        this.currentTick = -1.0;
        this.closeOutputFileWriter();
        this.writer = null;
    }

    @Override
    public void pauseConsumer() throws Throwable {
        if (!this.consuming) {
            return;
        }
        this.paused = true;
        this.consuming = true;
    }

    @Override
    public void resetConsumer() throws Throwable {
        this.stopConsumer();
        this.paused = false;
        this.consuming = false;
        this.currentTick = -1.0;
    }

    @Override
    public double getTick() {
        return this.currentTick;
    }

    @Override
    public void setTick(double tick) throws Throwable {
        this.currentTick = tick;
    }

    private void openOutputFileWriter() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.flush();
                throw new Exception();
            }
            catch (IOException iOException) {
            }
            catch (Exception e) {
                throw new IOException("CSV writer already has a file open.");
            }
        }
        if (this.file == null) {
            throw new IOException("No output file has been specified.");
        }
        FileWriter fw = new FileWriter(this.file);
        this.writer = new BufferedWriter(fw);
    }

    private void closeOutputFileWriter() throws IOException {
        if (this.writer == null) {
            return;
        }
        this.writer.close();
        this.writer = null;
        if (this.defaultFilenames) {
            this.file = null;
        }
    }

    private void startNextOutputFile() throws IOException {
        if (this.file == null) {
            return;
        }
        String filename = this.file.getName();
        if (filename == null || filename.trim().length() < 1) {
            return;
        }
        String currentEnd = "." + this.fileSeriesNumber + ".csv";
        String nextEnd = "." + (this.fileSeriesNumber + 1) + ".csv";
        String newFilename = filename;
        if (newFilename.endsWith(currentEnd)) {
            newFilename = newFilename.replaceAll(String.valueOf(currentEnd) + "$", nextEnd);
        } else {
            String extEnd = ".csv";
            if (newFilename.endsWith(extEnd)) {
                newFilename = newFilename.replaceAll(String.valueOf(extEnd) + "$", nextEnd);
            }
        }
        File nextFile = new File(this.file.getParent(), newFilename);
        this.closeOutputFileWriter();
        this.file = nextFile;
        FileWriter fw = new FileWriter(this.file);
        this.writer = new BufferedWriter(fw);
        ++this.fileSeriesNumber;
    }

    private void writeTickSnapshot(TickSnapshot tick) throws IOException {
        if (tick == null) {
            return;
        }
        String[] lines = CsvOutputWriter.createTickLines(tick);
        if (lines == null || lines.length < 1) {
            return;
        }
        if (this.writer == null) {
            throw new IOException("The CSV file is not open for writing.");
        }
        if (this.linesWritten + lines.length >= GlobalVariables.CSV_LINE_LIMIT) {
            this.startNextOutputFile();
            this.linesWritten = 0;
        }
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line != null) {
                this.writer.write(line);
                this.writer.newLine();
            }
            ++n2;
        }
        this.linesWritten += lines.length;
        this.writer.flush();
    }

    public static String[] createTickLines(TickSnapshot tick) {
        if (tick == null) {
            return null;
        }
        String tickNum = Integer.toString(tick.getTickNumber());
        ArrayList<String> lines = tick.createCSVTickLines();
        int i = 0;
        while (i < lines.size()) {
            lines.set(i, String.valueOf(tickNum) + "," + lines.get(i));
            ++i;
        }
        return lines.toArray(new String[0]);
    }

    public static String createDefaultFilePath() {
        String defaultFilename = GlobalVariables.DEFAULT_SNAPSHOT_FILENAME;
        SimpleDateFormat formatter = new SimpleDateFormat("YYYY-MM-dd-hh-mm-ss");
        String timestamp = formatter.format(new Date());
        String filename = String.valueOf(defaultFilename) + "-" + GlobalVariables.SCENARIO_NAME + "-" + timestamp + ".1.csv";
        String outDir = GlobalVariables.OUTPUT_DIR;
        String outpath = String.valueOf(outDir) + File.separatorChar + filename;
        File outfile = new File(outpath);
        if (outfile.exists()) {
            int hashCode = System.identityHashCode(filename);
            filename = String.valueOf(defaultFilename) + "_" + timestamp + "_" + hashCode + ".1.csv";
            outpath = String.valueOf(outDir) + File.pathSeparator + filename;
            outfile = new File(outpath);
        }
        try {
            outfile.createNewFile();
            if (!outfile.canWrite()) {
                throw new IOException("Can't write to file.");
            }
            outfile.delete();
        }
        catch (IOException ioe) {
            try {
                outfile = File.createTempFile(filename, "csv");
            }
            catch (IOException ioe2) {
                return null;
            }
        }
        return outfile.getAbsolutePath();
    }
}

