/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.ContextCreator;
import evacSim.citycontext.CityContext;
import evacSim.citycontext.House;
import evacSim.citycontext.Junction;
import evacSim.citycontext.Road;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.log4j.Logger;
import repast.simphony.space.gis.Geography;

public class Zone {
    Logger logger = ContextCreator.logger;
    private int id;
    private int totalevacuationvehicles;
    private ArrayList<House> houses;
    private ArrayList<Integer> destination;
    private ArrayList<Integer> time;
    private int integerID;
    private String charID;
    private int type;
    private String name;
    private int capacity;
    private int occupancy;
    private Queue<Vehicle> waiting;
    private Coordinate coord;
    private Road road;
    private Road departureRoad;
    private Junction downJunc;
    private int lastRecordedOccupancy = 0;

    public Zone() {
        this.id = ContextCreator.generateAgentID();
        this.type = 1;
        this.houses = new ArrayList();
    }

    public Zone(int integerID) {
        this.integerID = integerID;
        this.id = ContextCreator.generateAgentID();
        this.houses = new ArrayList();
        this.type = 0;
        this.name = null;
        this.occupancy = 0;
        this.capacity = 0;
        this.waiting = new LinkedList<Vehicle>();
    }

    public Zone(int integerID, int type, int capacity) {
        this(integerID);
        this.type = type;
        this.capacity = capacity;
    }

    public String toString() {
        return "<Zone" + this.integerID + ">";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getCharID() {
        return this.charID;
    }

    public void setCharID(String charID) {
        this.charID = charID;
    }

    public int getIntegerId() {
        return this.integerID;
    }

    public void setIntegerId(int id) {
        this.integerID = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setGeometry(Geography<Zone> zoneGeography) {
        this.coord = zoneGeography.getGeometry((Object)this).getCentroid().getCoordinate();
    }

    public void setRoad() {
        CityContext cityContext = ContextCreator.getCityContext();
        this.road = cityContext.findRoadAtCoordinates(this.coord, true);
        this.departureRoad = cityContext.findRoadAtCoordinates(this.coord, false);
    }

    public Coordinate getCoord() {
        return this.coord;
    }

    public Road getRoad() {
        return this.road;
    }

    public Road getdepartureRoad() {
        return this.departureRoad;
    }

    public Junction getDownJunc() {
        return this.downJunc;
    }

    public void setDownJunc(Junction junc) {
        this.downJunc = junc;
    }

    public int getEvacuatingDemand() {
        return this.totalevacuationvehicles;
    }

    public ArrayList<Integer> getDestinationPerVehicle() {
        return this.destination;
    }

    public ArrayList<Integer> getEvacuationTimePerVehicle() {
        return this.time;
    }

    public void setEvacuationDemand() {
        this.destination = new ArrayList();
        this.time = new ArrayList();
        int i = 0;
        while (i < this.houses.size()) {
            House h = this.houses.get(i);
            int thishouseholdevacuate = h.getEvacuate();
            if (thishouseholdevacuate == 1) {
                int evacuationdestination = h.getDestZone();
                int evacuationtime = h.getEvacuationTime();
                this.destination.add(evacuationdestination);
                this.time.add(evacuationtime);
            }
            ++i;
        }
        this.totalevacuationvehicles = this.destination.size();
    }

    public ArrayList<House> getHouses() {
        return this.houses;
    }

    public void setHouses(ArrayList<House> houses) {
        this.houses = houses;
    }

    public void printHouses() {
        this.logger.info((Object)("Zone number of houses in zone " + this.houses.size()));
        int i = 0;
        while (i < this.houses.size()) {
            House h = this.houses.get(i);
            this.logger.info((Object)("Zone House " + h.getId() + ": is in Zone = " + h.getZoneId() + ", Evacuates? " + h.getEvacuate() + ", at evacuation time = " + h.getEvacuationTime() + ", to destZone: " + h.getDestZone()));
            ++i;
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int cap) {
        this.capacity = cap;
    }

    public int getOccupancy() {
        return this.occupancy;
    }

    public void setOccupancy(int occupied) {
        this.occupancy = occupied;
    }

    public int getAvailability() {
        return this.capacity - this.occupancy;
    }

    public int getLastRecordedOccupancy() {
        return this.lastRecordedOccupancy;
    }

    public void setLastRecordedOccupancy(int value) {
        this.lastRecordedOccupancy = value;
    }

    public Queue<Vehicle> getWaiting() {
        if (this.waiting == null) {
            this.waiting = new LinkedList<Vehicle>();
        }
        return this.waiting;
    }

    public void addWaiting(Vehicle veh) {
        if (this.waiting == null) {
            this.waiting = new LinkedList<Vehicle>();
        }
        this.waiting.add(veh);
    }

    public boolean receiveEvacuee() {
        if (this.getType() != 1) {
            try {
                throw new NoSuchMethodException("Only shelters can receive evacuees!");
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (this.occupancy < this.capacity) {
            ++this.occupancy;
            return true;
        }
        return false;
    }
}

