/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.Road;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import repast.simphony.context.Context;
import repast.simphony.context.DefaultContext;
import repast.simphony.context.space.gis.GeographyFactoryFinder;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.gis.GeographyParameters;
import repast.simphony.space.gis.ShapefileLoader;

public class RoadContext
extends DefaultContext<Road> {
    private Logger logger = ContextCreator.logger;
    private static Map<Coordinate, ?> coordCache;

    public RoadContext() {
        super((Object)"RoadContext");
        this.logger.info((Object)"RoadContext creation");
        coordCache = new HashMap();
        GeographyParameters geoParams = new GeographyParameters();
        Geography roadGeography = GeographyFactoryFinder.createGeographyFactory(null).createGeography("RoadGeography", (Context)this, geoParams);
        File roadFile = null;
        ShapefileLoader roadLoader = null;
        String fileName = GlobalVariables.ROADS_CSV;
        try {
            roadFile = new File(GlobalVariables.ROADS_SHAPEFILE);
            URI uri = roadFile.toURI();
            roadLoader = new ShapefileLoader(Road.class, uri.toURL(), roadGeography, (Context)this);
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            while (roadLoader.hasNext()) {
                Road road = (Road)roadLoader.next();
                String line = br.readLine();
                String[] result = line.split(",");
                road = this.setAttribute(road, result);
                Geometry roadGeom = roadGeography.getGeometry((Object)road);
                Coordinate[] coordinateArray = roadGeom.getCoordinates();
                int n = coordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate c = coordinateArray[n2];
                    coordCache.put(c, null);
                    ++n2;
                }
            }
            br.close();
        }
        catch (MalformedURLException e) {
            System.out.println("ContextCreator: malformed URL exception when reading roadshapefile. Check the 'roadLoc' parameter is correct");
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.out.println("ContextCreator: No road csv file found");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean onRoad(Coordinate c) {
        return coordCache.containsKey(c);
    }

    public Road setAttribute(Road r, String[] att) {
        r.setLinkid(Integer.parseInt(att[0]));
        r.setLeft(Integer.parseInt(att[2]));
        r.setThrough(Integer.parseInt(att[3]));
        r.setRight(Integer.parseInt(att[4]));
        r.setTlinkid(Integer.parseInt(att[5]));
        r.setFn(Integer.parseInt(att[6]));
        r.setTn(Integer.parseInt(att[7]));
        return r;
    }
}

