/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import evacSim.ContextCreator;
import evacSim.GlobalVariables;
import evacSim.citycontext.Road;
import evacSim.vehiclecontext.Vehicle;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class Lane {
    Logger logger = ContextCreator.logger;
    private int id = ContextCreator.generateAgentID();
    private int laneid;
    private int link;
    private int left;
    private int through;
    private int right;
    private float length;
    private Road road_;
    private int nVehicles_ = 0;
    private Vehicle firstVehicle_;
    private Vehicle lastVehicle_ = null;
    private double accumulatedDensity_;
    private double accumulatedSpeed_;
    private float speed_;
    private float maxSpeed_;
    private int upConnections_;
    private int downConnections_;
    private ArrayList<Lane> upLanes_ = new ArrayList();
    private ArrayList<Lane> dnLanes_ = new ArrayList();
    private int index;
    private int lastEnterTick = -1;

    public String toString() {
        return "<Lane" + this.laneid + "@Road" + this.link + ">";
    }

    public void updateLastEnterTick(int current_tick) {
        this.lastEnterTick = current_tick;
    }

    public int getLastEnterTick() {
        return this.lastEnterTick;
    }

    public int getLaneid() {
        return this.laneid;
    }

    public void setLaneid(int laneid) {
        this.laneid = laneid;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public float getLength() {
        return this.length;
    }

    public int getLink() {
        return this.link;
    }

    public void setLink(int link) {
        this.link = link;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getLeft() {
        return this.left;
    }

    public void setThrough(int through) {
        this.through = through;
    }

    public int getThrough() {
        return this.through;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public int getRight() {
        return this.right;
    }

    public void printShpInput() {
        this.logger.info((Object)("Repast Lane ID: " + this.id + " Lane ID: " + this.laneid + " link " + this.link + " L: " + this.left + " T: " + this.through + " R: " + this.right + " Repast road ID " + this.road_.getID()));
    }

    public void setRoad(Road road) {
        this.road_ = road;
        road.addLane(this);
    }

    public float speed() {
        return this.speed_;
    }

    public void resetStatistics() {
        this.accumulatedSpeed_ = 0.0;
        this.accumulatedDensity_ = 0.0;
    }

    public void firstVehicle(Vehicle v) {
        if (v != null) {
            this.firstVehicle_ = v;
            v.leading(null);
        } else {
            this.firstVehicle_ = null;
        }
    }

    public void lastVehicle(Vehicle v) {
        if (v != null) {
            this.lastVehicle_ = v;
            v.trailing(null);
        } else {
            this.lastVehicle_ = null;
        }
    }

    public float maxSpeed() {
        return this.maxSpeed_;
    }

    public Vehicle firstVehicle() {
        return this.firstVehicle_;
    }

    public Vehicle lastVehicle() {
        return this.lastVehicle_;
    }

    public float calcMaxSpeed() {
        return this.maxSpeed_;
    }

    public Road road_() {
        return this.road_;
    }

    public int getID() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex() {
        this.index = this.road_.getLaneIndex(this);
    }

    public Vehicle lastInDnLane() {
        Vehicle last = null;
        double mindis = 3.4028234663852886E38;
        int i = 0;
        while (i < this.dnLanes_.size()) {
            double dis;
            Lane dlane = this.dnLanes_.get(i);
            Vehicle pv = dlane.lastVehicle_;
            if (pv != null && (dis = (double)(dlane.getLength() - (pv.distance() + pv.length()))) < mindis) {
                mindis = dis;
                last = pv;
            }
            ++i;
        }
        return last;
    }

    public void upConnection(int n) {
        this.upConnections_ = n;
    }

    public void downConnection(int n) {
        this.downConnections_ = n;
    }

    public ArrayList<Lane> getDnLanes() {
        return this.dnLanes_;
    }

    public ArrayList<Lane> getUpLanes() {
        return this.upLanes_;
    }

    public void addDnLane(Lane l) {
        this.dnLanes_.add(l);
    }

    public Lane getDnLane(int i) {
        return this.dnLanes_.get(i);
    }

    public void addUpLane(Lane l) {
        this.upLanes_.add(l);
    }

    public Lane getUpLane(int i) {
        return this.upLanes_.get(i);
    }

    public Lane getUpStreamConnection(Road pr) {
        Lane connectLane = null;
        for (Lane ul : this.getUpLanes()) {
            if (!ul.road_().equals(pr)) continue;
            connectLane = ul;
            break;
        }
        return connectLane;
    }

    public double lengthRoad() {
        return this.road_.length();
    }

    public int index() {
        return this.index;
    }

    public int nVehicles() {
        return this.nVehicles_;
    }

    public int getNumVehicles() {
        return this.nVehicles_;
    }

    public void addVehicles() {
        ++this.nVehicles_;
    }

    public void removeVehicles() {
        --this.nVehicles_;
    }

    public void printLaneConnection() {
        this.logger.info((Object)("Road: " + this.road_.getLinkid() + " lane " + this.laneid + " has downstream connections: "));
        int i = 0;
        while (i < this.dnLanes_.size()) {
            this.logger.info((Object)("To Lane: " + this.dnLanes_.get((int)i).laneid + " of road: " + this.dnLanes_.get((int)i).road_.getLinkid()));
            ++i;
        }
        this.logger.info((Object)"and with upstream connection: ");
        i = 0;
        while (i < this.upLanes_.size()) {
            this.logger.info((Object)("To Lane: " + this.upLanes_.get((int)i).laneid + " of road: " + this.upLanes_.get((int)i).road_.getLinkid()));
            ++i;
        }
    }

    public boolean isConnectToLane(Lane pl) {
        boolean connectFlag = false;
        if (pl != null) {
            for (Lane ul : pl.getUpLanes()) {
                if (!ul.equals(this)) continue;
                connectFlag = true;
            }
        }
        return connectFlag;
    }

    public Lane betterLane(Lane plane) {
        if (this != null && plane != null) {
            if (this.nVehicles_ < plane.nVehicles_) {
                return this;
            }
            if (this.nVehicles_ > plane.nVehicles_) {
                return plane;
            }
            double randomnumber = GlobalVariables.RandomGenerator.nextDouble();
            if (randomnumber > 0.5) {
                return this;
            }
            return plane;
        }
        if (this != null) {
            return this;
        }
        if (plane != null) {
            return plane;
        }
        return null;
    }
}

