/*
 * Decompiled with CFR 0.152.
 */
package evacSim.citycontext;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.ContextCreator;
import evacSim.citycontext.Plan;
import evacSim.citycontext.Zone;
import java.util.ArrayList;

public class House {
    private int id;
    private Zone zone;
    private ArrayList<Plan> activityplan;
    private int zoneid;
    private int evacuate;
    private int evacuationtime;
    private int destzone;
    private int numPeople;

    public House() {
        this.id = ContextCreator.generateAgentID();
        this.zoneid = 0;
        this.evacuate = 0;
        this.evacuationtime = 0;
        this.destzone = 0;
        this.numPeople = 0;
    }

    public House(int ID, int zone) {
        this.id = ID;
        this.zoneid = zone;
        this.activityplan = new ArrayList();
    }

    public String toString() {
        return "House<" + this.id + ", " + this.zoneid + ">";
    }

    public int getId() {
        return this.id;
    }

    public Coordinate getCoord() {
        return ContextCreator.getZoneGeography().getGeometry((Object)this).getCentroid().getCoordinate();
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getZoneId() {
        return this.zoneid;
    }

    public void setZone(Zone z) {
        this.zone = z;
    }

    public Zone getZone() {
        return this.zone;
    }

    public int getNumPeople() {
        return this.numPeople;
    }

    public int getEvacuate() {
        return this.evacuate;
    }

    public void setActivityPlan(ArrayList<Integer> locations, ArrayList<Integer> durations) {
        int i = 0;
        while (i < locations.size()) {
            Plan p = new Plan(locations.get(i), durations.get(i));
            this.activityplan.add(p);
            ++i;
        }
        this.destzone = locations.get(locations.size() - 1);
    }

    public void addActivityPlan(Plan plan) {
        this.activityplan.add(plan);
        this.destzone = plan.getLocation();
    }

    public ArrayList<Plan> getActivityPlan() {
        return this.activityplan;
    }

    public void removePlan(Plan p) {
        this.activityplan.remove(p);
    }

    public int getEvacuationTime() {
        return this.evacuationtime;
    }

    public int getDestZone() {
        return this.destzone;
    }
}

