/*
 * Decompiled with CFR 0.152.
 */
package evacSim;

import com.vividsolutions.jts.geom.Coordinate;
import evacSim.BackgroundTraffic;
import evacSim.GlobalVariables;
import evacSim.NetworkEventHandler;
import evacSim.ThreadedScheduler;
import evacSim.citycontext.CityContext;
import evacSim.citycontext.Junction;
import evacSim.citycontext.JunctionContext;
import evacSim.citycontext.Lane;
import evacSim.citycontext.LaneContext;
import evacSim.citycontext.Road;
import evacSim.citycontext.RoadContext;
import evacSim.citycontext.Zone;
import evacSim.citycontext.ZoneContext;
import evacSim.data.DataCollectionContext;
import evacSim.partition.MetisPartition;
import evacSim.vehiclecontext.Vehicle;
import evacSim.vehiclecontext.VehicleContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.geotools.referencing.GeodeticCalculator;
import repast.simphony.context.Context;
import repast.simphony.dataLoader.ContextBuilder;
import repast.simphony.engine.environment.RunEnvironment;
import repast.simphony.engine.schedule.ISchedule;
import repast.simphony.engine.schedule.ScheduleParameters;
import repast.simphony.space.gis.Geography;
import repast.simphony.space.graph.Network;

public class ContextCreator
implements ContextBuilder<Object> {
    public static Logger logger;
    public static BufferedWriter bw;
    private static Context<Object> mainContext;
    private static int agentID;
    public static double startTime;
    private static int duration_;
    private static int duration02_;
    private static int duration03_;
    public static MetisPartition partitioner;
    public static NetworkEventHandler eventHandler;
    public static BackgroundTraffic backgroundtraffic;

    static {
        agentID = 0;
        duration_ = (int)(3600.0f / GlobalVariables.SIMULATION_STEP_SIZE);
        duration02_ = GlobalVariables.SIMULATION_NETWORK_REFRESH_INTERVAL;
        duration03_ = GlobalVariables.SIMULATION_PARTITION_REFRESH_INTERVAL;
        partitioner = new MetisPartition(GlobalVariables.N_Partition);
        eventHandler = new NetworkEventHandler();
        backgroundtraffic = new BackgroundTraffic();
    }

    public Context<Object> build(Context<Object> context) {
        String scenarioName;
        Properties propertyFile = new Properties();
        try {
            propertyFile.load(new FileInputStream("data/Data.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GlobalVariables.SCENARIO_NAME = scenarioName = ContextCreator.setScenarioName();
        ContextCreator.updateOutputDirectory();
        this.setSimulationLogger();
        mainContext = context;
        while (GlobalVariables.SIMULATION_SLEEPS == 0) {
            try {
                Thread.sleep(1000L);
                logger.info((Object)"Waiting for visualization");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        CityContext cityContext = new CityContext();
        context.addSubContext((Context)cityContext);
        cityContext.createSubContexts();
        cityContext.buildRoadNetwork();
        cityContext.createNearestRoadCoordCache();
        logger.info((Object)"Create other context");
        VehicleContext vehicleContext = new VehicleContext();
        logger.info((Object)("Create vehicleContext: " + vehicleContext.getTypeID()));
        context.addSubContext((Context)vehicleContext);
        logger.info((Object)"Adding vehicleContext");
        DataCollectionContext dataContext = new DataCollectionContext();
        context.addSubContext((Context)dataContext);
        for (Context con : context.getSubContexts()) {
            logger.info((Object)("SubContext typeIDs: " + con.getTypeID()));
        }
        for (Lane lane : ContextCreator.getLaneGeography().getAllObjects()) {
            Coordinate[] coords = ContextCreator.getLaneGeography().getGeometry((Object)lane).getCoordinates();
            float distance = 0.0f;
            int i = 0;
            while (i < coords.length - 1) {
                distance = (float)((double)distance + this.getDistance(coords[i], coords[i + 1]));
                ++i;
            }
            lane.setLength(distance);
        }
        RunEnvironment.getInstance().endAt((double)GlobalVariables.SIMULATION_STOP_TIME);
        ISchedule schedule = RunEnvironment.getInstance().getCurrentSchedule();
        ScheduleParameters endParams = ScheduleParameters.createAtEnd((double)Double.NEGATIVE_INFINITY);
        schedule.schedule(endParams, (Object)this, "end", new Object[0]);
        ScheduleParameters startParams = ScheduleParameters.createOneTime((double)1.0);
        schedule.schedule(startParams, (Object)this, "start", new Object[0]);
        if (GlobalVariables.ENABLE_SIMULATION_STOP_IF_NO_VEHICLE) {
            ScheduleParameters endIfNoVehicleParams = ScheduleParameters.createRepeating((double)0.0, (double)GlobalVariables.SIMULATION_STOP_IF_NO_VEHICLE_CHECK_INTERVAL, (double)Double.NEGATIVE_INFINITY);
            schedule.schedule(endIfNoVehicleParams, (Object)this, "endIfNoVehicle", new Object[0]);
        }
        ScheduleParameters agentParamsNW = ScheduleParameters.createRepeating((double)0.0, (double)duration02_, (double)3.0);
        schedule.schedule(agentParamsNW, (Object)cityContext, "modifyRoadNetwork", new Object[0]);
        ScheduleParameters speedProfileParams = ScheduleParameters.createRepeating((double)0.0, (double)duration_, (double)4.0);
        for (Road r : ContextCreator.getRoadContext().getObjects(Road.class)) {
            schedule.schedule(speedProfileParams, (Object)r, "updateFreeFlowSpeed", new Object[0]);
        }
        ScheduleParameters demandLoadingParams = ScheduleParameters.createRepeating((double)0.0, (double)duration_, (double)5.0);
        schedule.schedule(demandLoadingParams, (Object)cityContext, "loadDemandOfNextHour", new Object[0]);
        ScheduleParameters supplySideEventParams = ScheduleParameters.createRepeating((double)0.0, (double)GlobalVariables.EVENT_CHECK_FREQUENCY, (double)1.0);
        schedule.schedule(supplySideEventParams, (Object)eventHandler, "checkEvents", new Object[0]);
        if (GlobalVariables.DYNAMIC_DEST_STRATEGY == 3) {
            ScheduleParameters soShelterRoutingParams = ScheduleParameters.createRepeating((double)1.0, (double)GlobalVariables.SO_SHELTER_MATCHING_INTERVAL, (double)6.0);
            schedule.schedule(soShelterRoutingParams, (Object)cityContext, "soShelterRoutingSchedule", new Object[0]);
        }
        if (GlobalVariables.MULTI_THREADING) {
            ThreadedScheduler s = new ThreadedScheduler(GlobalVariables.N_Partition);
            ScheduleParameters agentParaParams = ScheduleParameters.createRepeating((double)1.0, (double)1.0, (double)0.0);
            schedule.schedule(agentParaParams, (Object)s, "paraStep", new Object[0]);
            ScheduleParameters endParallelParams = ScheduleParameters.createAtEnd((double)1.0);
            schedule.schedule(endParallelParams, (Object)s, "shutdownScheduler", new Object[0]);
            ScheduleParameters timerParaParams = ScheduleParameters.createRepeating((double)1.0, (double)duration03_, (double)0.0);
            schedule.schedule(timerParaParams, (Object)s, "reportTime", new Object[0]);
        } else {
            ScheduleParameters agentParams = ScheduleParameters.createRepeating((double)1.0, (double)1.0, (double)0.0);
            ThreadedScheduler s = new ThreadedScheduler(GlobalVariables.N_Partition);
            schedule.schedule(agentParams, (Object)s, "step", new Object[0]);
            double delay = agentParams.getDuration();
            logger.info((Object)("TIME BETWEEN TWO TICKS " + delay));
        }
        if (GlobalVariables.MULTI_THREADING) {
            ScheduleParameters partitionParams = ScheduleParameters.createRepeating((double)duration03_, (double)duration03_, (double)2.0);
            ScheduleParameters initialPartitionParams = ScheduleParameters.createOneTime((double)0.0, (double)2.0);
            schedule.schedule(initialPartitionParams, (Object)partitioner, "first_run", new Object[0]);
            schedule.schedule(partitionParams, (Object)partitioner, "check_run", new Object[0]);
        }
        double tickDuration = GlobalVariables.FREQ_RECORD_VEH_SNAPSHOT_FORVIZ;
        if (GlobalVariables.ENABLE_DATA_COLLECTION) {
            ScheduleParameters dataStartParams = ScheduleParameters.createOneTime((double)0.0, (double)Double.POSITIVE_INFINITY);
            schedule.schedule(dataStartParams, (Object)dataContext, "startCollecting", new Object[0]);
            ScheduleParameters dataEndParams = ScheduleParameters.createAtEnd((double)Double.NEGATIVE_INFINITY);
            schedule.schedule(dataEndParams, (Object)dataContext, "stopCollecting", new Object[0]);
            ScheduleParameters tickStartParams = ScheduleParameters.createRepeating((double)0.0, (double)tickDuration, (double)Double.POSITIVE_INFINITY);
            schedule.schedule(tickStartParams, (Object)dataContext, "startTick", new Object[0]);
            ScheduleParameters tickEndParams = ScheduleParameters.createRepeating((double)0.0, (double)tickDuration, (double)Double.NEGATIVE_INFINITY);
            schedule.schedule(tickEndParams, (Object)dataContext, "stopTick", new Object[0]);
            ScheduleParameters recordShelterSnapshotParams = ScheduleParameters.createRepeating((double)0.0, (double)GlobalVariables.FREQ_RECORD_SHELT_SNAPSHOT_FORVIZ, (double)6.0);
            schedule.schedule(recordShelterSnapshotParams, (Object)ContextCreator.getZoneContext(), "recordShelterStatus", new Object[0]);
            ScheduleParameters recordRuntimeParams = ScheduleParameters.createRepeating((double)0.0, (double)GlobalVariables.RUNTIME_RECORD_INTERVAL, (double)6.0);
            schedule.schedule(recordRuntimeParams, (Object)dataContext, "recordRuntime", new Object[0]);
            ContextCreator.createVehicleLogger();
        }
        agentID = 0;
        return context;
    }

    public void printTick() {
        logger.info((Object)("Tick: " + RunEnvironment.getInstance().getCurrentSchedule().getTickCount()));
    }

    public static void stopSim(Exception ex, Class<?> clazz) {
        ISchedule sched = RunEnvironment.getInstance().getCurrentSchedule();
        sched.setFinishing(true);
        sched.executeEndActions();
        logger.info((Object)("ContextCreator has been told to stop by  " + clazz.getName() + ex));
    }

    public static void end() {
        logger.info((Object)("Finished sim: " + ((double)System.currentTimeMillis() - startTime)));
        try {
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void endIfNoVehicle() {
        int nGenerated = GlobalVariables.NUM_GENERATED_VEHICLES;
        int nDestroyed = GlobalVariables.NUM_KILLED_VEHICLES;
        int nHouses = GlobalVariables.NUM_HOUSES;
        if (nGenerated >= nHouses - 1 && nGenerated <= nDestroyed && RunEnvironment.getInstance().getCurrentSchedule().getTickCount() > (double)GlobalVariables.DEMAND_MAX_TICK) {
            ISchedule sched = RunEnvironment.getInstance().getCurrentSchedule();
            sched.setFinishing(true);
            sched.executeEndActions();
        }
    }

    public static void start() {
        startTime = System.currentTimeMillis();
    }

    public static int generateAgentID() {
        return agentID++;
    }

    public static VehicleContext getVehicleContext() {
        return (VehicleContext)mainContext.findContext((Object)"VehicleContext");
    }

    public static Geography<Vehicle> getVehicleGeography() {
        return (Geography)ContextCreator.getVehicleContext().getProjection("VehicleGeography");
    }

    public static JunctionContext getJunctionContext() {
        return (JunctionContext)mainContext.findContext((Object)"JunctionContext");
    }

    public static Geography<Junction> getJunctionGeography() {
        return (Geography)ContextCreator.getJunctionContext().getProjection(Geography.class, "JunctionGeography");
    }

    public static Network<Junction> getRoadNetwork() {
        return (Network)ContextCreator.getJunctionContext().getProjection(Network.class, "RoadNetwork");
    }

    public static RoadContext getRoadContext() {
        return (RoadContext)mainContext.findContext((Object)"RoadContext");
    }

    public static Geography<Road> getRoadGeography() {
        return (Geography)ContextCreator.getRoadContext().getProjection("RoadGeography");
    }

    public static LaneContext getLaneContext() {
        return (LaneContext)mainContext.findContext((Object)"LaneContext");
    }

    public static Geography<Lane> getLaneGeography() {
        return (Geography)ContextCreator.getLaneContext().getProjection("LaneGeography");
    }

    public static CityContext getCityContext() {
        return (CityContext)mainContext.findContext((Object)"CityContext");
    }

    public static ZoneContext getZoneContext() {
        return (ZoneContext)mainContext.findContext((Object)"ZoneContext");
    }

    public static Geography<Zone> getZoneGeography() {
        return (Geography)ContextCreator.getZoneContext().getProjection("ZoneGeography");
    }

    public static DataCollectionContext getDataCollectionContext() {
        return (DataCollectionContext)mainContext.findContext((Object)"DataCollectionContext");
    }

    public static double convertToMeters(double dist) {
        double distInMeters = NonSI.NAUTICAL_MILE.getConverterTo(SI.METER).convert(dist * 60.0);
        return distInMeters;
    }

    private double getDistance(Coordinate c1, Coordinate c2) {
        double distance;
        GeodeticCalculator calculator = new GeodeticCalculator(ContextCreator.getLaneGeography().getCRS());
        calculator.setStartingGeographicPoint(c1.x, c1.y);
        calculator.setDestinationGeographicPoint(c2.x, c2.y);
        try {
            distance = calculator.getOrthodromicDistance();
        }
        catch (AssertionError ex) {
            logger.error((Object)"Error with finding distance");
            distance = 0.0;
        }
        return distance;
    }

    public static void createVehicleLogger() {
        String outDir = GlobalVariables.OUTPUT_DIR;
        String basename = "";
        if (GlobalVariables.ORGANIZE_OUTPUT_BY_ACTIVITY_FNAME) {
            String[] temp = GlobalVariables.OUTPUT_DIR.split("/");
            basename = temp[temp.length - 1];
        }
        String timestamp = new SimpleDateFormat("YYYY-MM-dd-hh-mm-ss").format(new Date());
        String outpath = String.valueOf(outDir) + File.separatorChar + "logger-vehicles-" + basename + "-" + timestamp + ".csv";
        try {
            FileWriter fw = new FileWriter(outpath, false);
            bw = new BufferedWriter(fw);
            bw.write("vehicleID;zoneType;startTime;endTime;originID;destID;totalDistance;visitedShelters; visitedRoad; visitedTime");
            bw.newLine();
            bw.flush();
            logger.info((Object)"Vehicle logger created");
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)"Vehicle logger failed");
        }
    }

    public static String setScenarioName() {
        String[] temp1 = GlobalVariables.ACTIVITY_CSV.split("/");
        String temp2 = temp1[temp1.length - 1];
        String scenarioName = temp2.substring(0, temp2.lastIndexOf(46));
        if (scenarioName == null || scenarioName.length() <= 0) {
            System.err.println("Invalid scenario name");
        }
        return scenarioName;
    }

    public static String updateOutputDirectory() {
        String outDir;
        if (GlobalVariables.ORGANIZE_OUTPUT_BY_ACTIVITY_FNAME) {
            outDir = GlobalVariables.DEFAULT_OUTPUT_DIR;
            outDir = String.valueOf(outDir) + "/" + GlobalVariables.SCENARIO_NAME;
            try {
                Files.createDirectories(Paths.get(outDir, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            GlobalVariables.OUTPUT_DIR = outDir;
        } else {
            outDir = GlobalVariables.DEFAULT_OUTPUT_DIR;
        }
        return outDir;
    }

    public void setSimulationLogger() {
        String logFilePath = String.valueOf(GlobalVariables.OUTPUT_DIR) + File.separatorChar + "logger-sim-" + GlobalVariables.SCENARIO_NAME + "-" + new SimpleDateFormat("YYYY-MM-dd-hh-mm-ss").format(new Date()) + ".log";
        System.setProperty("logFilePath", logFilePath);
        logger = Logger.getLogger(this.getClass());
        PropertyConfigurator.configure((String)GlobalVariables.LOGGER_PROPERTIES);
        logger.info((Object)"Logging started");
    }
}

