/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.PluginLifecycleHandler;
import org.java.plugin.standard.StandardPluginClassLoader;
import org.java.plugin.util.ExtendedProperties;

public class StandardPluginLifecycleHandler
extends PluginLifecycleHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean probeParentLoaderLast;

    protected PluginClassLoader createPluginClassLoader(final PluginDescriptor pluginDescriptor) {
        StandardPluginClassLoader standardPluginClassLoader = (StandardPluginClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new StandardPluginClassLoader(StandardPluginLifecycleHandler.this.getPluginManager(), pluginDescriptor, StandardPluginLifecycleHandler.this.getClass().getClassLoader());
            }
        });
        standardPluginClassLoader.setProbeParentLoaderLast(this.probeParentLoaderLast);
        return standardPluginClassLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Plugin createPluginInstance(PluginDescriptor pluginDescriptor) throws PluginLifecycleException {
        Class<?> clazz;
        String string = pluginDescriptor.getPluginClassName();
        try {
            clazz = this.getPluginManager().getPluginClassLoader(pluginDescriptor).loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassNotFound", string, classNotFoundException);
        }
        try {
            try {
                return (Plugin)clazz.newInstance();
            }
            catch (Exception exception) {
                try {
                    this.log.warn((Object)("attempt to instantiate Plugin class for plug-in " + pluginDescriptor.getUniqueId() + " with no-arguments" + " constructor failed, fall-back to the deprecated" + " two-arguments constructor"), (Throwable)exception);
                    return (Plugin)clazz.getConstructor(PluginManager.class, PluginDescriptor.class).newInstance(this.getPluginManager(), pluginDescriptor);
                }
                catch (Exception exception2) {
                    throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", pluginDescriptor.getId(), exception2);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable;
            Throwable throwable2 = invocationTargetException.getTargetException();
            String string2 = pluginDescriptor.getId();
            if (throwable2 != null) {
                throwable = throwable2;
                throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", string2, throwable);
            }
            throwable = invocationTargetException;
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", string2, throwable);
        }
    }

    protected void beforePluginStart(Plugin plugin) {
    }

    protected void afterPluginStop(Plugin plugin) {
    }

    protected void dispose() {
    }

    public void configure(ExtendedProperties extendedProperties) {
        this.probeParentLoaderLast = "true".equalsIgnoreCase(extendedProperties.getProperty("probeParentLoaderLast", "false"));
        this.log.debug((Object)("probeParentLoaderLast parameter value is " + this.probeParentLoaderLast));
    }
}

