/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

final class RegexpFileFilter
implements FileFilter {
    private final Pattern[] patterns;

    RegexpFileFilter(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
        this.patterns = new Pattern[stringTokenizer.countTokens()];
        for (int i = 0; i < this.patterns.length; ++i) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null || string2.trim().length() == 0) continue;
            this.patterns[i] = Pattern.compile(string2.trim());
        }
    }

    public boolean accept(File file) {
        for (int i = 0; i < this.patterns.length; ++i) {
            if (this.patterns[i] == null || !this.patterns[i].matcher(file.getName()).matches()) continue;
            return true;
        }
        return false;
    }
}

