/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.UniqueIdentity;
import org.java.plugin.registry.Version;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ManifestParser;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;
import org.java.plugin.util.ExtendedProperties;

public final class PluginRegistryImpl
implements PluginRegistry {
    static final String PACKAGE_NAME = "org.java.plugin.registry.xml";
    private static final char UNIQUE_SEPARATOR = '@';
    private static final Log log = LogFactory.getLog(PluginRegistryImpl.class);
    private final List registrationReport = new LinkedList();
    private final Map registeredPlugins = new HashMap();
    private final Map registeredFragments = new HashMap();
    private final List listeners = Collections.synchronizedList(new LinkedList());
    private ManifestParser manifestParser;
    private boolean stopOnError = false;

    public PluginRegistryImpl() {
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registryStart", null));
    }

    public void configure(ExtendedProperties extendedProperties) {
        this.stopOnError = "true".equalsIgnoreCase(extendedProperties.getProperty("stopOnError", "false"));
        boolean bl = !"false".equalsIgnoreCase(extendedProperties.getProperty("isValidating", "true"));
        this.manifestParser = new ManifestParser(bl);
        log.info((Object)("configured, stopOnError=" + this.stopOnError + ", isValidating=" + bl));
    }

    public PluginRegistry.ManifestInfo readManifestInfo(URL uRL) throws ManifestProcessingException {
        try {
            return new ManifestInfoImpl(this.manifestParser.parseManifestInfo(uRL));
        }
        catch (Exception exception) {
            throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", uRL, exception);
        }
    }

    public Map register(URL[] uRLArray) throws ManifestProcessingException {
        UniqueIdentity uniqueIdentity2;
        Object object;
        Map.Entry entry2;
        Iterator iterator2;
        Object object22;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        Object object3 = this.registeredPlugins.values().iterator();
        while (object3.hasNext()) {
            for (Object object22 : ((PluginDescriptor)object3.next()).getExtensionPoints()) {
                linkedList.add(object22);
                for (Iterator iterator2 : object22.getConnectedExtensions()) {
                    hashMap.put(iterator2.getUniqueId(), (Extension)((Object)iterator2));
                }
            }
        }
        object3 = new HashMap(uRLArray.length);
        HashMap hashMap2 = new HashMap();
        object22 = new HashMap();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "manifestsParsingStart", null));
        for (int i = 0; i < uRLArray.length; ++i) {
            iterator2 = uRLArray[i];
            try {
                entry2 = this.manifestParser.parseManifest((URL)((Object)iterator2));
            }
            catch (Exception exception) {
                log.error((Object)("can't parse manifest file " + iterator2), (Throwable)exception);
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "manifestParsingError", iterator2, exception);
                }
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "manifestParsingError", new Object[]{iterator2, exception}));
                continue;
            }
            if (entry2 instanceof ModelPluginFragment) {
                object22.put(iterator2, entry2);
                continue;
            }
            if (!(entry2 instanceof ModelPluginDescriptor)) {
                log.warn((Object)("URL " + iterator2 + " points to XML document of unknown type"));
                continue;
            }
            hashMap2.put(iterator2, entry2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("manifest files parsed, plugins.size=" + hashMap2.size() + ", fragments.size=" + object22.size()));
        }
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "manifestsParsingFinish", new Object[]{new Integer(hashMap2.size()), new Integer(object22.size())}));
        this.checkVersions(hashMap2);
        if (log.isDebugEnabled()) {
            log.debug((Object)("plug-ins versions checked, plugins.size=" + hashMap2.size()));
        }
        this.checkVersions((Map)object22);
        if (log.isDebugEnabled()) {
            log.debug((Object)("plug-in fragments versions checked, fragments.size=" + object22.size()));
        }
        RegistryChangeDataImpl registryChangeDataImpl = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringPluginsStart", null));
        for (Map.Entry entry2 : hashMap2.entrySet()) {
            object = (URL)entry2.getKey();
            uniqueIdentity2 = this.registerPlugin((URL)object, (ModelPluginDescriptor)entry2.getValue(), registryChangeDataImpl);
            if (uniqueIdentity2 == null) continue;
            object3.put(object, uniqueIdentity2);
        }
        hashMap2.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringFragmentsStart", null));
        for (Map.Entry entry2 : object22.entrySet()) {
            object = (URL)entry2.getKey();
            uniqueIdentity2 = this.registerFragment((URL)object, (ModelPluginFragment)entry2.getValue(), registryChangeDataImpl);
            if (uniqueIdentity2 == null) continue;
            object3.put(object, uniqueIdentity2);
        }
        object22.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringPluginsFinish", new Integer(this.registeredPlugins.size())));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "registeringFragmentsFinish", new Integer(this.registeredFragments.size())));
        log.info((Object)("plug-in and fragment descriptors registered - " + object3.size()));
        this.dump();
        if (object3.isEmpty()) {
            return object3;
        }
        iterator2 = linkedList.iterator();
        while (iterator2.hasNext()) {
            ((ExtensionPointImpl)((Object)iterator2.next())).registryChanged();
        }
        iterator2 = hashMap.values().iterator();
        while (iterator2.hasNext()) {
            ((ExtensionImpl)((Object)iterator2.next())).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            iterator2 = this.registeredPlugins.values().iterator();
            while (iterator2.hasNext()) {
                entry2 = ((PluginDescriptor)((Object)iterator2.next())).getExtensionPoints().iterator();
                while (entry2.hasNext()) {
                    for (UniqueIdentity uniqueIdentity2 : ((ExtensionPoint)entry2.next()).getConnectedExtensions()) {
                        if (!hashMap.containsKey(uniqueIdentity2.getUniqueId())) {
                            registryChangeDataImpl.putAddedExtension(uniqueIdentity2.getUniqueId(), this.makeUniqueId(uniqueIdentity2.getExtendedPluginId(), uniqueIdentity2.getExtendedPointId()));
                            continue;
                        }
                        hashMap.remove(uniqueIdentity2.getUniqueId());
                        if (!registryChangeDataImpl.modifiedPlugins().contains(uniqueIdentity2.getDeclaringPluginDescriptor().getId()) && !registryChangeDataImpl.modifiedPlugins().contains(uniqueIdentity2.getExtendedPluginId())) continue;
                        registryChangeDataImpl.putModifiedExtension(uniqueIdentity2.getUniqueId(), this.makeUniqueId(uniqueIdentity2.getExtendedPluginId(), uniqueIdentity2.getExtendedPointId()));
                    }
                }
            }
            for (Map.Entry entry2 : hashMap.values()) {
                registryChangeDataImpl.putRemovedExtension(entry2.getUniqueId(), this.makeUniqueId(entry2.getExtendedPluginId(), entry2.getExtendedPointId()));
            }
            this.fireEvent(registryChangeDataImpl);
        }
        return object3;
    }

    private void checkVersions(Map map) throws ManifestProcessingException {
        HashMap<String, Object[]> hashMap = new HashMap<String, Object[]>();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            URL uRL = (URL)object.getKey();
            ModelPluginManifest modelPluginManifest = (ModelPluginManifest)object.getValue();
            if (this.registeredPlugins.containsKey(modelPluginManifest.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePlugin", modelPluginManifest.getId());
                }
                iterator.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "duplicatedPluginId", modelPluginManifest.getId()));
                continue;
            }
            if (this.registeredFragments.containsKey(modelPluginManifest.getId())) {
                if (this.stopOnError) {
                    throw new ManifestProcessingException(PACKAGE_NAME, "duplicatePluginFragment", modelPluginManifest.getId());
                }
                iterator.remove();
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "duplicatedFragmentId", modelPluginManifest.getId()));
                continue;
            }
            Object[] objectArray = (Object[])hashMap.get(modelPluginManifest.getId());
            if (objectArray == null) {
                hashMap.put(modelPluginManifest.getId(), new Object[]{modelPluginManifest.getVersion(), uRL});
                continue;
            }
            if (((Version)objectArray[0]).compareTo(modelPluginManifest.getVersion()) < 0) {
                hashSet.add(objectArray[1]);
                hashMap.put(modelPluginManifest.getId(), new Object[]{modelPluginManifest.getVersion(), uRL});
                continue;
            }
            hashSet.add(uRL);
        }
        hashMap.clear();
        for (Object object : hashSet) {
            map.remove(object);
            log.warn((Object)("ignoring duplicated manifest " + object));
        }
        hashSet.clear();
    }

    private PluginDescriptor registerPlugin(URL uRL, ModelPluginDescriptor modelPluginDescriptor, RegistryChangeDataImpl registryChangeDataImpl) throws ManifestProcessingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering plug-in, URL - " + uRL));
        }
        PluginDescriptorImpl pluginDescriptorImpl = null;
        try {
            pluginDescriptorImpl = new PluginDescriptorImpl(this, modelPluginDescriptor, uRL);
            registryChangeDataImpl.addedPlugins().add(pluginDescriptorImpl.getId());
            for (PluginFragmentImpl pluginFragmentImpl : this.registeredFragments.values()) {
                if (!pluginFragmentImpl.matches(pluginDescriptorImpl)) continue;
                pluginDescriptorImpl.registerFragment(pluginFragmentImpl);
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "pluginRegistered", pluginDescriptorImpl.getUniqueId()));
        }
        catch (ManifestProcessingException manifestProcessingException) {
            log.error((Object)("failed registering plug-in, URL - " + uRL), (Throwable)manifestProcessingException);
            if (this.stopOnError) {
                throw manifestProcessingException;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "pluginRegistrationFailed", new Object[]{uRL, manifestProcessingException}));
            return null;
        }
        this.registeredPlugins.put(pluginDescriptorImpl.getId(), pluginDescriptorImpl);
        return pluginDescriptorImpl;
    }

    private PluginFragment registerFragment(URL uRL, ModelPluginFragment modelPluginFragment, RegistryChangeDataImpl registryChangeDataImpl) throws ManifestProcessingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("registering plug-in fragment descriptor, URL - " + uRL));
        }
        PluginFragmentImpl pluginFragmentImpl = null;
        try {
            pluginFragmentImpl = new PluginFragmentImpl(this, modelPluginFragment, uRL);
            boolean bl = false;
            PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)this.getPluginDescriptor(pluginFragmentImpl.getPluginId());
            if (pluginFragmentImpl.matches(pluginDescriptorImpl)) {
                pluginDescriptorImpl.registerFragment(pluginFragmentImpl);
                if (!registryChangeDataImpl.addedPlugins().contains(pluginDescriptorImpl.getId())) {
                    registryChangeDataImpl.modifiedPlugins().add(pluginDescriptorImpl.getId());
                }
                bl = true;
            }
            if (!bl) {
                log.warn((Object)("no matching plug-ins found for fragment " + pluginFragmentImpl.getUniqueId()));
                this.registrationReport.add(new IntegrityChecker.ReportItemImpl(2, null, 0, "noMatchingPluginFound", pluginFragmentImpl.getUniqueId()));
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "fragmentRegistered", pluginFragmentImpl.getUniqueId()));
        }
        catch (ManifestProcessingException manifestProcessingException) {
            log.error((Object)("failed registering plug-in fragment descriptor, URL - " + uRL), (Throwable)manifestProcessingException);
            if (this.stopOnError) {
                throw manifestProcessingException;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(1, null, 2, "fragmentRegistrationFailed", new Object[]{uRL, manifestProcessingException}));
            return null;
        }
        this.registeredFragments.put(pluginFragmentImpl.getId(), pluginFragmentImpl);
        return pluginFragmentImpl;
    }

    public Collection unregister(String[] stringArray) {
        Object object4;
        Object object22;
        LinkedList<ExtensionPoint> linkedList = new LinkedList<ExtensionPoint>();
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>();
        Object object3 = this.registeredPlugins.values().iterator();
        while (object3.hasNext()) {
            for (Object object22 : ((PluginDescriptor)object3.next()).getExtensionPoints()) {
                linkedList.add((ExtensionPoint)object22);
                for (Extension extension : object22.getConnectedExtensions()) {
                    hashMap.put(extension.getUniqueId(), extension);
                }
            }
        }
        object3 = new HashSet();
        RegistryChangeDataImpl registryChangeDataImpl = new RegistryChangeDataImpl();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringPrepare", null));
        object22 = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            object4 = (PluginDescriptor)this.registeredPlugins.get(stringArray[i]);
            if (object4 != null) {
                for (UniqueIdentity uniqueIdentity : this.getDependingPlugins((PluginDescriptor)object4)) {
                    object22.put(uniqueIdentity.getId(), uniqueIdentity);
                    registryChangeDataImpl.removedPlugins().add(uniqueIdentity.getId());
                }
                object22.put(object4.getId(), object4);
                registryChangeDataImpl.removedPlugins().add(object4.getId());
                continue;
            }
            PluginFragment pluginFragment = (PluginFragment)this.registeredFragments.get(stringArray[i]);
            if (pluginFragment != null) {
                hashMap2.put(pluginFragment.getId(), pluginFragment);
                continue;
            }
            this.registrationReport.add(new IntegrityChecker.ReportItemImpl(2, null, 0, "pluginToUngregisterNotFound", stringArray[i]));
        }
        for (Object object4 : object22.values()) {
            for (UniqueIdentity uniqueIdentity : object4.getFragments()) {
                if (hashMap2.containsKey(uniqueIdentity.getId())) continue;
                hashMap2.put(uniqueIdentity.getId(), uniqueIdentity);
            }
        }
        this.fireEvent(registryChangeDataImpl);
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringFragmentsStart", null));
        for (Object object4 : hashMap2.values()) {
            this.unregisterFragment((PluginFragmentImpl)object4);
            if (!object22.containsKey(((PluginFragmentImpl)object4).getPluginId())) {
                registryChangeDataImpl.modifiedPlugins().add(((PluginFragmentImpl)object4).getPluginId());
            }
            object3.add(((PluginFragmentImpl)object4).getUniqueId());
        }
        hashMap2.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringPluginsStart", null));
        for (Object object4 : object22.values()) {
            this.unregisterPlugin((PluginDescriptorImpl)object4);
            object3.add(((PluginDescriptorImpl)object4).getUniqueId());
        }
        object22.clear();
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringPluginsFinish", new Integer(this.registeredPlugins.size())));
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "unregisteringFragmentsFinish", new Integer(this.registeredFragments.size())));
        log.info((Object)("plug-in and fragment descriptors unregistered - " + object3.size()));
        this.dump();
        if (object3.isEmpty()) {
            return object3;
        }
        Iterator<Object> iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((ExtensionPointImpl)iterator.next()).registryChanged();
        }
        iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ((ExtensionImpl)iterator.next()).registryChanged();
        }
        if (!this.listeners.isEmpty() || log.isDebugEnabled()) {
            iterator = this.registeredPlugins.values().iterator();
            while (iterator.hasNext()) {
                object4 = ((PluginDescriptor)iterator.next()).getExtensionPoints().iterator();
                while (object4.hasNext()) {
                    for (UniqueIdentity uniqueIdentity : ((ExtensionPoint)object4.next()).getConnectedExtensions()) {
                        if (!hashMap.containsKey(uniqueIdentity.getUniqueId())) {
                            registryChangeDataImpl.putAddedExtension(uniqueIdentity.getUniqueId(), this.makeUniqueId(uniqueIdentity.getExtendedPluginId(), uniqueIdentity.getExtendedPointId()));
                            continue;
                        }
                        hashMap.remove(uniqueIdentity.getUniqueId());
                        if (!registryChangeDataImpl.modifiedPlugins().contains(uniqueIdentity.getDeclaringPluginDescriptor().getId()) && !registryChangeDataImpl.modifiedPlugins().contains(uniqueIdentity.getExtendedPluginId())) continue;
                        registryChangeDataImpl.putModifiedExtension(uniqueIdentity.getUniqueId(), this.makeUniqueId(uniqueIdentity.getExtendedPluginId(), uniqueIdentity.getExtendedPointId()));
                    }
                }
            }
            for (Object object4 : hashMap.values()) {
                registryChangeDataImpl.putRemovedExtension(object4.getUniqueId(), this.makeUniqueId(object4.getExtendedPluginId(), object4.getExtendedPointId()));
            }
            this.fireEvent(registryChangeDataImpl);
        }
        return object3;
    }

    private void unregisterPlugin(PluginDescriptorImpl pluginDescriptorImpl) {
        this.registeredPlugins.remove(pluginDescriptorImpl.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "pluginUnregistered", pluginDescriptorImpl.getUniqueId()));
    }

    private void unregisterFragment(PluginFragmentImpl pluginFragmentImpl) {
        PluginDescriptorImpl pluginDescriptorImpl = (PluginDescriptorImpl)this.registeredPlugins.get(pluginFragmentImpl.getPluginId());
        if (pluginDescriptorImpl != null) {
            pluginDescriptorImpl.unregisterFragment(pluginFragmentImpl);
        }
        this.registeredFragments.remove(pluginFragmentImpl.getId());
        this.registrationReport.add(new IntegrityChecker.ReportItemImpl(3, null, 0, "fragmentUnregistered", pluginFragmentImpl.getUniqueId()));
    }

    private void dump() {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PLUG-IN REGISTRY DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tPlug-ins: " + this.registeredPlugins.size() + "\r\n");
        Iterator iterator = this.registeredPlugins.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("\tFragments: " + this.registeredFragments.size() + "\r\n");
        iterator = this.registeredFragments.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
        }
        stringBuffer.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
        stringBuffer.append("-------------- DUMP END -----------------\r\n");
        log.debug((Object)stringBuffer.toString());
    }

    public ExtensionPoint getExtensionPoint(String string, String string2) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID " + string + " provided for extension point " + string2);
        }
        for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            if (extensionPoint.isValid()) {
                return extensionPoint;
            }
            log.warn((Object)("extension point " + extensionPoint.getUniqueId() + " is invalid and ignored by registry"));
            break;
        }
        throw new IllegalArgumentException("unknown extension point ID - " + this.makeUniqueId(string, string2));
    }

    public ExtensionPoint getExtensionPoint(String string) {
        return this.getExtensionPoint(this.extractPluginId(string), this.extractId(string));
    }

    public boolean isExtensionPointAvailable(String string, String string2) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            return false;
        }
        for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            return extensionPoint.isValid();
        }
        return false;
    }

    public boolean isExtensionPointAvailable(String string) {
        return this.isExtensionPointAvailable(this.extractPluginId(string), this.extractId(string));
    }

    public PluginDescriptor getPluginDescriptor(String string) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.registeredPlugins.get(string);
        if (pluginDescriptor == null) {
            throw new IllegalArgumentException("unknown plug-in ID - " + string);
        }
        return pluginDescriptor;
    }

    public boolean isPluginDescriptorAvailable(String string) {
        return this.registeredPlugins.containsKey(string);
    }

    public Collection getPluginDescriptors() {
        return this.registeredPlugins.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.registeredPlugins.values());
    }

    public Collection getPluginFragments() {
        return this.registeredFragments.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableCollection(this.registeredFragments.values());
    }

    public Collection getDependingPlugins(PluginDescriptor pluginDescriptor) {
        HashMap<String, PluginDescriptor> hashMap = new HashMap<String, PluginDescriptor>();
        block0: for (PluginDescriptor pluginDescriptor2 : this.getPluginDescriptors()) {
            if (pluginDescriptor2.getId().equals(pluginDescriptor.getId())) continue;
            for (PluginPrerequisite pluginPrerequisite : pluginDescriptor2.getPrerequisites()) {
                if (!pluginPrerequisite.getPluginId().equals(pluginDescriptor.getId()) || !pluginPrerequisite.matches()) continue;
                if (hashMap.containsKey(pluginDescriptor2.getId())) continue block0;
                hashMap.put(pluginDescriptor2.getId(), pluginDescriptor2);
                for (PluginDescriptor pluginDescriptor3 : this.getDependingPlugins(pluginDescriptor2)) {
                    if (hashMap.containsKey(pluginDescriptor3.getId())) continue;
                    hashMap.put(pluginDescriptor3.getId(), pluginDescriptor3);
                }
                continue block0;
            }
        }
        return hashMap.values();
    }

    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver) {
        return this.checkIntegrity(pathResolver, false);
    }

    public IntegrityCheckReport checkIntegrity(PathResolver pathResolver, boolean bl) {
        IntegrityChecker integrityChecker = new IntegrityChecker(this, bl ? this.registrationReport : Collections.EMPTY_LIST);
        integrityChecker.doCheck(pathResolver);
        return integrityChecker;
    }

    public IntegrityCheckReport getRegistrationReport() {
        return new IntegrityChecker(this, this.registrationReport);
    }

    public String makeUniqueId(String string, String string2) {
        return string + '@' + string2;
    }

    public String makeUniqueId(String string, Version version) {
        return string + '@' + version;
    }

    public String extractPluginId(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return string.substring(0, n);
    }

    public String extractId(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return string.substring(n + 1);
    }

    public Version extractVersion(String string) {
        int n = string.indexOf(64);
        if (n <= 0 || n >= string.length() - 1) {
            throw new IllegalArgumentException("invalid unique ID - " + string);
        }
        return Version.parse(string.substring(n + 1));
    }

    public void registerListener(PluginRegistry.RegistryChangeListener registryChangeListener) {
        if (this.listeners.contains(registryChangeListener)) {
            throw new IllegalArgumentException("listener " + registryChangeListener + " already registered");
        }
        this.listeners.add(registryChangeListener);
    }

    public void unregisterListener(PluginRegistry.RegistryChangeListener registryChangeListener) {
        if (!this.listeners.remove(registryChangeListener)) {
            log.warn((Object)("unknown listener " + registryChangeListener));
        }
    }

    void fireEvent(RegistryChangeDataImpl registryChangeDataImpl) {
        registryChangeDataImpl.dump();
        if (this.listeners.isEmpty()) {
            return;
        }
        PluginRegistry.RegistryChangeListener[] registryChangeListenerArray = this.listeners.toArray(new PluginRegistry.RegistryChangeListener[this.listeners.size()]);
        registryChangeDataImpl.beforeEventFire();
        if (log.isDebugEnabled()) {
            log.debug((Object)"propagating registry change event");
        }
        for (int i = 0; i < registryChangeListenerArray.length; ++i) {
            registryChangeListenerArray[i].registryChanged(registryChangeDataImpl);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"registry change event propagated");
        }
        registryChangeDataImpl.afterEventFire();
    }

    private static final class ManifestInfoImpl
    implements PluginRegistry.ManifestInfo {
        private final ModelManifestInfo model;

        ManifestInfoImpl(ModelManifestInfo modelManifestInfo) {
            this.model = modelManifestInfo;
        }

        public String getId() {
            return this.model.getId();
        }

        public Version getVersion() {
            return this.model.getVersion();
        }

        public String getVendor() {
            return this.model.getVendor();
        }

        public String getPluginId() {
            return this.model.getPluginId();
        }

        public Version getPluginVersion() {
            return this.model.getPluginVersion();
        }

        public String getMatchingRule() {
            return this.model.getMatch();
        }
    }

    private static final class RegistryChangeDataImpl
    implements PluginRegistry.RegistryChangeData {
        private Set addedPlugins;
        private Set removedPlugins;
        private Set modifiedPlugins;
        private Map addedExtensions;
        private Map removedExtensions;
        private Map modifiedExtensions;

        protected RegistryChangeDataImpl() {
            this.reset();
        }

        private void reset() {
            this.addedPlugins = new HashSet();
            this.removedPlugins = new HashSet();
            this.modifiedPlugins = new HashSet();
            this.addedExtensions = new HashMap();
            this.removedExtensions = new HashMap();
            this.modifiedExtensions = new HashMap();
        }

        protected void beforeEventFire() {
            this.addedPlugins = Collections.unmodifiableSet(this.addedPlugins);
            this.removedPlugins = Collections.unmodifiableSet(this.removedPlugins);
            this.modifiedPlugins = Collections.unmodifiableSet(this.modifiedPlugins);
            this.addedExtensions = Collections.unmodifiableMap(this.addedExtensions);
            this.removedExtensions = Collections.unmodifiableMap(this.removedExtensions);
            this.modifiedExtensions = Collections.unmodifiableMap(this.modifiedExtensions);
        }

        protected void afterEventFire() {
            this.reset();
        }

        protected void dump() {
            Log log = LogFactory.getLog(this.getClass());
            if (!log.isDebugEnabled()) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PLUG-IN REGISTRY CHANGES DUMP:\r\n").append("-------------- DUMP BEGIN -----------------\r\n").append("\tAdded plug-ins: " + this.addedPlugins.size() + "\r\n");
            Iterator<Object> iterator = this.addedPlugins.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tRemoved plug-ins: " + this.removedPlugins.size() + "\r\n");
            iterator = this.removedPlugins.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tModified plug-ins: " + this.modifiedPlugins.size() + "\r\n");
            iterator = this.modifiedPlugins.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tAdded extensions: " + this.addedExtensions.size() + "\r\n");
            iterator = this.addedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tRemoved extensions: " + this.removedExtensions.size() + "\r\n");
            iterator = this.removedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("\tModified extensions: " + this.modifiedExtensions.size() + "\r\n");
            iterator = this.modifiedExtensions.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t").append(iterator.next()).append("\r\n");
            }
            stringBuffer.append("Memory TOTAL/FREE/MAX: ").append(Runtime.getRuntime().totalMemory()).append("/").append(Runtime.getRuntime().freeMemory()).append("/").append(Runtime.getRuntime().maxMemory()).append("\r\n");
            stringBuffer.append("-------------- DUMP END -----------------\r\n");
            log.debug((Object)stringBuffer.toString());
        }

        public Set addedPlugins() {
            return this.addedPlugins;
        }

        public Set removedPlugins() {
            return this.removedPlugins;
        }

        public Set modifiedPlugins() {
            return this.modifiedPlugins;
        }

        void putAddedExtension(String string, String string2) {
            this.addedExtensions.put(string, string2);
        }

        public Set addedExtensions() {
            return this.addedExtensions.keySet();
        }

        public Set addedExtensions(String string) {
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : this.addedExtensions.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }

        void putRemovedExtension(String string, String string2) {
            this.removedExtensions.put(string, string2);
        }

        public Set removedExtensions() {
            return this.removedExtensions.keySet();
        }

        public Set removedExtensions(String string) {
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : this.removedExtensions.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }

        void putModifiedExtension(String string, String string2) {
            this.modifiedExtensions.put(string, string2);
        }

        public Set modifiedExtensions() {
            return this.modifiedExtensions.keySet();
        }

        public Set modifiedExtensions(String string) {
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : this.modifiedExtensions.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

