/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import org.java.plugin.registry.xml.BaseHandler;
import org.java.plugin.registry.xml.ModelAttribute;
import org.java.plugin.registry.xml.ModelDocumentation;
import org.java.plugin.registry.xml.ModelDocumentationReference;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelLibrary;
import org.java.plugin.registry.xml.ModelParameter;
import org.java.plugin.registry.xml.ModelParameterDef;
import org.java.plugin.registry.xml.ModelPluginDescriptor;
import org.java.plugin.registry.xml.ModelPluginFragment;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.ModelPrerequisite;
import org.java.plugin.registry.xml.SimpleStack;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

final class ManifestHandler
extends BaseHandler {
    private ModelPluginManifest manifest = null;
    private ModelDocumentation documentation = null;
    private ModelPrerequisite prerequisite;
    private ModelLibrary library;
    private ModelExtensionPoint extensionPoint;
    private ModelExtension extension;
    private StringBuffer docText = null;
    private SimpleStack attributeStack = null;
    private ModelAttribute attribute;
    private SimpleStack paramDefStack = null;
    private ModelParameterDef paramDef;
    private SimpleStack paramStack = null;
    private ModelParameter param;
    private StringBuffer paramValue = null;

    ManifestHandler(EntityResolver entityResolver) {
        super(entityResolver);
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("startElement - [" + string + "]/[" + string2 + "]/[" + string3 + "]"));
        }
        if ("plugin".equals(string4 = string3)) {
            if (this.manifest != null) {
                throw new SAXException("unexpected [" + string4 + "] element (manifest already defined)");
            }
            this.manifest = new ModelPluginDescriptor();
            this.manifest.setId(attributes.getValue("id"));
            this.manifest.setVersion(attributes.getValue("version"));
            this.manifest.setVendor(attributes.getValue("vendor"));
            this.manifest.setDocsPath(attributes.getValue("docs-path"));
            ((ModelPluginDescriptor)this.manifest).setClassName(attributes.getValue("class"));
        } else if ("plugin-fragment".equals(string4)) {
            if (this.manifest != null) {
                throw new SAXException("unexpected [" + string4 + "] element (manifest already defined)");
            }
            this.manifest = new ModelPluginFragment();
            this.manifest.setId(attributes.getValue("id"));
            this.manifest.setVersion(attributes.getValue("version"));
            this.manifest.setVendor(attributes.getValue("vendor"));
            this.manifest.setDocsPath(attributes.getValue("docs-path"));
            ((ModelPluginFragment)this.manifest).setPluginId(attributes.getValue("plugin-id"));
            if (attributes.getValue("plugin-version") != null) {
                ((ModelPluginFragment)this.manifest).setPluginVersion(attributes.getValue("plugin-version"));
            }
            if (attributes.getValue("match") != null) {
                ((ModelPluginFragment)this.manifest).setMatch(attributes.getValue("match"));
            } else {
                ((ModelPluginFragment)this.manifest).setMatch("compatible");
            }
        } else if ("doc".equals(string4)) {
            this.documentation = new ModelDocumentation();
            this.documentation.setCaption(attributes.getValue("caption"));
        } else if ("doc-ref".equals(string4)) {
            if (this.documentation == null) {
                if (this.entityResolver != null) {
                    throw new SAXException("[doc-ref] element found outside of [doc] element");
                }
                this.log.warn((Object)"[doc-ref] element found outside of [doc] element");
                return;
            }
            ModelDocumentationReference modelDocumentationReference = new ModelDocumentationReference();
            modelDocumentationReference.setPath(attributes.getValue("path"));
            modelDocumentationReference.setCaption(attributes.getValue("caption"));
            this.documentation.getReferences().add(modelDocumentationReference);
        } else if ("doc-text".equals(string4)) {
            if (this.documentation == null) {
                if (this.entityResolver != null) {
                    throw new SAXException("[doc-text] element found outside of [doc] element");
                }
                this.log.warn((Object)"[doc-text] element found outside of [doc] element");
                return;
            }
            this.docText = new StringBuffer();
        } else if ("attributes".equals(string4)) {
            this.attributeStack = new SimpleStack();
        } else if ("attribute".equals(string4)) {
            if (this.attributeStack == null) {
                if (this.entityResolver != null) {
                    throw new SAXException("[attribute] element found outside of [attributes] element");
                }
                this.log.warn((Object)"[attribute] element found outside of [attributes] element");
                return;
            }
            if (this.attribute != null) {
                this.attributeStack.push(this.attribute);
            }
            this.attribute = new ModelAttribute();
            this.attribute.setId(attributes.getValue("id"));
            this.attribute.setValue(attributes.getValue("value"));
        } else if (!"requires".equals(string4)) {
            if ("import".equals(string4)) {
                this.prerequisite = new ModelPrerequisite();
                if (attributes.getValue("id") != null) {
                    this.prerequisite.setId(attributes.getValue("id"));
                }
                this.prerequisite.setPluginId(attributes.getValue("plugin-id"));
                if (attributes.getValue("plugin-version") != null) {
                    this.prerequisite.setPluginVersion(attributes.getValue("plugin-version"));
                }
                if (attributes.getValue("match") != null) {
                    this.prerequisite.setMatch(attributes.getValue("match"));
                } else {
                    this.prerequisite.setMatch("compatible");
                }
                this.prerequisite.setExported(attributes.getValue("exported"));
                this.prerequisite.setOptional(attributes.getValue("optional"));
                this.prerequisite.setReverseLookup(attributes.getValue("reverse-lookup"));
            } else if (!"runtime".equals(string4)) {
                if ("library".equals(string4)) {
                    this.library = new ModelLibrary();
                    this.library.setId(attributes.getValue("id"));
                    this.library.setPath(attributes.getValue("path"));
                    this.library.setCodeLibrary(attributes.getValue("type"));
                    if (attributes.getValue("version") != null) {
                        this.library.setVersion(attributes.getValue("version"));
                    }
                } else if ("export".equals(string4)) {
                    if (this.library == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[export] element found outside of [library] element");
                        }
                        this.log.warn((Object)"[export] element found outside of [library] element");
                        return;
                    }
                    this.library.getExports().add(attributes.getValue("prefix"));
                } else if ("extension-point".equals(string4)) {
                    this.extensionPoint = new ModelExtensionPoint();
                    this.extensionPoint.setId(attributes.getValue("id"));
                    this.extensionPoint.setParentPluginId(attributes.getValue("parent-plugin-id"));
                    this.extensionPoint.setParentPointId(attributes.getValue("parent-point-id"));
                    if (attributes.getValue("extension-multiplicity") != null) {
                        this.extensionPoint.setExtensionMultiplicity(attributes.getValue("extension-multiplicity"));
                    } else {
                        this.extensionPoint.setExtensionMultiplicity("any");
                    }
                    this.paramDefStack = new SimpleStack();
                } else if ("parameter-def".equals(string4)) {
                    if (this.extensionPoint == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[parameter-def] element found outside of [extension-point] element");
                        }
                        this.log.warn((Object)"[parameter-def] element found outside of [extension-point] element");
                        return;
                    }
                    if (this.paramDef != null) {
                        this.paramDefStack.push(this.paramDef);
                    }
                    this.paramDef = new ModelParameterDef();
                    this.paramDef.setId(attributes.getValue("id"));
                    if (attributes.getValue("multiplicity") != null) {
                        this.paramDef.setMultiplicity(attributes.getValue("multiplicity"));
                    } else {
                        this.paramDef.setMultiplicity("one");
                    }
                    if (attributes.getValue("type") != null) {
                        this.paramDef.setType(attributes.getValue("type"));
                    } else {
                        this.paramDef.setType("string");
                    }
                    this.paramDef.setCustomData(attributes.getValue("custom-data"));
                    this.paramDef.setDefaultValue(attributes.getValue("default-value"));
                } else if ("extension".equals(string4)) {
                    this.extension = new ModelExtension();
                    this.extension.setId(attributes.getValue("id"));
                    this.extension.setPluginId(attributes.getValue("plugin-id"));
                    this.extension.setPointId(attributes.getValue("point-id"));
                    this.paramStack = new SimpleStack();
                } else if ("parameter".equals(string4)) {
                    if (this.extension == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[parameter] element found outside of [extension] element");
                        }
                        this.log.warn((Object)"[parameter] element found outside of [extension] element");
                        return;
                    }
                    if (this.param != null) {
                        this.paramStack.push(this.param);
                    }
                    this.param = new ModelParameter();
                    this.param.setId(attributes.getValue("id"));
                    this.param.setValue(attributes.getValue("value"));
                } else if ("value".equals(string4)) {
                    if (this.param == null) {
                        if (this.entityResolver != null) {
                            throw new SAXException("[value] element found outside of [parameter] element");
                        }
                        this.log.warn((Object)"[value] element found outside of [parameter] element");
                        return;
                    }
                    this.paramValue = new StringBuffer();
                } else {
                    if (this.entityResolver != null) {
                        throw new SAXException("unexpected manifest element - [" + string + "]/[" + string2 + "]/[" + string3 + "]");
                    }
                    this.log.warn((Object)("unexpected manifest element - [" + string + "]/[" + string2 + "]/[" + string3 + "]"));
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("endElement - [" + string + "]/[" + string2 + "]/[" + string3 + "]"));
        }
        if (!"plugin".equals(string4 = string3) && !"plugin-fragment".equals(string4)) {
            if ("doc".equals(string4)) {
                if (this.param != null) {
                    this.param.setDocumentation(this.documentation);
                } else if (this.extension != null) {
                    this.extension.setDocumentation(this.documentation);
                } else if (this.paramDef != null) {
                    this.paramDef.setDocumentation(this.documentation);
                } else if (this.extensionPoint != null) {
                    this.extensionPoint.setDocumentation(this.documentation);
                } else if (this.library != null) {
                    this.library.setDocumentation(this.documentation);
                } else if (this.prerequisite != null) {
                    this.prerequisite.setDocumentation(this.documentation);
                } else if (this.attribute != null) {
                    this.attribute.setDocumentation(this.documentation);
                } else {
                    this.manifest.setDocumentation(this.documentation);
                }
                this.documentation = null;
            } else if (!"doc-ref".equals(string4)) {
                if ("doc-text".equals(string4)) {
                    this.documentation.setText(this.docText.toString());
                    this.docText = null;
                } else if ("attributes".equals(string4)) {
                    this.attributeStack = null;
                } else if ("attribute".equals(string4)) {
                    if (this.attributeStack.size() == 0) {
                        this.manifest.getAttributes().add(this.attribute);
                        this.attribute = null;
                    } else {
                        ModelAttribute modelAttribute = this.attribute;
                        this.attribute = (ModelAttribute)this.attributeStack.pop();
                        this.attribute.getAttributes().add(modelAttribute);
                        modelAttribute = null;
                    }
                } else if (!"requires".equals(string4)) {
                    if ("import".equals(string4)) {
                        this.manifest.getPrerequisites().add(this.prerequisite);
                        this.prerequisite = null;
                    } else if (!"runtime".equals(string4)) {
                        if ("library".equals(string4)) {
                            this.manifest.getLibraries().add(this.library);
                            this.library = null;
                        } else if (!"export".equals(string4)) {
                            if ("extension-point".equals(string4)) {
                                this.manifest.getExtensionPoints().add(this.extensionPoint);
                                this.extensionPoint = null;
                                this.paramDefStack = null;
                            } else if ("parameter-def".equals(string4)) {
                                if (this.paramDefStack.size() == 0) {
                                    this.extensionPoint.getParamDefs().add(this.paramDef);
                                    this.paramDef = null;
                                } else {
                                    ModelParameterDef modelParameterDef = this.paramDef;
                                    this.paramDef = (ModelParameterDef)this.paramDefStack.pop();
                                    this.paramDef.getParamDefs().add(modelParameterDef);
                                    modelParameterDef = null;
                                }
                            } else if ("extension".equals(string4)) {
                                this.manifest.getExtensions().add(this.extension);
                                this.extension = null;
                                this.paramStack = null;
                            } else if ("parameter".equals(string4)) {
                                if (this.paramStack.size() == 0) {
                                    this.extension.getParams().add(this.param);
                                    this.param = null;
                                } else {
                                    ModelParameter modelParameter = this.param;
                                    this.param = (ModelParameter)this.paramStack.pop();
                                    this.param.getParams().add(modelParameter);
                                    modelParameter = null;
                                }
                            } else if ("value".equals(string4)) {
                                this.param.setValue(this.paramValue.toString());
                                this.paramValue = null;
                            } else {
                                this.log.warn((Object)("ignoring manifest element - [" + string + "]/[" + string2 + "]/[" + string3 + "]"));
                            }
                        }
                    }
                }
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.docText != null) {
            this.docText.append(cArray, n, n2);
        } else if (this.paramValue != null) {
            this.paramValue.append(cArray, n, n2);
        } else {
            if (this.entityResolver != null) {
                throw new SAXException("unexpected character data");
            }
            this.log.warn((Object)("ignoring character data - [" + new String(cArray, n, n2) + "]"));
        }
    }

    ModelPluginManifest getResult() {
        return this.manifest;
    }
}

