/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtensionPoint;
import org.java.plugin.registry.xml.ModelParameterDef;
import org.java.plugin.registry.xml.ParameterValueParser;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

class ExtensionPointImpl
extends PluginElementImpl
implements ExtensionPoint {
    private final ModelExtensionPoint model;
    private Map connectedExtensions;
    private Map availableExtensions;
    private List parameterDefinitions;
    private Boolean isValid;
    private boolean paramDefsMerged = false;
    private List descendants;

    ExtensionPointImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelExtensionPoint modelExtensionPoint) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelExtensionPoint.getId(), modelExtensionPoint.getDocumentation());
        this.model = modelExtensionPoint;
        if (this.model.getParentPointId() != null && this.model.getParentPluginId() == null) {
            this.log.warn((Object)("parent plug-in ID not specified together with parent extension point ID, using declaring plug-in ID, extension point is " + this.getUniqueId()));
            this.model.setParentPluginId(pluginDescriptorImpl.getId());
        }
        this.parameterDefinitions = new ArrayList(this.model.getParamDefs().size());
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.model.getParamDefs().iterator();
        while (iterator.hasNext()) {
            ParameterDefinitionImpl parameterDefinitionImpl = new ParameterDefinitionImpl(null, (ModelParameterDef)iterator.next());
            if (hashSet.contains(parameterDefinitionImpl.getId())) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{parameterDefinitionImpl.getId(), this.getId(), pluginDescriptorImpl.getId()});
            }
            hashSet.add(parameterDefinitionImpl.getId());
            this.parameterDefinitions.add(parameterDefinitionImpl);
        }
        this.parameterDefinitions = Collections.unmodifiableList(this.parameterDefinitions);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    public String getMultiplicity() {
        return this.model.getExtensionMultiplicity();
    }

    private void updateExtensionsLists() {
        this.connectedExtensions = new HashMap();
        this.availableExtensions = new HashMap();
        for (PluginDescriptor pluginDescriptor : this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors()) {
            for (Extension extension : pluginDescriptor.getExtensions()) {
                if (!this.getDeclaringPluginDescriptor().getId().equals(extension.getExtendedPluginId()) || !this.getId().equals(extension.getExtendedPointId())) continue;
                this.availableExtensions.put(extension.getUniqueId(), extension);
                if (extension.isValid()) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("extension " + extension + " connected to point " + this));
                    }
                    this.connectedExtensions.put(extension.getUniqueId(), extension);
                    continue;
                }
                this.log.warn((Object)("extension " + extension.getUniqueId() + " is invalid and doesn't connected to" + " extension point " + this.getUniqueId()));
            }
        }
    }

    public Collection getAvailableExtensions() {
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        return Collections.unmodifiableCollection(this.availableExtensions.values());
    }

    public Extension getAvailableExtension(String string) {
        Extension extension;
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        if ((extension = (Extension)this.availableExtensions.get(string)) == null) {
            throw new IllegalArgumentException("extension " + string + " not available in point " + this.getUniqueId());
        }
        return extension;
    }

    public boolean isExtensionAvailable(String string) {
        if (this.availableExtensions == null) {
            this.updateExtensionsLists();
        }
        return this.availableExtensions.containsKey(string);
    }

    public Collection getConnectedExtensions() {
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        return Collections.unmodifiableCollection(this.connectedExtensions.values());
    }

    public Extension getConnectedExtension(String string) {
        Extension extension;
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        if ((extension = (Extension)this.connectedExtensions.get(string)) == null) {
            throw new IllegalArgumentException("extension " + string + " not connected to point " + this.getUniqueId());
        }
        return extension;
    }

    public boolean isExtensionConnected(String string) {
        if (this.connectedExtensions == null) {
            this.updateExtensionsLists();
        }
        return this.connectedExtensions.containsKey(string);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection validate() {
        if (this.model.getParentPluginId() != null && this.model.getParentPointId() != null) {
            try {
                if (!this.isExtensionPointAvailable(this.model.getParentPluginId(), this.model.getParentPointId())) {
                    this.isValid = Boolean.FALSE;
                    return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "parentExtPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId()}));
                }
            }
            catch (Throwable throwable) {
                this.isValid = Boolean.FALSE;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("failed checking availability of extension point " + this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId())), throwable);
                }
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "parentExtPointAvailabilityCheckFailed", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.model.getParentPluginId(), this.model.getParentPointId()), this.getUniqueId(), throwable}));
            }
        }
        if ("any".equals(this.getMultiplicity())) {
            this.isValid = Boolean.TRUE;
            return Collections.EMPTY_LIST;
        }
        if ("one".equals(this.getMultiplicity())) {
            this.isValid = this.getAvailableExtensions().size() == 1;
            if (!this.isValid.booleanValue()) {
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "toManyOrFewExtsConnected", this.getUniqueId()));
            }
        } else if ("none".equals(this.getMultiplicity())) {
            this.isValid = this.getAvailableExtensions().size() == 0;
            if (!this.isValid.booleanValue()) {
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "extsConnectedToAbstractExtPoint", this.getUniqueId()));
            }
        } else {
            this.isValid = Boolean.TRUE;
            HashSet<String> hashSet = new HashSet<String>();
            Iterator iterator = this.getAvailableExtensions().iterator();
            while (iterator.hasNext()) {
                String string = ((Extension)iterator.next()).getDeclaringPluginDescriptor().getId();
                if (hashSet.add(string)) continue;
                this.isValid = Boolean.FALSE;
                return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 5, "toManyExtsConnected", this.getUniqueId()));
            }
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isExtensionPointAvailable(String string, String string2) {
        PluginRegistry pluginRegistry = this.getDeclaringPluginDescriptor().getRegistry();
        if (!pluginRegistry.isPluginDescriptorAvailable(string)) {
            return false;
        }
        Iterator iterator = pluginRegistry.getPluginDescriptor(string).getExtensionPoints().iterator();
        while (iterator.hasNext()) {
            if (!((ExtensionPoint)iterator.next()).getId().equals(string2)) continue;
            return true;
        }
        return false;
    }

    public Collection getParameterDefinitions() {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null || this.paramDefsMerged) {
            return this.parameterDefinitions;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collection collection = this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).getParameterDefinitions();
        ArrayList<ExtensionPoint.ParameterDefinition> arrayList = new ArrayList<ExtensionPoint.ParameterDefinition>(this.parameterDefinitions.size() + collection.size());
        for (ExtensionPoint.ParameterDefinition parameterDefinition : this.parameterDefinitions) {
            hashSet.add(parameterDefinition.getId());
            arrayList.add(parameterDefinition);
        }
        for (ExtensionPoint.ParameterDefinition parameterDefinition : collection) {
            if (hashSet.contains(parameterDefinition.getId())) continue;
            arrayList.add(parameterDefinition);
        }
        this.paramDefsMerged = true;
        this.parameterDefinitions = Collections.unmodifiableList(arrayList);
        return this.parameterDefinitions;
    }

    public ExtensionPoint.ParameterDefinition getParameterDefinition(String string) {
        for (ParameterDefinitionImpl parameterDefinitionImpl : this.getParameterDefinitions()) {
            if (!parameterDefinitionImpl.getId().equals(string)) continue;
            return parameterDefinitionImpl;
        }
        throw new IllegalArgumentException("parameter definition with ID " + string + " not found in extension point " + this.getUniqueId() + " and all it parents");
    }

    public String getParentPluginId() {
        return this.model.getParentPluginId();
    }

    public String getParentExtensionPointId() {
        return this.model.getParentPointId();
    }

    public boolean isSuccessorOf(ExtensionPoint extensionPoint) {
        if (this.model.getParentPluginId() == null || this.model.getParentPointId() == null) {
            return false;
        }
        if (this.model.getParentPluginId().equals(extensionPoint.getDeclaringPluginDescriptor().getId()) && this.model.getParentPointId().equals(extensionPoint.getId())) {
            return true;
        }
        try {
            return this.getDeclaringPluginDescriptor().getRegistry().getExtensionPoint(this.model.getParentPluginId(), this.model.getParentPointId()).isSuccessorOf(extensionPoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private void collectDescendants() {
        this.descendants = new LinkedList();
        for (PluginDescriptor pluginDescriptor : this.getDeclaringPluginDescriptor().getRegistry().getPluginDescriptors()) {
            for (ExtensionPoint extensionPoint : pluginDescriptor.getExtensionPoints()) {
                if (!extensionPoint.isSuccessorOf(this)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("extension point " + extensionPoint + " is descendant of point " + this));
                }
                this.descendants.add(extensionPoint);
            }
        }
        this.descendants = Collections.unmodifiableList(this.descendants);
    }

    public Collection getDescendants() {
        if (this.descendants == null) {
            this.collectDescendants();
        }
        return this.descendants;
    }

    public String toString() {
        return "{ExtensionPoint: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
        this.connectedExtensions = null;
        this.availableExtensions = null;
        this.descendants = null;
    }

    class ParameterDefinitionImpl
    extends PluginElementImpl
    implements ExtensionPoint.ParameterDefinition {
        private List subDefinitions;
        private final ParameterDefinitionImpl superDefinition;
        private final ModelParameterDef modelParamDef;
        private final ParameterValueParser valueParser;

        ParameterDefinitionImpl(ParameterDefinitionImpl parameterDefinitionImpl, ModelParameterDef modelParameterDef) throws ManifestProcessingException {
            super(ExtensionPointImpl.this.getDeclaringPluginDescriptor(), ExtensionPointImpl.this.getDeclaringPluginFragment(), modelParameterDef.getId(), modelParameterDef.getDocumentation());
            this.superDefinition = parameterDefinitionImpl;
            this.modelParamDef = modelParameterDef;
            this.checkType();
            this.checkMultiplicity();
            this.valueParser = new ParameterValueParser(this.getDeclaringPluginDescriptor().getRegistry(), this, this.modelParamDef.getDefaultValue());
            if (!this.valueParser.isParsingSucceeds()) {
                this.log.warn((Object)("parsing default value for parameter definition " + this + " failed, message is: " + this.valueParser.getParsingMessage()));
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidDefaultValueAttribute", new Object[]{this.modelParamDef.getDefaultValue(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
            if ("any".equals(this.modelParamDef.getType())) {
                this.subDefinitions = Collections.EMPTY_LIST;
            } else {
                this.subDefinitions = new ArrayList(this.modelParamDef.getParamDefs().size());
                HashSet<String> hashSet = new HashSet<String>();
                Iterator iterator = this.modelParamDef.getParamDefs().iterator();
                while (iterator.hasNext()) {
                    ParameterDefinitionImpl parameterDefinitionImpl2 = new ParameterDefinitionImpl(this, (ModelParameterDef)iterator.next());
                    if (hashSet.contains(parameterDefinitionImpl2.getId())) {
                        throw new ManifestProcessingException("org.java.plugin.registry.xml", "duplicateParameterDefinition", new Object[]{parameterDefinitionImpl2.getId(), ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
                    }
                    hashSet.add(parameterDefinitionImpl2.getId());
                    this.subDefinitions.add(parameterDefinitionImpl2);
                }
                this.subDefinitions = Collections.unmodifiableList(this.subDefinitions);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("object instantiated: " + this));
            }
        }

        private void checkType() throws ManifestProcessingException {
            String string = this.modelParamDef.getType();
            if (!("string".equals(string) || "boolean".endsWith(string) || "number".equals(string) || "date".equals(string) || "time".equals(string) || "date-time".equals(string) || "null".equals(string) || "any".equals(string) || "plugin-id".equals(string) || "extension-point-id".equals(string) || "extension-id".equals(string) || "fixed".equals(string) || "resource".equals(string))) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidTypeAttribute", new Object[]{string, ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
        }

        private void checkMultiplicity() throws ManifestProcessingException {
            String string = this.modelParamDef.getMultiplicity();
            if (!("one".equals(string) || "any".equals(string) || "none-or-one".equals(string) || "one-or-more".equals(string))) {
                throw new ManifestProcessingException("org.java.plugin.registry.xml", "invalidMultiplicityAttribute", new Object[]{string, ExtensionPointImpl.this.getId(), ExtensionPointImpl.this.getDeclaringPluginDescriptor().getId()});
            }
        }

        ParameterValueParser getValueParser() {
            return this.valueParser;
        }

        public ExtensionPoint getDeclaringExtensionPoint() {
            return ExtensionPointImpl.this;
        }

        public String getMultiplicity() {
            return this.modelParamDef.getMultiplicity();
        }

        public Collection getSubDefinitions() {
            return this.subDefinitions;
        }

        public ExtensionPoint.ParameterDefinition getSuperDefinition() {
            return this.superDefinition;
        }

        public ExtensionPoint.ParameterDefinition getSubDefinition(String string) {
            for (ParameterDefinitionImpl parameterDefinitionImpl : this.subDefinitions) {
                if (!parameterDefinitionImpl.getId().equals(string)) continue;
                return parameterDefinitionImpl;
            }
            throw new IllegalArgumentException("parameter definition with ID " + string + " not found in extension point " + ExtensionPointImpl.this.getUniqueId());
        }

        public String getType() {
            return this.modelParamDef.getType();
        }

        public String getCustomData() {
            return this.modelParamDef.getCustomData();
        }

        public String getDefaultValue() {
            return this.modelParamDef.getDefaultValue();
        }

        public String toString() {
            return "{PluginExtensionPoint.ParameterDefinition: extPointUid=" + this.getDeclaringExtensionPoint().getUniqueId() + "; id=" + this.getId() + "}";
        }

        protected boolean isEqualTo(Identity identity) {
            if (!super.isEqualTo(identity)) {
                return false;
            }
            ParameterDefinitionImpl parameterDefinitionImpl = (ParameterDefinitionImpl)identity;
            if (this.getSuperDefinition() == null && parameterDefinitionImpl.getSuperDefinition() == null) {
                return true;
            }
            if (this.getSuperDefinition() == null || parameterDefinitionImpl.getSuperDefinition() == null) {
                return false;
            }
            return this.getSuperDefinition().equals(parameterDefinitionImpl.getSuperDefinition());
        }
    }
}

