/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.ManifestProcessingException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginElement;
import org.java.plugin.registry.PluginFragment;
import org.java.plugin.registry.PluginRegistry;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.IntegrityChecker;
import org.java.plugin.registry.xml.ModelExtension;
import org.java.plugin.registry.xml.ModelParameter;
import org.java.plugin.registry.xml.ParameterValueParser;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginElementImpl;
import org.java.plugin.registry.xml.PluginFragmentImpl;

final class ExtensionImpl
extends PluginElementImpl
implements Extension {
    private final ModelExtension model;
    private List parameters;
    private Boolean isValid;

    ExtensionImpl(PluginDescriptorImpl pluginDescriptorImpl, PluginFragmentImpl pluginFragmentImpl, ModelExtension modelExtension) throws ManifestProcessingException {
        super(pluginDescriptorImpl, pluginFragmentImpl, modelExtension.getId(), modelExtension.getDocumentation());
        this.model = modelExtension;
        if (this.model.getPluginId() == null || this.model.getPluginId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extensionIdIsBlank", pluginDescriptorImpl.getId());
        }
        if (this.model.getPointId() == null || this.model.getPointId().trim().length() == 0) {
            throw new ManifestProcessingException("org.java.plugin.registry.xml", "extendedPointIdIsBlank", pluginDescriptorImpl.getId());
        }
        this.parameters = new ArrayList(this.model.getParams().size());
        Iterator iterator = this.model.getParams().iterator();
        while (iterator.hasNext()) {
            this.parameters.add(new ParameterImpl(null, (ModelParameter)iterator.next()));
        }
        this.parameters = Collections.unmodifiableList(this.parameters);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("object instantiated: " + this));
        }
    }

    public String getUniqueId() {
        return this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getDeclaringPluginDescriptor().getId(), this.getId());
    }

    public Collection getParameters() {
        return this.parameters;
    }

    public Extension.Parameter getParameter(String string) {
        ParameterImpl parameterImpl = null;
        for (ParameterImpl parameterImpl2 : this.parameters) {
            if (!parameterImpl2.getId().equals(string)) continue;
            if (parameterImpl == null) {
                parameterImpl = parameterImpl2;
                continue;
            }
            throw new IllegalArgumentException("more than one parameter with ID " + string + " defined in extension " + this.getUniqueId());
        }
        return parameterImpl;
    }

    public Collection getParameters(String string) {
        LinkedList<ParameterImpl> linkedList = new LinkedList<ParameterImpl>();
        for (ParameterImpl parameterImpl : this.parameters) {
            if (!parameterImpl.getId().equals(string)) continue;
            linkedList.add(parameterImpl);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public String getExtendedPluginId() {
        return this.model.getPluginId();
    }

    public String getExtendedPointId() {
        return this.model.getPointId();
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.validate();
        }
        return this.isValid;
    }

    Collection validate() {
        ExtensionPoint extensionPoint = this.getExtensionPoint(this.getExtendedPluginId(), this.getExtendedPointId());
        if (extensionPoint == null) {
            this.isValid = Boolean.FALSE;
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "extPointNotAvailable", new Object[]{this.getDeclaringPluginDescriptor().getRegistry().makeUniqueId(this.getExtendedPluginId(), this.getExtendedPointId()), this.getUniqueId()}));
        }
        Collection collection = this.validateParameters(extensionPoint.getParameterDefinitions(), (Collection)this.parameters);
        this.isValid = collection.isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        return collection;
    }

    ExtensionPoint getExtensionPoint(String string) {
        PluginRegistry pluginRegistry = this.getDeclaringPluginDescriptor().getRegistry();
        return this.getExtensionPoint(pluginRegistry.extractPluginId(string), pluginRegistry.extractId(string));
    }

    ExtensionPoint getExtensionPoint(String string, String string2) {
        PluginRegistry pluginRegistry = this.getDeclaringPluginDescriptor().getRegistry();
        if (!pluginRegistry.isPluginDescriptorAvailable(string)) {
            return null;
        }
        for (ExtensionPoint extensionPoint : pluginRegistry.getPluginDescriptor(string).getExtensionPoints()) {
            if (!extensionPoint.getId().equals(string2)) continue;
            return extensionPoint;
        }
        return null;
    }

    private Collection validateParameters(Collection collection, Collection collection2) {
        Object object;
        LinkedList<IntegrityChecker.ReportItemImpl> linkedList = new LinkedList<IntegrityChecker.ReportItemImpl>();
        HashMap hashMap = new HashMap();
        for (PluginElement pluginElement : collection2) {
            object = pluginElement.getDefinition();
            if (object == null) {
                linkedList.add(new IntegrityChecker.ReportItemImpl(1, this, 6, "cantDetectParameterDef", new Object[]{pluginElement.getId(), this.getUniqueId()}));
                continue;
            }
            if (hashMap.containsKey(pluginElement.getId())) {
                ((Collection)hashMap.get(pluginElement.getId())).add(pluginElement);
                continue;
            }
            LinkedList<PluginElement> linkedList2 = new LinkedList<PluginElement>();
            linkedList2.add(pluginElement);
            hashMap.put(pluginElement.getId(), linkedList2);
        }
        if (!linkedList.isEmpty()) {
            return linkedList;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PluginElement pluginElement;
            object = (Collection)hashMap.get((pluginElement = (ExtensionPoint.ParameterDefinition)iterator.next()).getId());
            linkedList.addAll(this.validateParameters((ExtensionPoint.ParameterDefinition)pluginElement, (Collection)(object != null ? object : Collections.EMPTY_LIST)));
        }
        return linkedList;
    }

    private Collection validateParameters(ExtensionPoint.ParameterDefinition parameterDefinition, Collection collection) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("validating parameters for definition " + parameterDefinition));
        }
        if ("one".equals(parameterDefinition.getMultiplicity()) && collection.size() != 1) {
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "tooManyOrFewParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
        }
        if ("none-or-one".equals(parameterDefinition.getMultiplicity()) && collection.size() > 1) {
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "tooManyParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
        }
        if ("one-or-more".equals(parameterDefinition.getMultiplicity()) && collection.isEmpty()) {
            return Collections.singletonList(new IntegrityChecker.ReportItemImpl(1, this, 6, "tooFewParams", new Object[]{parameterDefinition.getId(), this.getUniqueId()}));
        }
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<IntegrityChecker.ReportItemImpl> linkedList = new LinkedList<IntegrityChecker.ReportItemImpl>();
        int n = 1;
        for (ParameterImpl parameterImpl : collection) {
            if (!parameterImpl.isValid()) {
                linkedList.add(new IntegrityChecker.ReportItemImpl(1, this, 6, "invalidParameterValue", new Object[]{parameterDefinition.getId(), new Integer(n), this.getUniqueId()}));
            }
            if (!"any".equals(parameterDefinition.getType()) && linkedList.isEmpty()) {
                linkedList.addAll(this.validateParameters(parameterImpl.getDefinition().getSubDefinitions(), parameterImpl.getSubParameters()));
            }
            ++n;
        }
        return linkedList;
    }

    public String toString() {
        return "{PluginExtension: uid=" + this.getUniqueId() + "}";
    }

    void registryChanged() {
        this.isValid = null;
    }

    private class ParameterImpl
    extends PluginElementImpl
    implements Extension.Parameter {
        private final ModelParameter modelParam;
        private ParameterValueParser valueParser;
        private List subParameters;
        private ExtensionPoint.ParameterDefinition definition;
        private boolean definitionDetected;
        private final ParameterImpl superParameter;

        ParameterImpl(ParameterImpl parameterImpl, ModelParameter modelParameter) throws ManifestProcessingException {
            super(ExtensionImpl.this.getDeclaringPluginDescriptor(), ExtensionImpl.this.getDeclaringPluginFragment(), modelParameter.getId(), modelParameter.getDocumentation());
            this.definition = null;
            this.definitionDetected = false;
            this.superParameter = parameterImpl;
            this.modelParam = modelParameter;
            this.subParameters = new ArrayList(this.modelParam.getParams().size());
            Iterator iterator = this.modelParam.getParams().iterator();
            while (iterator.hasNext()) {
                this.subParameters.add(new ParameterImpl(this, (ModelParameter)iterator.next()));
            }
            this.subParameters = Collections.unmodifiableList(this.subParameters);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("object instantiated: " + this));
            }
        }

        public Extension getDeclaringExtension() {
            return ExtensionImpl.this;
        }

        public PluginDescriptor getDeclaringPluginDescriptor() {
            return ExtensionImpl.this.getDeclaringPluginDescriptor();
        }

        public PluginFragment getDeclaringPluginFragment() {
            return ExtensionImpl.this.getDeclaringPluginFragment();
        }

        public ExtensionPoint.ParameterDefinition getDefinition() {
            Collection collection;
            if (this.definitionDetected) {
                return this.definition;
            }
            this.definitionDetected = true;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("detecting definition for parameter " + this));
            }
            if (this.superParameter != null) {
                if (this.superParameter.getDefinition() == null) {
                    return null;
                }
                if ("any".equals(this.superParameter.getDefinition().getType())) {
                    this.definition = this.superParameter.getDefinition();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("definition detected - " + this.definition));
                    }
                    return this.definition;
                }
                collection = this.superParameter.getDefinition().getSubDefinitions();
            } else {
                collection = ExtensionImpl.this.getExtensionPoint(this.getDeclaringExtension().getExtendedPluginId(), this.getDeclaringExtension().getExtendedPointId()).getParameterDefinitions();
            }
            for (ExtensionPoint.ParameterDefinition parameterDefinition : collection) {
                if (!parameterDefinition.getId().equals(this.getId())) continue;
                this.definition = parameterDefinition;
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("definition detected - " + this.definition));
            }
            return this.definition;
        }

        public Extension.Parameter getSuperParameter() {
            return this.superParameter;
        }

        public Collection getSubParameters() {
            return this.subParameters;
        }

        public Extension.Parameter getSubParameter(String string) {
            ParameterImpl parameterImpl = null;
            for (ParameterImpl parameterImpl2 : this.subParameters) {
                if (!parameterImpl2.getId().equals(string)) continue;
                if (parameterImpl == null) {
                    parameterImpl = parameterImpl2;
                    continue;
                }
                throw new IllegalArgumentException("more than one parameter with ID " + string + " defined in extension " + ExtensionImpl.this.getUniqueId());
            }
            return parameterImpl;
        }

        public Collection getSubParameters(String string) {
            LinkedList<ParameterImpl> linkedList = new LinkedList<ParameterImpl>();
            for (ParameterImpl parameterImpl : this.subParameters) {
                if (!parameterImpl.getId().equals(string)) continue;
                linkedList.add(parameterImpl);
            }
            return Collections.unmodifiableList(linkedList);
        }

        public String rawValue() {
            return this.modelParam.getValue() != null ? this.modelParam.getValue() : "";
        }

        boolean isValid() {
            if (this.valueParser != null) {
                return this.valueParser.isParsingSucceeds();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("validating parameter " + this));
            }
            this.valueParser = new ParameterValueParser(this.getDeclaringPluginDescriptor().getRegistry(), this.getDefinition(), this.modelParam.getValue());
            if (!this.valueParser.isParsingSucceeds()) {
                this.log.warn((Object)("parsing value for parameter " + this + " failed, message is: " + this.valueParser.getParsingMessage()));
            }
            return this.valueParser.isParsingSucceeds();
        }

        public Boolean valueAsBoolean() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"boolean".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not boolean");
            }
            if (this.valueParser.getValue() == null) {
                return (Boolean)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Boolean)this.valueParser.getValue();
        }

        public Date valueAsDate() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!("date".equals(this.definition.getType()) || "date-time".equals(this.definition.getType()) || "time".equals(this.definition.getType()))) {
                throw new UnsupportedOperationException("parameter type is not date nor date-time nortime");
            }
            if (this.valueParser.getValue() == null) {
                return (Date)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Date)this.valueParser.getValue();
        }

        public Number valueAsNumber() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"number".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not number");
            }
            if (this.valueParser.getValue() == null) {
                return (Number)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Number)this.valueParser.getValue();
        }

        public String valueAsString() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"string".equals(this.definition.getType()) && !"fixed".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not string");
            }
            if (this.valueParser.getValue() == null) {
                return (String)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (String)this.valueParser.getValue();
        }

        public Extension valueAsExtension() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"extension-id".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not extension-id");
            }
            if (this.valueParser.getValue() == null) {
                return (Extension)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (Extension)this.valueParser.getValue();
        }

        public ExtensionPoint valueAsExtensionPoint() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"extension-point-id".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not extension-point-id");
            }
            if (this.valueParser.getValue() == null) {
                return (ExtensionPoint)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (ExtensionPoint)this.valueParser.getValue();
        }

        public PluginDescriptor valueAsPluginDescriptor() {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"plugin-id".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not plugin-id");
            }
            if (this.valueParser.getValue() == null) {
                return (PluginDescriptor)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue();
            }
            return (PluginDescriptor)this.valueParser.getValue();
        }

        public URL valueAsUrl() {
            return this.valueAsUrl(null);
        }

        public URL valueAsUrl(PathResolver pathResolver) {
            if (!this.isValid()) {
                throw new UnsupportedOperationException("parameter value is invalid");
            }
            if (!"resource".equals(this.definition.getType())) {
                throw new UnsupportedOperationException("parameter type is not resource");
            }
            if (this.valueParser.getValue() == null && this.rawValue() == null) {
                return this.valueAsUrl(pathResolver, this.getDefinition().getDeclaringExtensionPoint(), (URL)((ExtensionPointImpl.ParameterDefinitionImpl)this.getDefinition()).getValueParser().getValue(), this.getDefinition().getDefaultValue());
            }
            return this.valueAsUrl(pathResolver, this.getDeclaringPluginDescriptor(), (URL)this.valueParser.getValue(), this.rawValue());
        }

        private URL valueAsUrl(PathResolver pathResolver, Identity identity, URL uRL, String string) {
            if (pathResolver == null || uRL != null) {
                return uRL;
            }
            if (string == null) {
                return null;
            }
            return pathResolver.resolvePath(identity, string);
        }

        public String toString() {
            return "{PluginExtension.Parameter: extUid=" + this.getDeclaringExtension().getUniqueId() + "; id=" + this.getId() + "}";
        }

        protected boolean isEqualTo(Identity identity) {
            if (!super.isEqualTo(identity)) {
                return false;
            }
            ParameterImpl parameterImpl = (ParameterImpl)identity;
            if (this.getSuperParameter() == null && parameterImpl.getSuperParameter() == null) {
                return true;
            }
            if (this.getSuperParameter() == null || parameterImpl.getSuperParameter() == null) {
                return false;
            }
            return this.getSuperParameter().equals(parameterImpl.getSuperParameter());
        }
    }
}

