/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetLoader;

public class NeuralNetRunner
implements NeuralNetListener {
    public NeuralNet nnet;
    public int result = 0;
    private String snetFileName;
    private String snetOutputFileName;
    private long lPrintCicle = 1000L;

    public static void main(String[] args) {
        NeuralNetRunner nnRunner = new NeuralNetRunner();
        if (args.length < 1) {
            System.out.println("Usage: java NeuralNetRunner -snet <snetFile> [-printcicle <integer>] -snetout <snetOutputFile");
            System.out.println("where <snetFile> is the Serialized Output from Joone Edit");
            System.out.println("where <integer> is the Multiple of cicles output should be printed to standard output");
            System.out.println("where <snetOutputFile> is filename for NeuralNetRunner to save the NeurlalNet as it is processing.");
            System.exit(1);
        } else {
            for (int n = 0; n < args.length; ++n) {
                if (args[n].equals("-snet")) {
                    nnRunner.snetFileName = args[++n];
                    continue;
                }
                if (args[n].equals("-printcicle")) {
                    nnRunner.lPrintCicle = Long.parseLong(args[++n]);
                    continue;
                }
                if (args[n].equals("-snetout")) {
                    nnRunner.snetOutputFileName = args[++n];
                    continue;
                }
                throw new IllegalArgumentException("Unknown argument.");
            }
        }
        if (nnRunner.snetFileName == null) {
            System.out.println("ERROR: A snet input parameter is required to run");
            System.exit(1);
        } else if (nnRunner.snetFileName.equals(nnRunner.snetOutputFileName)) {
            System.out.println("ERROR: The output snet should not be the same as the input snet .");
            System.exit(1);
        }
        NeuralNetLoader nnl = new NeuralNetLoader(nnRunner.snetFileName);
        nnRunner.setNnet(nnl.getNeuralNet());
        nnRunner.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.nnet != null) {
            this.nnet.getMonitor().addNeuralNetListener(this);
            this.nnet.start();
            this.nnet.getMonitor().Go();
            NeuralNetRunner neuralNetRunner = this;
            synchronized (neuralNetRunner) {
                try {
                    while (this.result == 0) {
                        this.wait();
                    }
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
        throw new RuntimeException("Can't work: the neural net is null");
    }

    public void cicleTerminated(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        long c = mon.getCurrentCicle();
        long cl = c / this.lPrintCicle;
        if (cl * this.lPrintCicle == c) {
            System.out.println(c + " cycles remaining - Error = " + mon.getGlobalError());
            this.writeNnet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void netStopped(NeuralNetEvent e) {
        NeuralNetRunner neuralNetRunner = this;
        synchronized (neuralNetRunner) {
            this.result = 1;
            this.notifyAll();
        }
    }

    public void writeNnet() {
        if (this.snetOutputFileName != null) {
            try {
                FileOutputStream stream = new FileOutputStream(this.snetOutputFileName);
                ObjectOutputStream output = new ObjectOutputStream(stream);
                output.writeObject(this.nnet);
                output.close();
            }
            catch (IOException ioe) {
                System.err.println("Error writing nnet: " + ioe);
            }
        }
    }

    public NeuralNet getNnet() {
        return this.nnet;
    }

    public void setNnet(NeuralNet nnet) {
        this.nnet = nnet;
    }

    public void resetNnet() {
        this.nnet.resetInput();
    }

    public void netStarted(NeuralNetEvent e) {
        System.out.println("Running...");
    }

    public void errorChanged(NeuralNetEvent e) {
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }
}

