/*
 * Decompiled with CFR 0.152.
 */
package org.joone.script;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class JooneScript {
    private static final ILogger log = LoggerFactory.getLogger(JooneScript.class);
    private Interpreter jShell;

    private Interpreter getShell() {
        if (this.jShell == null) {
            this.jShell = new Interpreter();
            try {
                this.jShell.eval("import org.joone.engine.*;");
                this.jShell.eval("import org.joone.engine.learning.*;");
                this.jShell.eval("import org.joone.edit.*;");
                this.jShell.eval("import org.joone.util.*;");
                this.jShell.eval("import org.joone.net.*;");
                this.jShell.eval("import org.joone.io.*;");
                this.jShell.eval("import org.joone.script.*;");
            }
            catch (EvalError err) {
                log.error("EvalError thrown. Message is " + err.getMessage(), err);
                return null;
            }
        }
        return this.jShell;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: java org.joone.script.JooneScript <script_file>");
        } else {
            JooneScript jScript = new JooneScript();
            jScript.source(args[0]);
        }
    }

    public void source(String fileName) {
        try {
            this.getShell().source(fileName);
        }
        catch (FileNotFoundException fnfe) {
            log.error("FileNotFoundException thrown. Message is : " + fnfe.getMessage(), fnfe);
        }
        catch (IOException ioe) {
            log.error("IOException thrown. Message is : " + ioe.getMessage(), ioe);
        }
        catch (EvalError err) {
            log.warn("EvalError thrown. Message is : " + err.getMessage(), err);
            System.out.println("Invalid BeanShell code!");
        }
    }

    public void eval(String script) {
        try {
            this.getShell().eval(script);
        }
        catch (EvalError err) {
            log.warn("Error while evaluating. Message is : " + err.getMessage(), err);
            System.out.println("Invalid BeanShell code!");
            err.printStackTrace();
        }
    }

    public void set(String name, Object jObject) {
        try {
            this.getShell().set(name, jObject);
        }
        catch (EvalError err) {
            err.printStackTrace();
        }
    }
}

