/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.util;

import org.joone.exception.JooneRuntimeException;
import org.joone.io.MemoryInputTokenizer;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class EncoderInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(EncoderInputSynapse.class);
    private int size = 0;
    private double upperBit = 1.0;
    private double lowerBit = 0.0;

    public EncoderInputSynapse() {
    }

    public EncoderInputSynapse(double aLowerBit, double anUpperBit) {
        this.lowerBit = aLowerBit;
        this.upperBit = anUpperBit;
    }

    protected void initInputStream() throws JooneRuntimeException {
        this.setAdvancedColumnSelector("1-" + this.size);
        this.setTokens(new MemoryInputTokenizer(this.createEncoderArray()));
    }

    public void setSize(int aSize) {
        this.size = aSize;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumOfPatterns() {
        return this.size;
    }

    protected double[][] createEncoderArray() {
        int myPatterns = this.getNumOfPatterns();
        double[][] myInstance = new double[myPatterns][this.getSize()];
        for (int i = 0; i < myPatterns; ++i) {
            for (int j = 0; j < this.getSize(); ++j) {
                myInstance[i][j] = this.getLowerBit();
            }
            myInstance[i][i] = this.getUpperBit();
        }
        return myInstance;
    }

    public void setUpperBit(double aValue) {
        this.upperBit = aValue;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double aValue) {
        this.lowerBit = aValue;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }
}

