/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.Serializable;
import java.util.Vector;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.FahlmanTeacherSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.InputConnector;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.samples.util.ParityInputSynapse;
import org.joone.util.LearningSwitch;

public class XORFahlman
implements Serializable,
NeuralNetListener,
NeuralValidationListener {
    private NeuralNet nnet = null;
    private Vector validationCycles = new Vector();
    private long mills;

    public static void main(String[] args) {
        XORFahlman xor = new XORFahlman();
        xor.Go();
    }

    public void Go() {
        LinearLayer input = new LinearLayer();
        SigmoidLayer hidden = new SigmoidLayer();
        SigmoidLayer output = new SigmoidLayer();
        input.setLayerName("input");
        hidden.setLayerName("hidden");
        output.setLayerName("output");
        input.setRows(2);
        hidden.setRows(3);
        output.setRows(1);
        FullSynapse synapse_IH = new FullSynapse();
        FullSynapse synapse_HO = new FullSynapse();
        synapse_IH.setName("IH");
        synapse_HO.setName("HO");
        input.addOutputSynapse(synapse_IH);
        hidden.addInputSynapse(synapse_IH);
        hidden.addOutputSynapse(synapse_HO);
        output.addInputSynapse(synapse_HO);
        ParityInputSynapse inputStream = new ParityInputSynapse();
        inputStream.setParitySize(2);
        InputConnector myInputData = new InputConnector();
        myInputData.setInputSynapse(inputStream);
        myInputData.setAdvancedColumnSelector("1-2");
        InputConnector myInputValData = new InputConnector();
        myInputValData.setInputSynapse(inputStream);
        myInputValData.setAdvancedColumnSelector("1-2");
        LearningSwitch mySwitch = new LearningSwitch();
        mySwitch.addTrainingSet(myInputData);
        mySwitch.addValidationSet(myInputValData);
        input.addInputSynapse(mySwitch);
        FahlmanTeacherSynapse myFahlman = new FahlmanTeacherSynapse();
        InputConnector myDesiredData = new InputConnector();
        myDesiredData.setInputSynapse(inputStream);
        myDesiredData.setAdvancedColumnSelector("3");
        InputConnector myDesiredValData = new InputConnector();
        myDesiredValData.setInputSynapse(inputStream);
        myDesiredValData.setAdvancedColumnSelector("3");
        LearningSwitch myOutputSwitch = new LearningSwitch();
        myOutputSwitch.addTrainingSet(myDesiredData);
        myOutputSwitch.addValidationSet(myDesiredValData);
        TeachingSynapse trainer = new TeachingSynapse(myFahlman);
        trainer.setDesired(myOutputSwitch);
        output.addOutputSynapse(trainer);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(input, 0);
        this.nnet.addLayer(hidden, 1);
        this.nnet.addLayer(output, 2);
        this.nnet.setTeacher(trainer);
        this.nnet.getMonitor().setTrainingPatterns(4);
        this.nnet.getMonitor().setValidationPatterns(4);
        this.nnet.getMonitor().setTotCicles(10000);
        this.nnet.getMonitor().setLearning(true);
        this.nnet.getMonitor().setLearningRate(0.8);
        this.nnet.getMonitor().setMomentum(0.3);
        this.mills = System.currentTimeMillis();
        this.nnet.addNeuralNetListener(this);
        this.nnet.go();
    }

    public void netStopped(NeuralNetEvent e) {
        long delay = System.currentTimeMillis() - this.mills;
        System.out.println("Training finished after " + delay + " ms");
        System.exit(0);
    }

    public void cicleTerminated(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        long c = mon.getCurrentCicle();
        if (c % 200L == 0L) {
            this.nnet.getMonitor().setExporting(true);
            NeuralNet myClone = this.nnet.cloneNet();
            this.nnet.getMonitor().setExporting(false);
            myClone.removeAllListeners();
            myClone.getMonitor().setParam("FAHLMAN_CRITERION", Boolean.TRUE);
            NeuralNetValidator myValidator = new NeuralNetValidator(myClone);
            myValidator.addValidationListener(this);
            this.validationCycles.add(new Integer(this.nnet.getMonitor().getTotCicles() - this.nnet.getMonitor().getCurrentCicle()));
            myValidator.start();
        }
    }

    public void netStarted(NeuralNetEvent e) {
        System.out.println("Training...");
    }

    public void errorChanged(NeuralNetEvent e) {
        Monitor mon = (Monitor)e.getSource();
        long c = mon.getCurrentCicle();
        if (c % 100L == 0L) {
            System.out.println(c + " cycles remaining - Error = " + mon.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
    }

    public void netValidated(NeuralValidationEvent event) {
        Monitor myMonitor = ((NeuralNet)event.getSource()).getMonitor();
        if (myMonitor.getParam("FAHLMAN_CRITERION") != null && ((Boolean)myMonitor.getParam("FAHLMAN_CRITERION")).booleanValue() && this.nnet.isRunning()) {
            this.nnet.stop();
            System.out.println("Fahlman criterion fulfilled (at cycle " + (Integer)this.validationCycles.get(0) + ")...");
        }
        this.validationCycles.remove(0);
    }
}

