/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.validation;

import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import org.joone.engine.Layer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.inspection.implementations.InputsInspection;
import org.joone.io.InputSwitchSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;

public class NeuralNetTester
implements Runnable,
NeuralNetListener,
NeuralValidationListener {
    private Vector listeners;
    private NeuralNet oldNetwork;
    private NeuralNet newNetwork;
    private Thread myThread = null;
    private double lastRSME;
    private int minimaEpochs;
    private int problem;
    private boolean relaunch;
    private static int relaunchNumber;
    private boolean learnCurve;

    public NeuralNetTester(NeuralNet _network, boolean lCurve, int _problem) {
        this.problem = _problem;
        this.listeners = new Vector();
        this.oldNetwork = _network;
        this.newNetwork = this.cloneNet(_network);
        this.learnCurve = lCurve;
        this.lastRSME = 0.0;
        this.minimaEpochs = 0;
        this.relaunch = false;
    }

    public void addValidationListener(NeuralValidationListener newListener) {
        if (!this.listeners.contains(newListener)) {
            this.listeners.addElement(newListener);
        }
    }

    protected void train() {
        this.newNetwork.getMonitor().addNeuralNetListener(this);
        this.newNetwork.getMonitor().setLearning(true);
        this.newNetwork.getMonitor().setValidation(false);
        this.newNetwork.start();
        this.newNetwork.getMonitor().Go();
    }

    protected void validate() {
        if (!this.learnCurve) {
            System.out.print("\nTraining Finished \n");
            System.out.print("\nValidation Started\n\n");
        }
        NeuralNetValidator nnv = new NeuralNetValidator(this.cloneNet(this.newNetwork));
        nnv.addValidationListener(this);
        nnv.start();
    }

    private NeuralNet cloneNet(NeuralNet oldNet) {
        oldNet.getMonitor().setExporting(true);
        NeuralNet newNet = oldNet.cloneNet();
        oldNet.getMonitor().setExporting(false);
        newNet.removeAllListeners();
        return newNet;
    }

    private void fireNetValidated(NeuralValidationEvent event) {
        NeuralNet NN = (NeuralNet)event.getSource();
        for (int i = 0; i < this.listeners.size(); ++i) {
            NeuralValidationListener nvl = (NeuralValidationListener)this.listeners.elementAt(i);
            nvl.netValidated(new NeuralValidationEvent(NN));
        }
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.myThread.start();
        }
    }

    public void run() {
        this.train();
        this.myThread = null;
    }

    public void netStopped(NeuralNetEvent e) {
        if (!this.learnCurve) {
            if (this.relaunch) {
                ++relaunchNumber;
                this.relaunch = false;
                this.minimaEpochs = 0;
                this.newNetwork = this.cloneNet(this.oldNetwork);
                this.inputRandomize();
                this.newNetwork.resetInput();
                switch (this.problem) {
                    case 1: {
                        this.newNetwork.randomize(0.7);
                        break;
                    }
                    case 2: {
                        this.newNetwork.randomize(0.5);
                        break;
                    }
                    case 3: {
                        this.newNetwork.randomize(0.5);
                    }
                }
                this.train();
                System.out.print(" Training Relaunched: " + relaunchNumber + "\n\n");
            } else {
                this.validate();
            }
        } else if (this.relaunch) {
            System.out.print("Relaunch Number: " + ++relaunchNumber + "\n");
            this.relaunch = false;
            this.minimaEpochs = 0;
            this.newNetwork = this.cloneNet(this.oldNetwork);
            this.inputRandomize();
            this.newNetwork.resetInput();
            switch (this.problem) {
                case 1: {
                    this.newNetwork.randomize(0.7);
                    break;
                }
                case 2: {
                    this.newNetwork.randomize(0.5);
                    break;
                }
                case 3: {
                    this.newNetwork.randomize(0.5);
                }
            }
            this.train();
        } else {
            this.validate();
        }
    }

    public void netValidated(NeuralValidationEvent event) {
        this.fireNetValidated(event);
        if (!this.learnCurve) {
            System.out.print("\nValidation Finished\n");
        }
    }

    public void cicleTerminated(NeuralNetEvent e) {
        if (!this.learnCurve) {
            double currentError = this.newNetwork.getMonitor().getGlobalError();
            int currentCycle = this.newNetwork.getMonitor().getCurrentCicle();
            int cycles = this.newNetwork.getMonitor().getTotCicles();
            int printCycle = currentCycle / 10;
            if (printCycle * 10 == currentCycle) {
                int remaining = cycles - currentCycle;
                int percentage = remaining * 100 / cycles;
                System.out.print("RSME: " + currentError + "\n");
            }
        }
    }

    public void netStarted(NeuralNetEvent e) {
    }

    public void errorChanged(NeuralNetEvent event) {
        Monitor monitor = (Monitor)event.getSource();
        double rmse = monitor.getGlobalError();
        if (rmse <= 0.05) {
            monitor.Stop();
        } else {
            this.minimaEpochs = this.lastRSME <= monitor.getGlobalError() + 5.0E-7 ? ++this.minimaEpochs : 0;
        }
        this.lastRSME = monitor.getGlobalError();
        if (this.minimaEpochs == 3000) {
            if (!this.learnCurve) {
                System.out.print("\n\n Training Patterns: " + monitor.getTrainingPatterns() + " - LOCAL MINIMA STUCK \n");
            }
            this.relaunch = true;
            monitor.Stop();
        }
    }

    private void inputRandomize() {
        boolean notNullFlag = false;
        Layer inputLayer = this.newNetwork.getInputLayer();
        Vector inputList = inputLayer.getAllInputs();
        StreamInputSynapse inputSynapse = null;
        for (int i = 0; i < inputList.size(); ++i) {
            InputSwitchSynapse inputSwitchTemporal = (InputSwitchSynapse)inputList.elementAt(i);
            if (!inputSwitchTemporal.getName().equals("Input Switch Synapse")) continue;
            Vector inputSwitch = inputSwitchTemporal.getAllInputs();
            for (int j = 0; j < inputSwitch.size(); ++j) {
                StreamInputSynapse inputSynapseTemporal = (StreamInputSynapse)inputSwitch.elementAt(i);
                if (!inputSynapseTemporal.getName().equals("Learning Input Synapse")) continue;
                inputSynapse = inputSynapseTemporal;
                notNullFlag = true;
            }
        }
        if (notNullFlag) {
            Collection inputCollection = inputSynapse.Inspections();
            Iterator temporalIterator = inputCollection.iterator();
            InputsInspection temporalInspection = (InputsInspection)temporalIterator.next();
            Object[][] inputElements = temporalInspection.getComponent();
            Random joker = new Random();
            int changerPatternNumberA = joker.nextInt(inputElements.length);
            int changedPatternNumberA = joker.nextInt(inputElements.length);
            int changerPatternNumberB = joker.nextInt(inputElements.length);
            int changedPatternNumberB = joker.nextInt(inputElements.length);
            Object[] temporalPatternA = inputElements[changedPatternNumberA];
            Object[] temporalPatternB = inputElements[changedPatternNumberB];
            inputElements[changedPatternNumberA] = inputElements[changerPatternNumberA];
            inputElements[changerPatternNumberA] = temporalPatternA;
            inputElements[changedPatternNumberB] = inputElements[changerPatternNumberB];
            inputElements[changerPatternNumberB] = temporalPatternB;
            temporalInspection.setComponent(inputElements);
            this.inputRandomizeCheck();
        }
    }

    private void inputRandomizeCheck() {
        boolean notNullFlagCheck = false;
        Layer inputLayerCheck = this.newNetwork.getInputLayer();
        Vector inputListCheck = inputLayerCheck.getAllInputs();
        StreamInputSynapse inputSynapseCheck = null;
        for (int i = 0; i < inputListCheck.size(); ++i) {
            InputSwitchSynapse inputSwitchTemporalCheck = (InputSwitchSynapse)inputListCheck.elementAt(i);
            if (!inputSwitchTemporalCheck.getName().equals("Input Switch Synapse")) continue;
            Vector inputSwitch = inputSwitchTemporalCheck.getAllInputs();
            for (int j = 0; j < inputSwitch.size(); ++j) {
                StreamInputSynapse inputSynapseTemporal = (StreamInputSynapse)inputSwitch.elementAt(i);
                if (!inputSynapseTemporal.getName().equals("Learning Input Synapse")) continue;
                inputSynapseCheck = inputSynapseTemporal;
                notNullFlagCheck = true;
            }
        }
        if (notNullFlagCheck) {
            Collection inputCollectionCheck = inputSynapseCheck.Inspections();
            Iterator temporalIteratorCheck = inputCollectionCheck.iterator();
            InputsInspection temporalInspectionCheck = (InputsInspection)temporalIteratorCheck.next();
            Object[][] inputElementsCheck = temporalInspectionCheck.getComponent();
            boolean javaDebugStop = false;
        }
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        System.out.print("Stopped in Error \n");
    }
}

