/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class XLSOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(XLSOutputSynapse.class);
    static final long serialVersionUID = -9167076940131905606L;
    private String FileName = "";
    private transient FileOutputStream o_stream;
    private transient FileInputStream i_stream;
    private transient HSSFSheet o_sheet;
    private int o_sheet_index = -1;
    private int row_no = 0;
    private int startCol = 0;
    private int startRow = 0;
    private transient HSSFWorkbook workbook;
    private String o_sheet_name = new String("j_output");

    public void flush() {
        block2: {
            try {
                this.workbook.write((OutputStream)this.o_stream);
            }
            catch (IOException ioe) {
                String error = "IOException in " + this.getName() + ". Message is : ";
                log.warn(error + ioe);
                if (this.getMonitor() == null) break block2;
                new NetErrorManager(this.getMonitor(), error + ioe.getMessage());
            }
        }
    }

    public synchronized void write(Pattern pattern) {
        String error;
        block10: {
            if (this.workbook == null || pattern.getCount() == 1) {
                try {
                    this.initOutputStream();
                }
                catch (IOException ioe) {
                    error = "IOException in " + this.getName() + ". Message is : ";
                    log.warn(error + ioe);
                    if (this.getMonitor() == null) break block10;
                    new NetErrorManager(this.getMonitor(), error + ioe.getMessage());
                }
            }
        }
        if (pattern.getCount() == -1) {
            try {
                this.o_stream = new FileOutputStream(this.FileName);
                this.workbook.write((OutputStream)this.o_stream);
                this.o_stream.close();
                this.row_no = this.startRow;
                this.workbook = null;
            }
            catch (IOException ioe) {
                error = "IOException in " + this.getName() + ". Message is : ";
                log.warn(error + ioe);
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), error + ioe.getMessage());
                }
            }
        } else {
            double[] array = pattern.getArray();
            HSSFRow row = this.o_sheet.getRow(this.row_no) == null ? this.o_sheet.createRow((short)this.row_no) : this.o_sheet.getRow(this.row_no);
            for (int i = 0; i < array.length; ++i) {
                if (row.getCell((short)(i + this.startCol)) != null) {
                    row.removeCell(row.getCell((short)(i + this.startCol)));
                }
                HSSFCell cell = row.createCell((short)(i + this.startCol), 0);
                cell.setCellValue(array[i]);
            }
            ++this.row_no;
        }
    }

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String fn) {
        this.FileName = fn;
    }

    private void initOutputStream() throws IOException {
        if (new File(this.FileName).exists()) {
            this.i_stream = new FileInputStream(this.FileName);
            POIFSFileSystem i_fs = new POIFSFileSystem((InputStream)this.i_stream);
            this.workbook = new HSSFWorkbook(i_fs);
            this.i_stream.close();
        } else {
            this.o_stream = new FileOutputStream(this.FileName);
            this.workbook = new HSSFWorkbook();
            this.workbook.write((OutputStream)this.o_stream);
            this.o_stream.close();
        }
        this.o_sheet_index = this.workbook.getSheetIndex(this.o_sheet_name);
        this.o_sheet = this.o_sheet_index != -1 ? this.workbook.getSheetAt(this.o_sheet_index) : this.workbook.createSheet(this.o_sheet_name);
        this.row_no = this.startRow;
    }

    public void setSheetName(String sheetName) {
        this.o_sheet_name = sheetName;
    }

    public String[] getAvailableSheetList() {
        int sheetCount = this.workbook.getNumberOfSheets();
        String[] availableSheetList = null;
        for (int i = 0; i > sheetCount; ++i) {
            availableSheetList[i] = this.workbook.getSheetName(i);
        }
        return availableSheetList;
    }

    public String getSheetName() {
        return this.o_sheet_name;
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.FileName == null || this.FileName.trim().equals("")) {
            checks.add(new NetCheck(0, "File Name not set.", this));
        }
        return checks;
    }

    public int getStartRow(int startRow) {
        return startRow;
    }

    public int getStartCol(int startCol) {
        return startCol;
    }

    public void setStartRow(int startRow) {
        this.startRow = startRow;
    }

    public void setStartCol(int startCol) {
        this.startCol = startCol;
    }
}

