/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.joone.engine.Pattern;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class ImageOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(ImageOutputSynapse.class);
    static final long serialVersionUID = 1287752494948170142L;
    public final int JPG = 1;
    public final int GIF = 2;
    public final int PNG = 3;
    private String OutputDirectory = System.getProperty("user.dir");
    private int ImageFileType = 1;
    private int Width = 10;
    private int Height = 10;
    private boolean ColourMode = true;

    public void write(Pattern pattern) {
        if (pattern.getCount() != -1) {
            String formatName;
            switch (this.getImageFileType()) {
                case 1: {
                    formatName = "jpg";
                    break;
                }
                case 2: {
                    formatName = "gif";
                    break;
                }
                case 3: {
                    formatName = "png";
                    break;
                }
                default: {
                    formatName = "jpg";
                }
            }
            try {
                String outDir = this.getOutputDirectory();
                if (!outDir.endsWith(System.getProperty("file.separator"))) {
                    outDir = outDir + System.getProperty("file.separator");
                }
                File theOutFile = new File(outDir + "Image" + pattern.getCount() + "." + formatName);
                BufferedImage outImage = this.patternToImage(pattern);
                if (outImage != null) {
                    ImageIO.write((RenderedImage)outImage, formatName, theOutFile);
                }
            }
            catch (Exception ex) {
                log.error("Caught exception when trying to write Image : " + ex.toString());
            }
        }
    }

    private BufferedImage patternToImage(Pattern pat) {
        BufferedImage theImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        double[] array = pat.getArray();
        int Red = 0;
        int Green = 0;
        int Blue = 0;
        int rgb = 0;
        int x = 0;
        int y = 0;
        int j = 0;
        if (this.ColourMode) {
            if (array.length == this.getWidth() * this.getHeight() * 3) {
                for (j = 0; j < array.length; j += 3) {
                    Red = (int)(array[j] * 255.0);
                    Green = (int)(array[j + 1] * 255.0);
                    Blue = (int)(array[j + 2] * 255.0);
                    rgb = 0 + (Red << 16) + (Green << 8) + Blue;
                    theImage.setRGB(x, y, rgb);
                    if (++x < this.getWidth()) continue;
                    x = 0;
                    ++y;
                }
            } else {
                log.error("Pattern Contains " + pat.getCount() + " RGB Values - Image Contains " + this.getWidth() * this.getHeight() + " RGB Values , Size Mismatch.");
            }
        } else if (array.length == this.getWidth() * this.getHeight()) {
            for (j = 0; j < array.length; ++j) {
                rgb = (int)(array[j] * 255.0);
                rgb = 0 + (rgb << 16) + (rgb << 8) + rgb;
                theImage.setRGB(x, y, rgb);
                if (++x < this.getWidth()) continue;
                x = 0;
                ++y;
            }
        } else {
            log.error("Pattern Contains " + pat.getCount() + " RGB Values - Image Contains " + this.getWidth() * this.getHeight() + " RGB Values , Size Mismatch.");
        }
        return theImage;
    }

    public String getOutputDirectory() {
        return this.OutputDirectory;
    }

    public void setOutputDirectory(String OutputDirectory) {
        this.OutputDirectory = OutputDirectory;
    }

    public int getImageFileType() {
        return this.ImageFileType;
    }

    public void setImageFileType(int ImageFileType) {
        this.ImageFileType = ImageFileType;
        if (this.ImageFileType < 1) {
            this.ImageFileType = 1;
        }
        if (this.ImageFileType > 3) {
            this.ImageFileType = 3;
        }
    }

    public int getWidth() {
        return this.Width;
    }

    public void setWidth(int Width) {
        this.Width = Width;
    }

    public int getHeight() {
        return this.Height;
    }

    public void setHeight(int Height) {
        this.Height = Height;
    }

    public boolean getColourMode() {
        return this.ColourMode;
    }

    public void setColourMode(boolean ColourMode) {
        this.ColourMode = ColourMode;
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.ColourMode) {
            if (this.Width * this.Height * 3 != this.getInputDimension()) {
                checks.add(new NetCheck(0, "Image Width[" + this.getWidth() + "]*Height[" + this.getHeight() + "]*3 not equal to number of inputs from connected layer/s [" + this.getInputDimension() + "].", this));
            }
        } else if (this.Width * this.Height != this.getInputDimension()) {
            checks.add(new NetCheck(0, "Image Width[" + this.getWidth() + "]*Height[" + this.getHeight() + "] not equal to number of inputs from connected layer/s [" + this.getInputDimension() + "].", this));
        }
        if (this.OutputDirectory.equals("")) {
            checks.add(new NetCheck(0, "No image output directory set.", this));
        }
        return checks;
    }
}

