/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.DelayLayer;
import org.joone.engine.DirectSynapse;
import org.joone.engine.FullSynapse;
import org.joone.engine.GaussianLayer;
import org.joone.engine.KohonenSynapse;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.SoftmaxLayer;
import org.joone.engine.Synapse;
import org.joone.engine.WTALayer;
import org.joone.engine.learning.ComparingSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.engine.listeners.ErrorBasedTerminator;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetAttributes;

public class JooneTools {
    public static final int LINEAR = 1;
    public static final int LOGISTIC = 2;
    public static final int SOFTMAX = 3;
    public static final int WTA = 4;
    public static final int GAUSSIAN = 5;
    public static final int BPROP_ONLINE = 0;
    public static final int BPROP_BATCH = 1;
    public static final int RPROP = 2;

    public static NeuralNet create_standard(int[] nodes, int outputType) throws IllegalArgumentException {
        NeuralNet nnet = new NeuralNet();
        if (nodes == null || nodes.length < 2) {
            throw new IllegalArgumentException("create_standard: Nodes is empty");
        }
        Layer[] layers = new Layer[nodes.length];
        layers[0] = new LinearLayer();
        layers[0].setRows(nodes[0]);
        layers[0].setLayerName("input");
        nnet.addLayer(layers[0], 0);
        if (nodes.length > 2) {
            for (int i = 1; i < nodes.length - 1; ++i) {
                layers[i] = new SigmoidLayer();
                layers[i].setRows(nodes[i]);
                layers[i].setLayerName("hidden" + i);
                nnet.addLayer(layers[i], 1);
            }
        }
        int outp = nodes.length - 1;
        switch (outputType) {
            case 1: {
                layers[outp] = new LinearLayer();
                break;
            }
            case 2: {
                layers[outp] = new SigmoidLayer();
                break;
            }
            case 3: {
                layers[outp] = new SoftmaxLayer();
                break;
            }
            default: {
                throw new IllegalArgumentException("create_standard: output type not supported");
            }
        }
        layers[outp].setRows(nodes[outp]);
        layers[outp].setLayerName("output");
        nnet.addLayer(layers[outp], 2);
        for (int i = 0; i < layers.length - 1; ++i) {
            JooneTools.connect(layers[i], new FullSynapse(), layers[i + 1]);
        }
        Monitor mon = nnet.getMonitor();
        mon.addLearner(0, "org.joone.engine.BasicLearner");
        mon.addLearner(1, "org.joone.engine.BatchLearner");
        mon.addLearner(2, "org.joone.engine.RpropLearner");
        mon.setLearningRate(0.7);
        mon.setMomentum(0.7);
        return nnet;
    }

    public static NeuralNet create_timeDelay(int[] nodes, int taps, int outputType) throws IllegalArgumentException {
        NeuralNet nnet = new NeuralNet();
        if (nodes == null || nodes.length < 2) {
            throw new IllegalArgumentException("create_standard: nodes: not enough elements");
        }
        Layer[] layers = new Layer[nodes.length];
        layers[0] = new DelayLayer();
        layers[0].setRows(nodes[0]);
        ((DelayLayer)layers[0]).setTaps(taps);
        layers[0].setLayerName("input");
        nnet.addLayer(layers[0], 0);
        if (nodes.length > 2) {
            for (int i = 1; i < nodes.length - 1; ++i) {
                layers[i] = new SigmoidLayer();
                layers[i].setRows(nodes[i]);
                layers[i].setLayerName("hidden" + i);
                nnet.addLayer(layers[i], 1);
            }
        }
        int outp = nodes.length - 1;
        switch (outputType) {
            case 1: {
                layers[outp] = new LinearLayer();
                break;
            }
            case 2: {
                layers[outp] = new SigmoidLayer();
                break;
            }
            case 3: {
                layers[outp] = new SoftmaxLayer();
                break;
            }
            default: {
                throw new IllegalArgumentException("create_standard: output type not supported");
            }
        }
        layers[outp].setRows(nodes[outp]);
        layers[outp].setLayerName("output");
        nnet.addLayer(layers[outp], 2);
        for (int i = 0; i < layers.length - 1; ++i) {
            JooneTools.connect(layers[i], new FullSynapse(), layers[i + 1]);
        }
        Monitor mon = nnet.getMonitor();
        mon.addLearner(0, "org.joone.engine.BasicLearner");
        mon.addLearner(1, "org.joone.engine.BatchLearner");
        mon.addLearner(2, "org.joone.engine.RpropLearner");
        mon.setLearningRate(0.7);
        mon.setMomentum(0.7);
        return nnet;
    }

    public static NeuralNet create_unsupervised(int[] nodes, int outputType) throws IllegalArgumentException {
        NeuralNet nnet = new NeuralNet();
        if (nodes == null || nodes.length < 3) {
            throw new IllegalArgumentException("create_unsupervised: nodes: not enough elements");
        }
        Layer[] layers = new Layer[2];
        layers[0] = new LinearLayer();
        layers[0].setRows(nodes[0]);
        layers[0].setLayerName("input");
        nnet.addLayer(layers[0], 0);
        switch (outputType) {
            case 4: {
                layers[1] = new WTALayer();
                ((WTALayer)layers[1]).setLayerWidth(nodes[1]);
                ((WTALayer)layers[1]).setLayerHeight(nodes[2]);
                break;
            }
            case 5: {
                layers[1] = new GaussianLayer();
                ((GaussianLayer)layers[1]).setLayerWidth(nodes[1]);
                ((GaussianLayer)layers[1]).setLayerHeight(nodes[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("create_unsupervised: output type not supported");
            }
        }
        layers[1].setLayerName("output");
        nnet.addLayer(layers[1], 2);
        JooneTools.connect(layers[0], new KohonenSynapse(), layers[1]);
        Monitor mon = nnet.getMonitor();
        mon.setLearningRate(0.7);
        return nnet;
    }

    public static double[] interrogate(NeuralNet nnet, double[] input) {
        nnet.removeAllInputs();
        nnet.removeAllOutputs();
        DirectSynapse inputSynapse = new DirectSynapse();
        DirectSynapse outputSynapse = new DirectSynapse();
        nnet.addInputSynapse(inputSynapse);
        nnet.addOutputSynapse(outputSynapse);
        Pattern inputPattern = new Pattern(input);
        inputPattern.setCount(1);
        nnet.getMonitor().setLearning(false);
        nnet.start();
        inputSynapse.fwdPut(inputPattern);
        Pattern outputPattern = outputSynapse.fwdGet();
        inputSynapse.fwdPut(JooneTools.stopPattern(input.length));
        outputSynapse.fwdGet();
        nnet.join();
        return outputPattern.getArray();
    }

    public static double train(NeuralNet nnet, double[][] input, double[][] desired, int epochs, double stopRMSE, int epochs_btw_reports, Object stdOut, boolean async) {
        Monitor mon;
        MemoryInputSynapse memInput = new MemoryInputSynapse();
        memInput.setInputArray(input);
        memInput.setAdvancedColumnSelector("1-" + input[0].length);
        MemoryInputSynapse memTarget = null;
        if (desired != null) {
            memTarget = new MemoryInputSynapse();
            memTarget.setInputArray(desired);
            memTarget.setAdvancedColumnSelector("1-" + desired[0].length);
        }
        if ((mon = nnet.getMonitor()).isValidation()) {
            if (mon.getValidationPatterns() == 0) {
                mon.setValidationPatterns(input.length);
            }
        } else if (mon.getTrainingPatterns() == 0) {
            mon.setTrainingPatterns(input.length);
        }
        return JooneTools.train_on_stream(nnet, memInput, memTarget, epochs, stopRMSE, epochs_btw_reports, stdOut, async);
    }

    public static void train_unsupervised(NeuralNet nnet, double[][] input, int epochs, int epochs_btw_reports, Object stdOut, boolean async) {
        nnet.getMonitor().setSupervised(false);
        JooneTools.train(nnet, input, null, epochs, 0.0, epochs_btw_reports, stdOut, async);
    }

    public static double train_on_stream(NeuralNet nnet, StreamInputSynapse input, StreamInputSynapse desired, int epochs, double stopRMSE, int epochs_btw_reports, Object stdOut, boolean async) {
        nnet.removeAllInputs();
        nnet.removeAllOutputs();
        nnet.addInputSynapse(input);
        if (desired != null) {
            TeachingSynapse teacher = new TeachingSynapse();
            teacher.setDesired(desired);
            nnet.addOutputSynapse(teacher);
            nnet.setTeacher(teacher);
        }
        return JooneTools.train_complete(nnet, epochs, stopRMSE, epochs_btw_reports, stdOut, async);
    }

    public static double train_complete(NeuralNet nnet, int epochs, double stopRMSE, int epochs_btw_reports, Object stdOut, boolean async) {
        nnet.removeAllListeners();
        Monitor mon = nnet.getMonitor();
        if (stdOut != null) {
            mon.addNeuralNetListener(JooneTools.createListener(nnet, stdOut, epochs_btw_reports));
        }
        ErrorBasedTerminator term = null;
        if (stopRMSE > 0.0) {
            term = new ErrorBasedTerminator(stopRMSE);
            term.setNeuralNet(nnet);
            mon.addNeuralNetListener(term);
        }
        mon.setTotCicles(epochs);
        mon.setLearning(!mon.isValidation());
        TreeSet tree = nnet.check();
        if (tree.isEmpty()) {
            nnet.go(!async);
            if (async) {
                return 0.0;
            }
            NeuralNetAttributes attrib = nnet.getDescriptor();
            if (term != null) {
                if (term.isStopRequestPerformed()) {
                    attrib.setLastEpoch(term.getStoppedCycle());
                } else {
                    attrib.setLastEpoch(mon.getTotCicles());
                }
            }
            if (mon.isValidation()) {
                attrib.setValidationError(mon.getGlobalError());
            } else {
                attrib.setTrainingError(mon.getGlobalError());
            }
            return mon.getGlobalError();
        }
        throw new IllegalArgumentException("Cannot start, errors found:" + tree.toString());
    }

    public static double test(NeuralNet nnet, double[][] input, double[][] desired) {
        nnet.getMonitor().setValidation(true);
        return JooneTools.train(nnet, input, desired, 1, 0.0, 0, null, false);
    }

    public static double test_on_stream(NeuralNet nnet, StreamInputSynapse input, StreamInputSynapse desired) {
        nnet.getMonitor().setValidation(true);
        return JooneTools.train_on_stream(nnet, input, desired, 1, 0.0, 0, null, false);
    }

    public static double[][] compare(NeuralNet nnet, double[][] input, double[][] desired) {
        MemoryInputSynapse memInput = new MemoryInputSynapse();
        memInput.setInputArray(input);
        memInput.setAdvancedColumnSelector("1-" + input[0].length);
        MemoryInputSynapse memTarget = null;
        if (desired != null) {
            memTarget = new MemoryInputSynapse();
            memTarget.setInputArray(desired);
            memTarget.setAdvancedColumnSelector("1-" + desired[0].length);
        }
        Monitor mon = nnet.getMonitor();
        nnet.getMonitor().setValidation(true);
        if (mon.getValidationPatterns() == 0) {
            mon.setValidationPatterns(input.length);
        }
        return JooneTools.compare_on_stream(nnet, memInput, memTarget);
    }

    public static double[][] compare_on_stream(NeuralNet nnet, StreamInputSynapse input, StreamInputSynapse desired) {
        nnet.removeAllInputs();
        nnet.removeAllOutputs();
        nnet.addInputSynapse(input);
        ComparingSynapse teacher = new ComparingSynapse();
        teacher.setDesired(desired);
        nnet.addOutputSynapse(teacher);
        MemoryOutputSynapse outStream = new MemoryOutputSynapse();
        teacher.addResultSynapse(outStream);
        JooneTools.train_complete(nnet, 1, 0.0, 0, null, false);
        Vector results = outStream.getAllPatterns();
        int rows = results.size();
        int columns = ((Pattern)results.get(0)).getArray().length;
        double[][] output = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            output[i] = ((Pattern)results.get(i)).getArray();
        }
        return output;
    }

    public static double[][] getDataFromStream(StreamInputSynapse dataSet, int firstRow, int lastRow, int firstCol, int lastCol) {
        dataSet.Inspections();
        Vector data = dataSet.getInputPatterns();
        int rows = lastRow - firstRow + 1;
        int columns = lastCol - firstCol + 1;
        double[][] array = new double[rows][columns];
        for (int r = 0; r < rows; ++r) {
            double[] temp = ((Pattern)data.get(r + firstRow - 1)).getArray();
            for (int c = 0; c < columns; ++c) {
                array[r][c] = temp[c + firstCol - 1];
            }
        }
        return array;
    }

    public static void save(NeuralNet nnet, String fileName) throws FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(fileName);
        JooneTools.save_toStream(nnet, stream);
    }

    public static void save(NeuralNet nnet, File fileName) throws FileNotFoundException, IOException {
        FileOutputStream stream = new FileOutputStream(fileName);
        JooneTools.save_toStream(nnet, stream);
    }

    public static void save_toStream(NeuralNet nnet, OutputStream stream) throws IOException {
        ObjectOutputStream output = new ObjectOutputStream(stream);
        output.writeObject(nnet);
        output.close();
    }

    public static NeuralNet load(String fileName) throws FileNotFoundException, IOException, ClassNotFoundException {
        File NNFile = new File(fileName);
        FileInputStream fin = new FileInputStream(NNFile);
        NeuralNet nnet = JooneTools.load_fromStream(fin);
        fin.close();
        return nnet;
    }

    public static NeuralNet load_fromStream(InputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream oin = new ObjectInputStream(stream);
        NeuralNet nnet = (NeuralNet)oin.readObject();
        oin.close();
        return nnet;
    }

    protected static void connect(Layer l1, Synapse syn, Layer l2) {
        l1.addOutputSynapse(syn);
        l2.addInputSynapse(syn);
    }

    protected static Pattern stopPattern(int size) {
        Pattern stop = new Pattern(new double[size]);
        stop.setCount(-1);
        return stop;
    }

    protected static NeuralNetListener createListener(final NeuralNet nnet, final Object stdOut, final int interval) {
        NeuralNetListener listener = new NeuralNetListener(){
            Object output;
            int interv;
            NeuralNet neuralNet;
            {
                this.output = stdOut;
                this.interv = interval;
                this.neuralNet = nnet;
            }

            public void netStarted(NeuralNetEvent e) {
                if (this.output == null) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).println("Network started");
                } else if (this.output instanceof NeuralNetListener) {
                    e.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).netStarted(e);
                }
            }

            public void cicleTerminated(NeuralNetEvent e) {
                if (this.output == null) {
                    return;
                }
                Monitor mon = (Monitor)e.getSource();
                int epoch = mon.getCurrentCicle() - 1;
                if (interval == 0 || epoch % interval > 0) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).print("Epoch n." + (mon.getTotCicles() - epoch) + " terminated");
                    if (mon.isSupervised()) {
                        ((PrintStream)this.output).print(" - rmse: " + mon.getGlobalError());
                    }
                    ((PrintStream)this.output).println("");
                } else if (this.output instanceof NeuralNetListener) {
                    e.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).cicleTerminated(e);
                }
            }

            public void errorChanged(NeuralNetEvent e) {
                if (this.output == null) {
                    return;
                }
                Monitor mon = (Monitor)e.getSource();
                int epoch = mon.getCurrentCicle() - 1;
                if (interval == 0 || epoch % interval > 0) {
                    return;
                }
                if (this.output instanceof NeuralNetListener) {
                    e.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).errorChanged(e);
                }
            }

            public void netStopped(NeuralNetEvent e) {
                if (this.output == null) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).println("Network stopped");
                } else if (this.output instanceof NeuralNetListener) {
                    e.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).netStopped(e);
                }
            }

            public void netStoppedError(NeuralNetEvent e, String error) {
                if (this.output == null) {
                    return;
                }
                if (this.output instanceof PrintStream) {
                    ((PrintStream)this.output).println("Network stopped with error:" + error);
                } else if (this.output instanceof NeuralNetListener) {
                    e.setNeuralNet(this.neuralNet);
                    ((NeuralNetListener)this.output).netStoppedError(e, error);
                }
            }
        };
        return listener;
    }
}

