/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import org.joone.engine.Pattern;
import org.joone.engine.learning.AbstractTeacherSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class TeacherSynapse
extends AbstractTeacherSynapse {
    protected static final ILogger log = LoggerFactory.getLogger(TeacherSynapse.class);
    protected transient double GlobalError = 0.0;
    private static final long serialVersionUID = -1301682557631180066L;

    protected double calculateError(double aDesired, double anOutput, int anIndex) {
        double myError = aDesired - anOutput;
        this.GlobalError += myError * myError / 2.0;
        return myError;
    }

    protected double calculateGlobalError() {
        double myError = this.GlobalError / (double)this.getMonitor().getNumOfPatterns();
        if (this.getMonitor().isUseRMSE()) {
            myError = Math.sqrt(myError);
        }
        this.GlobalError = 0.0;
        return myError;
    }

    public void fwdPut(Pattern pattern) {
        super.fwdPut(pattern);
        if (pattern.getCount() == -1) {
            this.GlobalError = 0.0;
        }
    }
}

