/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.SpatialMap;

public class GaussianSpatialMap
extends SpatialMap {
    private static final long serialVersionUID = -5578079370364572387L;

    public void ApplyNeighborhoodFunction(double[] distances, double[] n_outs, boolean isLearning) {
        double dFalloff = 0.0;
        double nbhRadius = 1.0;
        double nbhRadiusSq = 1.0;
        double dist_to_node = 0.0;
        int current_output = 0;
        this.extractWinner(distances);
        int winx = this.getWinnerX();
        int winy = this.getWinnerY();
        int winz = this.getWinnerZ();
        nbhRadius = this.getCurrentGaussianSize();
        nbhRadiusSq = nbhRadius * nbhRadius;
        for (int z = 0; z < this.getMapDepth(); ++z) {
            for (int y = 0; y < this.getMapHeight(); ++y) {
                for (int x = 0; x < this.getMapWidth(); ++x) {
                    dist_to_node = this.distanceBetween(winx, winy, winz, x, y, z);
                    dFalloff = this.getCircle2DDistanceFalloff(dist_to_node, nbhRadiusSq);
                    current_output = x + y * this.getMapWidth() + z * (this.getMapWidth() * this.getMapHeight());
                    n_outs[current_output] = dFalloff;
                }
            }
        }
    }

    private double getCircle2DDistanceFalloff(double distSq, double radiusSq) {
        return Math.exp(-distSq / (2.0 * radiusSq));
    }
}

