/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.MemoryLayer;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.net.NetCheck;

public class DelayLayer
extends MemoryLayer {
    private static final long serialVersionUID = 1547734529107850525L;

    public DelayLayer() {
    }

    public DelayLayer(String ElemName) {
        super(ElemName);
    }

    protected void backward(double[] pattern) {
        int length = this.getRows();
        for (int x = 0; x < length; ++x) {
            int ncell = x;
            for (int y = 0; y < this.getTaps(); ++y) {
                this.backmemory[ncell] = this.backmemory[ncell + length];
                int n = ncell;
                this.backmemory[n] = this.backmemory[n] + pattern[ncell];
                ncell += length;
            }
            this.backmemory[ncell] = pattern[ncell];
            this.gradientOuts[x] = this.backmemory[x];
        }
    }

    protected void forward(double[] pattern) {
        int length = this.getRows();
        for (int x = 0; x < length; ++x) {
            int ncell = x + this.getTaps() * length;
            for (int y = this.getTaps(); y > 0; --y) {
                this.memory[ncell] = this.memory[ncell - length];
                this.outs[ncell] = this.memory[ncell];
                ncell -= length;
            }
            this.memory[x] = pattern[x];
            this.outs[x] = this.memory[x];
        }
    }

    public TreeSet check() {
        TreeSet checks = super.check();
        if (this.getTaps() == 0) {
            checks.add(new NetCheck(0, "The Taps parameter cannot be equal to zero.", this));
        }
        if (this.monitor != null && this.monitor.getPreLearning() != this.getTaps() + 1) {
            checks.add(new NetCheck(1, "The correct value for the Monitor PreLearning parameter is Taps + 1", this));
        }
        return checks;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(null));
        return col;
    }
}

