/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.joone.engine.SimpleLayer;
import org.joone.inspection.implementations.BiasInspection;

public class ContextLayer
extends SimpleLayer {
    private double beta = 1.0;
    private double timeConstant = 0.5;
    private static final long serialVersionUID = -8773800970295287404L;

    public ContextLayer() {
    }

    public ContextLayer(String name) {
        super(name);
    }

    public void backward(double[] pattern) {
        int n = this.getRows();
        for (int x = 0; x < n; ++x) {
            this.gradientOuts[x] = pattern[x] * this.beta;
        }
    }

    public void forward(double[] pattern) {
        int n = this.getRows();
        for (int x = 0; x < n; ++x) {
            this.outs[x] = this.beta * (pattern[x] + this.timeConstant * this.outs[x]);
        }
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double beta) {
        this.beta = beta;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double timeConstant) {
        this.timeConstant = timeConstant;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> col = new ArrayList<BiasInspection>();
        col.add(new BiasInspection(null));
        return col;
    }
}

