/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.joone.edit.Wrapper;

public class PropertyPanel
extends JPanel {
    final PropertySheetPanel sheet;
    Wrapper source;

    public PropertyPanel() {
        this.setLayout(new BorderLayout());
        this.sheet = new PropertySheetPanel();
        this.sheet.setMode(0);
        this.sheet.setToolBarVisible(false);
        this.sheet.setDescriptionVisible(false);
        this.sheet.setPreferredSize(new Dimension(60, 170));
        JScrollPane scroll = new JScrollPane((Component)this.sheet);
        this.add((Component)scroll, "Center");
    }

    public void setTarget(Wrapper wrapper) {
        this.source = wrapper;
        Object target = wrapper.getBean();
        PropertyChangeListener listener = (PropertyChangeListener)this.sheet.getClientProperty((Object)"listener");
        if (listener != null) {
            this.sheet.removePropertySheetChangeListener(listener);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(target.getClass());
            this.sheet.setMode(0);
            PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
            this.sheet.setProperties(this.getFilteredProperties(props));
            Property[] properties = this.sheet.getProperties();
            int c = properties.length;
            for (int i = 0; i < c; ++i) {
                try {
                    properties[i].readFromObject(target);
                    continue;
                }
                catch (Exception doNothing) {
                    // empty catch block
                }
            }
            this.setListener(target, this.sheet);
        }
        catch (IntrospectionException ex) {
            ex.printStackTrace();
        }
    }

    public void update() {
        this.source.updateFigure();
    }

    private PropertyDescriptor[] getFilteredProperties(PropertyDescriptor[] origin) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        for (int i = 0; i < origin.length; ++i) {
            PropertyDescriptor prop = origin[i];
            Method getter = prop.getReadMethod();
            Method setter = prop.getWriteMethod();
            if (prop.isHidden() || prop.isExpert() || setter == null || getter == null) continue;
            props.add(prop);
        }
        return props.toArray(new PropertyDescriptor[props.size()]);
    }

    private void setListener(final Object theObject, PropertySheetPanel sheet) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Property prop = (Property)evt.getSource();
                prop.writeToObject(theObject);
                if (theObject instanceof JComponent) {
                    ((JComponent)theObject).repaint();
                }
                PropertyPanel.this.source.updateFigure();
            }
        };
        sheet.addPropertySheetChangeListener(listener);
        sheet.putClientProperty((Object)"listener", (Object)listener);
        sheet.repaint();
    }
}

