/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Vector;
import org.joone.edit.ErrorDialog;
import org.joone.edit.WindowCloser;

public class PropertyNameDialog
extends Dialog
implements ActionListener {
    private Button okButton;
    private Button cancelButton;
    private List list;
    private Vector properties;
    private PropertyDescriptor result;
    private static final long serialVersionUID = 7574936938123171751L;

    PropertyNameDialog(Frame frame, Object source, String message, Class match, boolean readable) {
        super(frame, "PropertyNameDialog", true);
        PropertyDescriptor[] allProperties;
        new WindowCloser(this);
        this.setLayout(null);
        try {
            allProperties = Introspector.getBeanInfo(source.getClass()).getPropertyDescriptors();
            if (allProperties == null) {
                new ErrorDialog(frame, "PropertyNameDialog : couldn't find PropertyDescriptors");
                return;
            }
        }
        catch (Exception ex) {
            new ErrorDialog(frame, "PropertyNameDialog: Unexpected exception: \n" + ex);
            return;
        }
        this.properties = new Vector();
        for (int i = 0; i < allProperties.length; ++i) {
            PropertyDescriptor pd = allProperties[i];
            if (readable && !pd.isBound() || readable && pd.getReadMethod() == null || !readable && pd.getWriteMethod() == null || match != null && !PropertyNameDialog.isSubclass(match, pd.getPropertyType())) continue;
            this.properties.addElement(pd);
        }
        int width = 300;
        if (this.properties.isEmpty()) {
            new ErrorDialog(frame, "No suitable properties");
            return;
        }
        int height = 200;
        Label l = new Label(message, 1);
        l.setBounds(2, 30, width - 4, 25);
        this.add(l);
        this.list = new List(8, false);
        for (int i = 0; i < this.properties.size(); ++i) {
            PropertyDescriptor pd = (PropertyDescriptor)this.properties.elementAt(i);
            this.list.add(pd.getDisplayName());
        }
        this.list.select(0);
        this.list.setBounds(10, 60, width - 20, height - 60);
        this.add(this.list);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.add(this.cancelButton);
        this.cancelButton.setBounds(width / 2 - 70, (height += 10) - 5, 60, 30);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.add(this.okButton);
        this.okButton.setBounds(width / 2 + 10, height - 5, 60, 30);
        this.list.setBounds(10, 60, width - 20, (height += 55) - 130);
        int x = frame.getLocation().x + 30;
        int y = frame.getLocation().y + 50;
        this.setBounds(x, y, width, height);
        this.show();
    }

    static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        for (Class x = a; x != null; x = x.getSuperclass()) {
            if (x == b) {
                return true;
            }
            if (!b.isInterface()) continue;
            Class<?>[] interfaces = x.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (interfaces[i] != b) continue;
                return true;
            }
        }
        return false;
    }

    public PropertyDescriptor getResult() {
        return this.result;
    }

    public void actionPerformed(ActionEvent evt) {
        int index;
        if (evt.getSource() == this.okButton && this.list != null && (index = this.list.getSelectedIndex()) >= 0) {
            this.result = (PropertyDescriptor)this.properties.elementAt(index);
        }
        this.dispose();
    }
}

