/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.joone.edit.EditorParameters;
import org.joone.edit.PropertySheet;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NetChecker;
import org.joone.net.NeuralNet;

public class ControlPanel
extends JPanel
implements NeuralNetListener {
    private Monitor monitor;
    private NeuralNet nNet;
    private PropertySheet parent;
    private NetChecker netChecker;
    private boolean printCycle = false;
    private JButton continueButton;
    private JLabel cicleLabel;
    private JButton stopButton;
    private JPanel jPanel2;
    private JLabel cicleValue;
    private JButton runButton;
    private JLabel rmsLabel;
    private JPanel jPanel1;
    private JLabel rmsValue;
    private static final long serialVersionUID = 1310288899683080017L;
    private EditorParameters parameters;

    public ControlPanel(NeuralNet nn, PropertySheet ps) {
        this.setMonitor(nn.getMonitor());
        this.parent = ps;
        this.nNet = nn;
        this.netChecker = new NetChecker(this.nNet);
        this.initComponents();
    }

    public void setMonitor(Monitor m) {
        this.monitor = m;
        this.monitor.addNeuralNetListener((NeuralNetListener)this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.runButton = new JButton();
        this.continueButton = new JButton();
        this.stopButton = new JButton();
        this.jPanel2 = new JPanel();
        this.cicleLabel = new JLabel();
        this.cicleValue = new JLabel();
        this.rmsLabel = new JLabel();
        this.rmsValue = new JLabel();
        this.setLayout(new GridLayout(2, 1, 0, 10));
        this.setBorder(new TitledBorder("Controls"));
        this.jPanel1.setLayout(new GridLayout(1, 3));
        this.runButton.setForeground(Color.green);
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.runButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.runButton);
        this.continueButton.setForeground(new Color(0, 51, 255));
        this.continueButton.setText("Continue");
        this.continueButton.setEnabled(false);
        this.continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.continueButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.continueButton);
        this.stopButton.setForeground(Color.red);
        this.stopButton.setText("Pause");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ControlPanel.this.stopButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.stopButton);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new GridLayout(2, 2, 0, 8));
        this.cicleLabel.setHorizontalAlignment(4);
        this.cicleLabel.setText("Epochs :  ");
        this.cicleLabel.setHorizontalTextPosition(4);
        this.jPanel2.add(this.cicleLabel);
        this.cicleValue.setHorizontalAlignment(2);
        this.cicleValue.setText("0");
        this.jPanel2.add(this.cicleValue);
        this.rmsLabel.setHorizontalAlignment(4);
        this.rmsLabel.setText("RMSE :  ");
        this.jPanel2.add(this.rmsLabel);
        this.rmsValue.setHorizontalAlignment(2);
        this.rmsValue.setText("0.0");
        this.jPanel2.add(this.rmsValue);
        this.add(this.jPanel2);
    }

    private void continueButtonActionPerformed(ActionEvent evt) {
        if (this.netChecker.hasErrors()) {
            this.displayNogo("Network could not be run.", "See 'To Do List' to check all the errors.");
        } else {
            this.setLearners();
            this.nNet.restore();
            this.setState(false);
        }
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.nNet.stop();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        if (this.netChecker.hasErrors()) {
            this.displayNogo("Network could not be run.", "See 'To Do List' to check all the errors.");
        } else {
            this.setLearners();
            this.nNet.go();
        }
    }

    public void netStopped(NeuralNetEvent e) {
        this.setState(true);
        this.printCycle = true;
        this.parent.update();
    }

    public void cicleTerminated(NeuralNetEvent e) {
        int currentCycle = this.monitor.getTotCicles() - this.monitor.getCurrentCicle() + 1;
        int cl = currentCycle / this.parameters.getRefreshingRate();
        if (cl * this.parameters.getRefreshingRate() == currentCycle || this.monitor.getCurrentCicle() == 1) {
            this.cicleValue.setText(Integer.toString(currentCycle));
            this.printCycle = true;
        }
    }

    public void setParameters(EditorParameters parameters) {
        this.parameters = parameters;
    }

    private void setState(boolean state) {
        this.runButton.setEnabled(state);
        this.continueButton.setEnabled(state);
        this.stopButton.setEnabled(!state);
        this.parent.setControlsEnabled(state);
    }

    public void netStarted(NeuralNetEvent e) {
        this.setState(false);
    }

    public void errorChanged(NeuralNetEvent e) {
        if (this.printCycle || this.monitor.getTotCicles() < this.parameters.getRefreshingRate()) {
            this.rmsValue.setText(Double.toString(this.monitor.getGlobalError()));
            this.printCycle = false;
        }
    }

    private void displayNogo(String message1, String message2) {
        final JDialog dialog = new JDialog(this.parent, "Critical Network Error", true);
        dialog.getContentPane().setLayout(new BorderLayout(10, 10));
        Button ok = new Button("  OK  ");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        Panel p = new Panel();
        p.setLayout(new FlowLayout(1));
        p.add(ok);
        dialog.getContentPane().add((Component)p, "South");
        JLabel label = new JLabel(message1);
        label.setHorizontalAlignment(0);
        dialog.getContentPane().add((Component)label, "North");
        label = new JLabel(message2);
        label.setHorizontalAlignment(0);
        dialog.getContentPane().add((Component)label, "Center");
        dialog.pack();
        Point center = new Point(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
        dialog.setLocation((int)(center.getX() - (double)(dialog.getWidth() / 2)), (int)(center.getY() - (double)(dialog.getHeight() / 2)));
        dialog.setVisible(true);
    }

    public void netStoppedError(NeuralNetEvent e, String error) {
        this.setState(true);
        this.printCycle = true;
        this.parent.update();
        this.displayNogo("Runtime Error!", error);
    }

    public void setLearners() {
        this.monitor.addLearner(0, "org.joone.engine.BasicLearner");
        this.monitor.addLearner(1, "org.joone.engine.BatchLearner");
        this.monitor.addLearner(2, "org.joone.engine.RpropLearner");
    }
}

