/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics.constraintsolver;

import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class TranslationalLimitMotor {
    public final Vector3f lowerLimit = new Vector3f();
    public final Vector3f upperLimit = new Vector3f();
    public final Vector3f accumulatedImpulse = new Vector3f();
    public float limitSoftness;
    public float damping;
    public float restitution;
    private static final Vector3f $stackTemp0 = new Vector3f();
    private static final Vector3f $stackTemp1 = new Vector3f();
    private static final Vector3f $stackTemp2 = new Vector3f();
    private static final Vector3f $stackTemp3 = new Vector3f();
    private static final Vector3f $stackTemp4 = new Vector3f();
    private static final Vector3f $stackTemp5 = new Vector3f();
    private static final Vector3f $stackTemp6 = new Vector3f();
    private static final Vector3f $stackTemp7 = new Vector3f();

    public TranslationalLimitMotor() {
        this.lowerLimit.set(0.0f, 0.0f, 0.0f);
        this.upperLimit.set(0.0f, 0.0f, 0.0f);
        this.accumulatedImpulse.set(0.0f, 0.0f, 0.0f);
        this.limitSoftness = 0.7f;
        this.damping = 1.0f;
        this.restitution = 0.5f;
    }

    public TranslationalLimitMotor(TranslationalLimitMotor other) {
        this.lowerLimit.set((Tuple3f)other.lowerLimit);
        this.upperLimit.set((Tuple3f)other.upperLimit);
        this.accumulatedImpulse.set((Tuple3f)other.accumulatedImpulse);
        this.limitSoftness = other.limitSoftness;
        this.damping = other.damping;
        this.restitution = other.restitution;
    }

    public boolean isLimited(int limitIndex) {
        return VectorUtil.getCoord(this.upperLimit, limitIndex) >= VectorUtil.getCoord(this.lowerLimit, limitIndex);
    }

    public float solveLinearAxis(float timeStep, float jacDiagABInv, RigidBody body1, Vector3f pointInA, RigidBody body2, Vector3f pointInB, int limit_index, Vector3f axis_normal_on_a, Vector3f anchorPos) {
        Vector3f tmp = $stackTemp0;
        Vector3f tmpVec = $stackTemp1;
        Vector3f rel_pos1 = $stackTemp2;
        rel_pos1.sub((Tuple3f)anchorPos, (Tuple3f)body1.getCenterOfMassPosition(tmpVec));
        Vector3f rel_pos2 = $stackTemp3;
        rel_pos2.sub((Tuple3f)anchorPos, (Tuple3f)body2.getCenterOfMassPosition(tmpVec));
        Vector3f vel1 = body1.getVelocityInLocalPoint(rel_pos1, $stackTemp4);
        Vector3f vel2 = body2.getVelocityInLocalPoint(rel_pos2, $stackTemp5);
        Vector3f vel = $stackTemp6;
        vel.sub((Tuple3f)vel1, (Tuple3f)vel2);
        float rel_vel = axis_normal_on_a.dot(vel);
        tmp.sub((Tuple3f)pointInA, (Tuple3f)pointInB);
        float depth = -tmp.dot(axis_normal_on_a);
        float lo = -1.0E30f;
        float hi = 1.0E30f;
        float minLimit = VectorUtil.getCoord(this.lowerLimit, limit_index);
        float maxLimit = VectorUtil.getCoord(this.upperLimit, limit_index);
        if (minLimit < maxLimit) {
            if (depth > maxLimit) {
                depth -= maxLimit;
                lo = 0.0f;
            } else if (depth < minLimit) {
                depth -= minLimit;
                hi = 0.0f;
            } else {
                return 0.0f;
            }
        }
        float normalImpulse = this.limitSoftness * (this.restitution * depth / timeStep - this.damping * rel_vel) * jacDiagABInv;
        float oldNormalImpulse = VectorUtil.getCoord(this.accumulatedImpulse, limit_index);
        float sum = oldNormalImpulse + normalImpulse;
        VectorUtil.setCoord(this.accumulatedImpulse, limit_index, sum > hi ? 0.0f : (sum < lo ? 0.0f : sum));
        normalImpulse = VectorUtil.getCoord(this.accumulatedImpulse, limit_index) - oldNormalImpulse;
        Vector3f impulse_vector = $stackTemp7;
        impulse_vector.scale(normalImpulse, (Tuple3f)axis_normal_on_a);
        body1.applyImpulse(impulse_vector, rel_pos1);
        tmp.negate((Tuple3f)impulse_vector);
        body2.applyImpulse(tmp, rel_pos2);
        return normalImpulse;
    }
}

