/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.dynamics;

import com.bulletphysics.$Stack;
import com.bulletphysics.BulletGlobals;
import com.bulletphysics.BulletStats;
import com.bulletphysics.collision.broadphase.BroadphaseInterface;
import com.bulletphysics.collision.broadphase.Dispatcher;
import com.bulletphysics.collision.broadphase.DispatcherInfo;
import com.bulletphysics.collision.dispatch.CollisionConfiguration;
import com.bulletphysics.collision.dispatch.CollisionObject;
import com.bulletphysics.collision.dispatch.CollisionWorld;
import com.bulletphysics.collision.dispatch.SimulationIslandManager;
import com.bulletphysics.collision.narrowphase.ManifoldPoint;
import com.bulletphysics.collision.narrowphase.PersistentManifold;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.InternalTriangleIndexCallback;
import com.bulletphysics.collision.shapes.TriangleCallback;
import com.bulletphysics.dynamics.DynamicsWorld;
import com.bulletphysics.dynamics.DynamicsWorldType;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.constraintsolver.ConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.ContactSolverInfo;
import com.bulletphysics.dynamics.constraintsolver.SequentialImpulseConstraintSolver;
import com.bulletphysics.dynamics.constraintsolver.TypedConstraint;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.linearmath.CProfileManager;
import com.bulletphysics.linearmath.IDebugDraw;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.ScalarUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.TransformUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class DiscreteDynamicsWorld
extends DynamicsWorld {
    protected ConstraintSolver constraintSolver;
    protected SimulationIslandManager islandManager;
    protected final List<TypedConstraint> constraints = new ArrayList<TypedConstraint>();
    protected final Vector3f gravity = new Vector3f(0.0f, -10.0f, 0.0f);
    protected float localTime = 0.016666668f;
    protected boolean ownsIslandManager;
    protected boolean ownsConstraintSolver;
    protected List<RaycastVehicle> vehicles = new ArrayList<RaycastVehicle>();
    protected int profileTimings = 0;
    private List<TypedConstraint> sortedConstraints = new ArrayList<TypedConstraint>();
    private InplaceSolverIslandCallback solverCallback = new InplaceSolverIslandCallback();
    private static final Comparator<TypedConstraint> sortConstraintOnIslandPredicate = new Comparator<TypedConstraint>(){

        @Override
        public int compare(TypedConstraint lhs, TypedConstraint rhs) {
            int rIslandId0 = DiscreteDynamicsWorld.getConstraintIslandId(rhs);
            int lIslandId0 = DiscreteDynamicsWorld.getConstraintIslandId(lhs);
            return lIslandId0 < rIslandId0 ? -1 : 1;
        }
    };

    public DiscreteDynamicsWorld(Dispatcher dispatcher, BroadphaseInterface pairCache, ConstraintSolver constraintSolver, CollisionConfiguration collisionConfiguration) {
        super(dispatcher, pairCache, collisionConfiguration);
        this.constraintSolver = constraintSolver;
        if (this.constraintSolver == null) {
            this.constraintSolver = new SequentialImpulseConstraintSolver();
            this.ownsConstraintSolver = true;
        } else {
            this.ownsConstraintSolver = false;
        }
        this.islandManager = new SimulationIslandManager();
        this.ownsIslandManager = true;
    }

    protected void saveKinematicState(float timeStep) {
        for (int i = 0; i < this.collisionObjects.size(); ++i) {
            CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
            RigidBody body = RigidBody.upcast(colObj);
            if (body == null || body.getActivationState() == 2 || !body.isKinematicObject()) continue;
            body.saveKinematicState(timeStep);
        }
    }

    public void debugDrawWorld() {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            $Stack $Stack2 = $Stack;
            $Stack2.push$com$bulletphysics$linearmath$Transform();
            $Stack2.push$javax$vecmath$Vector3f();
            if (this.getDebugDrawer() != null && (this.getDebugDrawer().getDebugMode() & 8) != 0) {
                int numManifolds = this.getDispatcher().getNumManifolds();
                Vector3f color = $Stack.get$javax$vecmath$Vector3f();
                color.set(0.0f, 0.0f, 0.0f);
                for (int i = 0; i < numManifolds; ++i) {
                    PersistentManifold contactManifold = this.getDispatcher().getManifoldByIndexInternal(i);
                    int numContacts = contactManifold.getNumContacts();
                    for (int j = 0; j < numContacts; ++j) {
                        ManifoldPoint cp = contactManifold.getContactPoint(j);
                        this.getDebugDrawer().drawContactPoint(cp.positionWorldOnB, cp.normalWorldOnB, cp.getDistance(), cp.getLifeTime(), color);
                    }
                }
            }
            if (this.getDebugDrawer() != null && (this.getDebugDrawer().getDebugMode() & 3) != 0) {
                int i;
                Transform tmpTrans = $Stack.get$com$bulletphysics$linearmath$Transform();
                Vector3f minAabb = $Stack.get$javax$vecmath$Vector3f();
                Vector3f maxAabb = $Stack.get$javax$vecmath$Vector3f();
                Vector3f colorvec = $Stack.get$javax$vecmath$Vector3f();
                for (i = 0; i < this.collisionObjects.size(); ++i) {
                    CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
                    if (this.getDebugDrawer() != null && (this.getDebugDrawer().getDebugMode() & 1) != 0) {
                        Vector3f color = $Stack.get$javax$vecmath$Vector3f();
                        color.set(255.0f, 255.0f, 255.0f);
                        switch (colObj.getActivationState()) {
                            case 1: {
                                color.set(255.0f, 255.0f, 255.0f);
                                break;
                            }
                            case 2: {
                                color.set(0.0f, 255.0f, 0.0f);
                                break;
                            }
                            case 3: {
                                color.set(0.0f, 255.0f, 255.0f);
                                break;
                            }
                            case 4: {
                                color.set(255.0f, 0.0f, 0.0f);
                                break;
                            }
                            case 5: {
                                color.set(255.0f, 255.0f, 0.0f);
                                break;
                            }
                            default: {
                                color.set(255.0f, 0.0f, 0.0f);
                            }
                        }
                        this.debugDrawObject(colObj.getWorldTransform(tmpTrans), colObj.getCollisionShape(), color);
                    }
                    if (this.debugDrawer == null || (this.debugDrawer.getDebugMode() & 2) == 0) continue;
                    colorvec.set(1.0f, 0.0f, 0.0f);
                    colObj.getCollisionShape().getAabb(colObj.getWorldTransform(tmpTrans), minAabb, maxAabb);
                    this.debugDrawer.drawAabb(minAabb, maxAabb, colorvec);
                }
                Vector3f wheelColor = $Stack.get$javax$vecmath$Vector3f();
                Vector3f wheelPosWS = $Stack.get$javax$vecmath$Vector3f();
                Vector3f axle = $Stack.get$javax$vecmath$Vector3f();
                Vector3f tmp = $Stack.get$javax$vecmath$Vector3f();
                for (i = 0; i < this.vehicles.size(); ++i) {
                    for (int v = 0; v < this.vehicles.get(i).getNumWheels(); ++v) {
                        wheelColor.set(0.0f, 255.0f, 255.0f);
                        if (this.vehicles.get((int)i).getWheelInfo((int)v).raycastInfo.isInContact) {
                            wheelColor.set(0.0f, 0.0f, 255.0f);
                        } else {
                            wheelColor.set(255.0f, 0.0f, 255.0f);
                        }
                        wheelPosWS.set((Tuple3f)this.vehicles.get((int)i).getWheelInfo((int)v).worldTransform.origin);
                        axle.set(this.vehicles.get((int)i).getWheelInfo((int)v).worldTransform.basis.getElement(0, this.vehicles.get(i).getRightAxis()), this.vehicles.get((int)i).getWheelInfo((int)v).worldTransform.basis.getElement(1, this.vehicles.get(i).getRightAxis()), this.vehicles.get((int)i).getWheelInfo((int)v).worldTransform.basis.getElement(2, this.vehicles.get(i).getRightAxis()));
                        tmp.add((Tuple3f)wheelPosWS, (Tuple3f)axle);
                        this.debugDrawer.drawLine(wheelPosWS, tmp, wheelColor);
                        this.debugDrawer.drawLine(wheelPosWS, this.vehicles.get((int)i).getWheelInfo((int)v).raycastInfo.contactPointWS, wheelColor);
                    }
                }
            }
            $Stack $Stack3 = $Stack;
            $Stack3.pop$com$bulletphysics$linearmath$Transform();
            $Stack3.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack $Stack4 = $Stack;
            $Stack4.pop$com$bulletphysics$linearmath$Transform();
            $Stack4.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    public void clearForces() {
        for (int i = 0; i < this.collisionObjects.size(); ++i) {
            CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
            RigidBody body = RigidBody.upcast(colObj);
            if (body == null) continue;
            body.clearForces();
        }
    }

    public void applyGravity() {
        for (int i = 0; i < this.collisionObjects.size(); ++i) {
            CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
            RigidBody body = RigidBody.upcast(colObj);
            if (body == null || !body.isActive()) continue;
            body.applyGravity();
        }
    }

    protected void synchronizeMotionStates() {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            int i;
            $Stack $Stack2 = $Stack;
            $Stack2.push$com$bulletphysics$linearmath$Transform();
            $Stack2.push$javax$vecmath$Vector3f();
            Transform interpolatedTransform = $Stack.get$com$bulletphysics$linearmath$Transform();
            Transform tmpTrans = $Stack.get$com$bulletphysics$linearmath$Transform();
            Vector3f tmpLinVel = $Stack.get$javax$vecmath$Vector3f();
            Vector3f tmpAngVel = $Stack.get$javax$vecmath$Vector3f();
            for (i = 0; i < this.collisionObjects.size(); ++i) {
                CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
                RigidBody body = RigidBody.upcast(colObj);
                if (body == null || body.getMotionState() == null || body.isStaticOrKinematicObject()) continue;
                TransformUtil.integrateTransform(body.getInterpolationWorldTransform(tmpTrans), body.getInterpolationLinearVelocity(tmpLinVel), body.getInterpolationAngularVelocity(tmpAngVel), this.localTime, interpolatedTransform);
                body.getMotionState().setWorldTransform(interpolatedTransform);
            }
            if (this.getDebugDrawer() != null && (this.getDebugDrawer().getDebugMode() & 1) != 0) {
                for (i = 0; i < this.vehicles.size(); ++i) {
                    for (int v = 0; v < this.vehicles.get(i).getNumWheels(); ++v) {
                        this.vehicles.get(i).updateWheelTransform(v, true);
                    }
                }
            }
            $Stack $Stack3 = $Stack;
            $Stack3.pop$com$bulletphysics$linearmath$Transform();
            $Stack3.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack $Stack4 = $Stack;
            $Stack4.pop$com$bulletphysics$linearmath$Transform();
            $Stack4.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stepSimulation(float timeStep, int maxSubSteps, float fixedTimeStep) {
        this.startProfiling(timeStep);
        long t0 = System.nanoTime();
        BulletStats.pushProfile("stepSimulation");
        try {
            int numSimulationSubSteps = 0;
            if (maxSubSteps != 0) {
                this.localTime += timeStep;
                if (this.localTime >= fixedTimeStep) {
                    numSimulationSubSteps = (int)(this.localTime / fixedTimeStep);
                    this.localTime -= (float)numSimulationSubSteps * fixedTimeStep;
                }
            } else {
                fixedTimeStep = timeStep;
                this.localTime = timeStep;
                if (ScalarUtil.fuzzyZero(timeStep)) {
                    numSimulationSubSteps = 0;
                    maxSubSteps = 0;
                } else {
                    numSimulationSubSteps = 1;
                    maxSubSteps = 1;
                }
            }
            if (this.getDebugDrawer() != null) {
                BulletGlobals.setDeactivationDisabled((this.getDebugDrawer().getDebugMode() & 0x10) != 0);
            }
            if (numSimulationSubSteps != 0) {
                this.saveKinematicState(fixedTimeStep);
                this.applyGravity();
                int clampedSimulationSteps = numSimulationSubSteps > maxSubSteps ? maxSubSteps : numSimulationSubSteps;
                for (int i = 0; i < clampedSimulationSteps; ++i) {
                    this.internalSingleStepSimulation(fixedTimeStep);
                    this.synchronizeMotionStates();
                }
            }
            this.synchronizeMotionStates();
            this.clearForces();
            CProfileManager.incrementFrameCounter();
            int n = numSimulationSubSteps;
            return n;
        }
        finally {
            BulletStats.popProfile();
            BulletStats.stepSimulationTime = (System.nanoTime() - t0) / 1000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalSingleStepSimulation(float timeStep) {
        BulletStats.pushProfile("internalSingleStepSimulation");
        try {
            this.predictUnconstraintMotion(timeStep);
            DispatcherInfo dispatchInfo = this.getDispatchInfo();
            dispatchInfo.timeStep = timeStep;
            dispatchInfo.stepCount = 0;
            dispatchInfo.debugDraw = this.getDebugDrawer();
            this.performDiscreteCollisionDetection();
            this.calculateSimulationIslands();
            this.getSolverInfo().timeStep = timeStep;
            this.solveConstraints(this.getSolverInfo());
            this.integrateTransforms(timeStep);
            this.updateVehicles(timeStep);
            this.updateActivationState(timeStep);
            if (this.internalTickCallback != null) {
                this.internalTickCallback.internalTick(this, timeStep);
            }
        }
        finally {
            BulletStats.popProfile();
        }
    }

    public void setGravity(Vector3f gravity) {
        this.gravity.set((Tuple3f)gravity);
        for (int i = 0; i < this.collisionObjects.size(); ++i) {
            CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
            RigidBody body = RigidBody.upcast(colObj);
            if (body == null) continue;
            body.setGravity(gravity);
        }
    }

    public Vector3f getGravity(Vector3f out) {
        out.set((Tuple3f)this.gravity);
        return out;
    }

    public void removeRigidBody(RigidBody body) {
        this.removeCollisionObject(body);
    }

    public void addRigidBody(RigidBody body) {
        if (!body.isStaticOrKinematicObject()) {
            body.setGravity(this.gravity);
        }
        if (body.getCollisionShape() != null) {
            boolean isDynamic = !body.isStaticObject() && !body.isKinematicObject();
            short collisionFilterGroup = isDynamic ? (short)1 : 2;
            short collisionFilterMask = isDynamic ? (short)-1 : -3;
            this.addCollisionObject(body, collisionFilterGroup, collisionFilterMask);
        }
    }

    public void addRigidBody(RigidBody body, short group, short mask) {
        if (!body.isStaticOrKinematicObject()) {
            body.setGravity(this.gravity);
        }
        if (body.getCollisionShape() != null) {
            this.addCollisionObject(body, group, mask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateVehicles(float timeStep) {
        BulletStats.pushProfile("updateVehicles");
        try {
            for (int i = 0; i < this.vehicles.size(); ++i) {
                RaycastVehicle vehicle = this.vehicles.get(i);
                vehicle.updateVehicle(timeStep);
            }
        }
        finally {
            BulletStats.popProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateActivationState(float timeStep) {
        BulletStats.pushProfile("updateActivationState");
        try {
            for (int i = 0; i < this.collisionObjects.size(); ++i) {
                CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
                RigidBody body = RigidBody.upcast(colObj);
                if (body == null) continue;
                body.updateDeactivation(timeStep);
                if (body.wantsSleeping()) {
                    if (body.isStaticOrKinematicObject()) {
                        body.setActivationState(2);
                        continue;
                    }
                    if (body.getActivationState() != 1) continue;
                    body.setActivationState(3);
                    continue;
                }
                if (body.getActivationState() == 4) continue;
                body.setActivationState(1);
            }
        }
        finally {
            BulletStats.popProfile();
        }
    }

    public void addConstraint(TypedConstraint constraint, boolean disableCollisionsBetweenLinkedBodies) {
        this.constraints.add(constraint);
        if (disableCollisionsBetweenLinkedBodies) {
            constraint.getRigidBodyA().addConstraintRef(constraint);
            constraint.getRigidBodyB().addConstraintRef(constraint);
        }
    }

    public void removeConstraint(TypedConstraint constraint) {
        this.constraints.remove(constraint);
        constraint.getRigidBodyA().removeConstraintRef(constraint);
        constraint.getRigidBodyB().removeConstraintRef(constraint);
    }

    public void addVehicle(RaycastVehicle vehicle) {
        this.vehicles.add(vehicle);
    }

    public void removeVehicle(RaycastVehicle vehicle) {
        this.vehicles.remove(vehicle);
    }

    private static int getConstraintIslandId(TypedConstraint lhs) {
        RigidBody rcolObj0 = lhs.getRigidBodyA();
        RigidBody rcolObj1 = lhs.getRigidBodyB();
        int islandId = rcolObj0.getIslandTag() >= 0 ? rcolObj0.getIslandTag() : rcolObj1.getIslandTag();
        return islandId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void solveConstraints(ContactSolverInfo solverInfo) {
        BulletStats.pushProfile("solveConstraints");
        try {
            this.sortedConstraints.clear();
            for (int i = 0; i < this.constraints.size(); ++i) {
                this.sortedConstraints.add(this.constraints.get(i));
            }
            MiscUtil.quickSort(this.sortedConstraints, sortConstraintOnIslandPredicate);
            List<TypedConstraint> constraintsPtr = this.getNumConstraints() != 0 ? this.sortedConstraints : null;
            this.solverCallback.init(solverInfo, this.constraintSolver, constraintsPtr, this.sortedConstraints.size(), this.debugDrawer, this.dispatcher1);
            this.constraintSolver.prepareSolve(this.getCollisionWorld().getNumCollisionObjects(), this.getCollisionWorld().getDispatcher().getNumManifolds());
            this.islandManager.buildAndProcessIslands(this.getCollisionWorld().getDispatcher(), this.getCollisionWorld().getCollisionObjectArray(), this.solverCallback);
            this.constraintSolver.allSolved(solverInfo, this.debugDrawer);
        }
        finally {
            BulletStats.popProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateSimulationIslands() {
        BulletStats.pushProfile("calculateSimulationIslands");
        try {
            this.getSimulationIslandManager().updateActivationState(this.getCollisionWorld(), this.getCollisionWorld().getDispatcher());
            int numConstraints = this.constraints.size();
            for (int i = 0; i < numConstraints; ++i) {
                TypedConstraint constraint = this.constraints.get(i);
                RigidBody colObj0 = constraint.getRigidBodyA();
                RigidBody colObj1 = constraint.getRigidBodyB();
                if (colObj0 == null || !colObj0.mergesSimulationIslands() || colObj1 == null || !colObj1.mergesSimulationIslands() || !colObj0.isActive() && !colObj1.isActive()) continue;
                this.getSimulationIslandManager().getUnionFind().unite(colObj0.getIslandTag(), colObj1.getIslandTag());
            }
            this.getSimulationIslandManager().storeIslandActivationState(this.getCollisionWorld());
        }
        finally {
            BulletStats.popProfile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void integrateTransforms(float f) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            $Stack.push$com$bulletphysics$linearmath$Transform();
            BulletStats.pushProfile("integrateTransforms");
            try {
                Transform predictedTrans = $Stack.get$com$bulletphysics$linearmath$Transform();
                for (int i = 0; i < this.collisionObjects.size(); ++i) {
                    void timeStep;
                    CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
                    RigidBody body = RigidBody.upcast(colObj);
                    if (body == null || !body.isActive() || body.isStaticOrKinematicObject()) continue;
                    body.predictIntegratedTransform((float)timeStep, predictedTrans);
                    body.proceedToTransform(predictedTrans);
                }
            }
            finally {
                BulletStats.popProfile();
            }
            $Stack.pop$com$bulletphysics$linearmath$Transform();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$com$bulletphysics$linearmath$Transform();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void predictUnconstraintMotion(float f) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            $Stack.push$com$bulletphysics$linearmath$Transform();
            BulletStats.pushProfile("predictUnconstraintMotion");
            try {
                Transform tmpTrans = $Stack.get$com$bulletphysics$linearmath$Transform();
                for (int i = 0; i < this.collisionObjects.size(); ++i) {
                    void timeStep;
                    CollisionObject colObj = (CollisionObject)this.collisionObjects.get(i);
                    RigidBody body = RigidBody.upcast(colObj);
                    if (body == null || body.isStaticOrKinematicObject() || !body.isActive()) continue;
                    body.integrateVelocities((float)timeStep);
                    body.applyDamping((float)timeStep);
                    body.predictIntegratedTransform((float)timeStep, body.getInterpolationWorldTransform(tmpTrans));
                }
            }
            finally {
                BulletStats.popProfile();
            }
            $Stack.pop$com$bulletphysics$linearmath$Transform();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$com$bulletphysics$linearmath$Transform();
            throw throwable;
        }
    }

    protected void startProfiling(float timeStep) {
        CProfileManager.reset();
    }

    /*
     * WARNING - void declaration
     */
    protected void debugDrawSphere(float f, Transform transform, Vector3f vector3f) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            void color;
            void radius;
            void transform2;
            $Stack.push$javax$vecmath$Vector3f();
            Vector3f start = $Stack.get$javax$vecmath$Vector3f(transform2.origin);
            Vector3f xoffs = $Stack.get$javax$vecmath$Vector3f();
            xoffs.set((float)radius, 0.0f, 0.0f);
            transform2.basis.transform((Tuple3f)xoffs);
            Vector3f yoffs = $Stack.get$javax$vecmath$Vector3f();
            yoffs.set(0.0f, (float)radius, 0.0f);
            transform2.basis.transform((Tuple3f)yoffs);
            Vector3f zoffs = $Stack.get$javax$vecmath$Vector3f();
            zoffs.set(0.0f, 0.0f, (float)radius);
            transform2.basis.transform((Tuple3f)zoffs);
            Vector3f tmp1 = $Stack.get$javax$vecmath$Vector3f();
            Vector3f tmp2 = $Stack.get$javax$vecmath$Vector3f();
            tmp1.sub((Tuple3f)start, (Tuple3f)xoffs);
            tmp2.add((Tuple3f)start, (Tuple3f)yoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.add((Tuple3f)start, (Tuple3f)yoffs);
            tmp2.add((Tuple3f)start, (Tuple3f)xoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.add((Tuple3f)start, (Tuple3f)xoffs);
            tmp2.sub((Tuple3f)start, (Tuple3f)yoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.sub((Tuple3f)start, (Tuple3f)yoffs);
            tmp2.sub((Tuple3f)start, (Tuple3f)xoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.sub((Tuple3f)start, (Tuple3f)xoffs);
            tmp2.add((Tuple3f)start, (Tuple3f)zoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.add((Tuple3f)start, (Tuple3f)zoffs);
            tmp2.add((Tuple3f)start, (Tuple3f)xoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.add((Tuple3f)start, (Tuple3f)xoffs);
            tmp2.sub((Tuple3f)start, (Tuple3f)zoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.sub((Tuple3f)start, (Tuple3f)zoffs);
            tmp2.sub((Tuple3f)start, (Tuple3f)xoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.sub((Tuple3f)start, (Tuple3f)yoffs);
            tmp2.add((Tuple3f)start, (Tuple3f)zoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.add((Tuple3f)start, (Tuple3f)zoffs);
            tmp2.add((Tuple3f)start, (Tuple3f)yoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.add((Tuple3f)start, (Tuple3f)yoffs);
            tmp2.sub((Tuple3f)start, (Tuple3f)zoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            tmp1.sub((Tuple3f)start, (Tuple3f)zoffs);
            tmp2.sub((Tuple3f)start, (Tuple3f)yoffs);
            this.getDebugDrawer().drawLine(tmp1, tmp2, (Vector3f)color);
            $Stack.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void debugDrawObject(Transform transform, CollisionShape collisionShape, Vector3f vector3f) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            void worldTransform;
            $Stack.push$javax$vecmath$Vector3f();
            Vector3f tmp = $Stack.get$javax$vecmath$Vector3f();
            Vector3f tmp2 = $Stack.get$javax$vecmath$Vector3f();
            Vector3f start = $Stack.get$javax$vecmath$Vector3f(worldTransform.origin);
            tmp.set(1.0f, 0.0f, 0.0f);
            worldTransform.basis.transform((Tuple3f)tmp);
            tmp.add((Tuple3f)start);
            tmp2.set(1.0f, 0.0f, 0.0f);
            this.getDebugDrawer().drawLine(start, tmp, tmp2);
            tmp.set(0.0f, 1.0f, 0.0f);
            worldTransform.basis.transform((Tuple3f)tmp);
            tmp.add((Tuple3f)start);
            tmp2.set(0.0f, 1.0f, 0.0f);
            this.getDebugDrawer().drawLine(start, tmp, tmp2);
            tmp.set(0.0f, 0.0f, 1.0f);
            worldTransform.basis.transform((Tuple3f)tmp);
            tmp.add((Tuple3f)start);
            tmp2.set(0.0f, 0.0f, 1.0f);
            this.getDebugDrawer().drawLine(start, tmp, tmp2);
            $Stack.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    public void setConstraintSolver(ConstraintSolver solver) {
        if (this.ownsConstraintSolver) {
            // empty if block
        }
        this.ownsConstraintSolver = false;
        this.constraintSolver = solver;
    }

    public ConstraintSolver getConstraintSolver() {
        return this.constraintSolver;
    }

    public int getNumConstraints() {
        return this.constraints.size();
    }

    public TypedConstraint getConstraint(int index) {
        return this.constraints.get(index);
    }

    public SimulationIslandManager getSimulationIslandManager() {
        return this.islandManager;
    }

    public CollisionWorld getCollisionWorld() {
        return this;
    }

    public DynamicsWorldType getWorldType() {
        return DynamicsWorldType.DISCRETE_DYNAMICS_WORLD;
    }

    private static class DebugDrawcallback
    implements TriangleCallback,
    InternalTriangleIndexCallback {
        private IDebugDraw debugDrawer;
        private final Vector3f color = new Vector3f();
        private final Transform worldTrans = new Transform();
        private final Vector3f wv0 = new Vector3f();
        private final Vector3f wv1 = new Vector3f();
        private final Vector3f wv2 = new Vector3f();

        public DebugDrawcallback(IDebugDraw debugDrawer, Transform worldTrans, Vector3f color) {
            this.debugDrawer = debugDrawer;
            this.worldTrans.set(worldTrans);
            this.color.set((Tuple3f)color);
        }

        public void internalProcessTriangleIndex(Vector3f[] triangle, int partId, int triangleIndex) {
            this.processTriangle(triangle, partId, triangleIndex);
        }

        public void processTriangle(Vector3f[] triangle, int partId, int triangleIndex) {
            this.wv0.set((Tuple3f)triangle[0]);
            this.worldTrans.transform(this.wv0);
            this.wv1.set((Tuple3f)triangle[1]);
            this.worldTrans.transform(this.wv1);
            this.wv2.set((Tuple3f)triangle[2]);
            this.worldTrans.transform(this.wv2);
            this.debugDrawer.drawLine(this.wv0, this.wv1, this.color);
            this.debugDrawer.drawLine(this.wv1, this.wv2, this.color);
            this.debugDrawer.drawLine(this.wv2, this.wv0, this.color);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InplaceSolverIslandCallback
    implements SimulationIslandManager.IslandCallback {
        public ContactSolverInfo solverInfo;
        public ConstraintSolver solver;
        public List<TypedConstraint> sortedConstraints;
        public int numConstraints;
        public IDebugDraw debugDrawer;
        public Dispatcher dispatcher;

        private InplaceSolverIslandCallback() {
        }

        public void init(ContactSolverInfo solverInfo, ConstraintSolver solver, List<TypedConstraint> sortedConstraints, int numConstraints, IDebugDraw debugDrawer, Dispatcher dispatcher) {
            this.solverInfo = solverInfo;
            this.solver = solver;
            this.sortedConstraints = sortedConstraints;
            this.numConstraints = numConstraints;
            this.debugDrawer = debugDrawer;
            this.dispatcher = dispatcher;
        }

        @Override
        public void processIsland(List<CollisionObject> bodies, int numBodies, List<PersistentManifold> manifolds, int manifolds_offset, int numManifolds, int islandId) {
            if (islandId < 0) {
                this.solver.solveGroup(bodies, numBodies, manifolds, manifolds_offset, numManifolds, this.sortedConstraints, 0, this.numConstraints, this.solverInfo, this.debugDrawer, this.dispatcher);
            } else {
                int i;
                int startConstraint_idx = -1;
                int numCurConstraints = 0;
                for (i = 0; i < this.numConstraints; ++i) {
                    if (DiscreteDynamicsWorld.getConstraintIslandId(this.sortedConstraints.get(i)) != islandId) continue;
                    startConstraint_idx = i;
                    break;
                }
                while (i < this.numConstraints) {
                    if (DiscreteDynamicsWorld.getConstraintIslandId(this.sortedConstraints.get(i)) == islandId) {
                        ++numCurConstraints;
                    }
                    ++i;
                }
                if (numManifolds + numCurConstraints > 0) {
                    this.solver.solveGroup(bodies, numBodies, manifolds, manifolds_offset, numManifolds, this.sortedConstraints, startConstraint_idx, numCurConstraints, this.solverInfo, this.debugDrawer, this.dispatcher);
                }
            }
        }
    }
}

