/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.collision.shapes.IndexedMesh;
import com.bulletphysics.collision.shapes.ScalarType;
import com.bulletphysics.collision.shapes.StridingMeshInterface;
import com.bulletphysics.collision.shapes.VertexData;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriangleIndexVertexArray
extends StridingMeshInterface {
    protected List<IndexedMesh> indexedMeshes = new ArrayList<IndexedMesh>();

    public TriangleIndexVertexArray() {
    }

    public TriangleIndexVertexArray(int numTriangles, ByteBuffer triangleIndexBase, int triangleIndexStride, int numVertices, ByteBuffer vertexBase, int vertexStride) {
        IndexedMesh mesh = new IndexedMesh();
        mesh.numTriangles = numTriangles;
        mesh.triangleIndexBase = triangleIndexBase;
        mesh.triangleIndexStride = triangleIndexStride;
        mesh.numVertices = numVertices;
        mesh.vertexBase = vertexBase;
        mesh.vertexStride = vertexStride;
        this.addIndexedMesh(mesh);
    }

    public void addIndexedMesh(IndexedMesh mesh) {
        this.addIndexedMesh(mesh, ScalarType.INTEGER);
    }

    public void addIndexedMesh(IndexedMesh mesh, ScalarType indexType) {
        this.indexedMeshes.add(mesh);
        this.indexedMeshes.get((int)(this.indexedMeshes.size() - 1)).indexType = indexType;
    }

    @Override
    public void getLockedVertexIndexBase(VertexData data, int subpart) {
        assert (subpart < this.getNumSubParts());
        IndexedMesh mesh = this.indexedMeshes.get(subpart);
        data.numverts = mesh.numVertices;
        data.vertexbase = mesh.vertexBase;
        data.type = ScalarType.FLOAT;
        data.stride = mesh.vertexStride;
        data.numfaces = mesh.numTriangles;
        data.indexbase = mesh.triangleIndexBase;
        data.indexstride = mesh.triangleIndexStride;
        data.indicestype = mesh.indexType;
    }

    @Override
    public void getLockedReadOnlyVertexIndexBase(VertexData data, int subpart) {
        IndexedMesh mesh = this.indexedMeshes.get(subpart);
        data.numverts = mesh.numVertices;
        data.vertexbase = mesh.vertexBase;
        data.type = ScalarType.FLOAT;
        data.stride = mesh.vertexStride;
        data.numfaces = mesh.numTriangles;
        data.indexbase = mesh.triangleIndexBase;
        data.indexstride = mesh.triangleIndexStride;
        data.indicestype = mesh.indexType;
    }

    @Override
    public void unLockVertexBase(int subpart) {
    }

    @Override
    public void unLockReadOnlyVertexBase(int subpart) {
    }

    @Override
    public int getNumSubParts() {
        return this.indexedMeshes.size();
    }

    public List<IndexedMesh> getIndexedMeshArray() {
        return this.indexedMeshes;
    }

    @Override
    public void preallocateVertices(int numverts) {
    }

    @Override
    public void preallocateIndices(int numindices) {
    }
}

