/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.$Stack;
import com.bulletphysics.collision.shapes.InternalTriangleIndexCallback;
import com.bulletphysics.collision.shapes.ScalarType;
import com.bulletphysics.collision.shapes.VertexData;
import com.bulletphysics.linearmath.VectorUtil;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public abstract class StridingMeshInterface {
    protected final Vector3f scaling = new Vector3f(1.0f, 1.0f, 1.0f);
    private VertexData data = new VertexData();

    /*
     * WARNING - void declaration
     */
    public void internalProcessAllTriangles(InternalTriangleIndexCallback internalTriangleIndexCallback, Vector3f vector3f, Vector3f vector3f2) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            $Stack.push$javax$vecmath$Vector3f();
            int numtotalphysicsverts = 0;
            int graphicssubparts = this.getNumSubParts();
            Vector3f[] triangle = new Vector3f[]{$Stack.get$javax$vecmath$Vector3f(), $Stack.get$javax$vecmath$Vector3f(), $Stack.get$javax$vecmath$Vector3f()};
            Vector3f meshScaling = this.getScaling($Stack.get$javax$vecmath$Vector3f());
            for (int part = 0; part < graphicssubparts; ++part) {
                this.getLockedReadOnlyVertexIndexBase(this.data, part);
                numtotalphysicsverts += this.data.numfaces * 3;
                switch (this.data.indicestype) {
                    case INTEGER: {
                        void callback;
                        int graphicsbase;
                        int tri_indices;
                        int gfxindex;
                        for (gfxindex = 0; gfxindex < this.data.numfaces; ++gfxindex) {
                            tri_indices = gfxindex * this.data.indexstride;
                            graphicsbase = this.data.indexbase.getInt(tri_indices + 0) * this.data.stride;
                            triangle[0].set(this.data.vertexbase.getFloat(graphicsbase + 0) * meshScaling.x, this.data.vertexbase.getFloat(graphicsbase + 4) * meshScaling.y, this.data.vertexbase.getFloat(graphicsbase + 8) * meshScaling.z);
                            graphicsbase = this.data.indexbase.getInt(tri_indices + 4) * this.data.stride;
                            triangle[1].set(this.data.vertexbase.getFloat(graphicsbase + 0) * meshScaling.x, this.data.vertexbase.getFloat(graphicsbase + 4) * meshScaling.y, this.data.vertexbase.getFloat(graphicsbase + 8) * meshScaling.z);
                            graphicsbase = this.data.indexbase.getInt(tri_indices + 8) * this.data.stride;
                            triangle[2].set(this.data.vertexbase.getFloat(graphicsbase + 0) * meshScaling.x, this.data.vertexbase.getFloat(graphicsbase + 4) * meshScaling.y, this.data.vertexbase.getFloat(graphicsbase + 8) * meshScaling.z);
                            callback.internalProcessTriangleIndex(triangle, part, gfxindex);
                        }
                        break;
                    }
                    case SHORT: {
                        void callback;
                        int graphicsbase;
                        int tri_indices;
                        int gfxindex;
                        for (gfxindex = 0; gfxindex < this.data.numfaces; ++gfxindex) {
                            tri_indices = gfxindex * this.data.indexstride;
                            graphicsbase = (this.data.indexbase.getShort(tri_indices + 0) & 0xFFFF) * this.data.stride;
                            triangle[0].set(this.data.vertexbase.getFloat(graphicsbase + 0) * meshScaling.x, this.data.vertexbase.getFloat(graphicsbase + 4) * meshScaling.y, this.data.vertexbase.getFloat(graphicsbase + 8) * meshScaling.z);
                            graphicsbase = (this.data.indexbase.getShort(tri_indices + 2) & 0xFFFF) * this.data.stride;
                            triangle[1].set(this.data.vertexbase.getFloat(graphicsbase + 0) * meshScaling.x, this.data.vertexbase.getFloat(graphicsbase + 4) * meshScaling.y, this.data.vertexbase.getFloat(graphicsbase + 8) * meshScaling.z);
                            graphicsbase = (this.data.indexbase.getShort(tri_indices + 4) & 0xFFFF) * this.data.stride;
                            triangle[2].set(this.data.vertexbase.getFloat(graphicsbase + 0) * meshScaling.x, this.data.vertexbase.getFloat(graphicsbase + 4) * meshScaling.y, this.data.vertexbase.getFloat(graphicsbase + 8) * meshScaling.z);
                            callback.internalProcessTriangleIndex(triangle, part, gfxindex);
                        }
                        break;
                    }
                    default: {
                        assert (this.data.indicestype == ScalarType.INTEGER || this.data.indicestype == ScalarType.SHORT);
                        break;
                    }
                }
                this.unLockReadOnlyVertexBase(part);
            }
            this.data.unref();
            $Stack.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    public void calculateAabbBruteForce(Vector3f aabbMin, Vector3f aabbMax) {
        AabbCalculationCallback aabbCallback = new AabbCalculationCallback();
        aabbMin.set(-1.0E30f, -1.0E30f, -1.0E30f);
        aabbMax.set(1.0E30f, 1.0E30f, 1.0E30f);
        this.internalProcessAllTriangles(aabbCallback, aabbMin, aabbMax);
        aabbMin.set((Tuple3f)aabbCallback.aabbMin);
        aabbMax.set((Tuple3f)aabbCallback.aabbMax);
    }

    public abstract void getLockedVertexIndexBase(VertexData var1, int var2);

    public abstract void getLockedReadOnlyVertexIndexBase(VertexData var1, int var2);

    public abstract void unLockVertexBase(int var1);

    public abstract void unLockReadOnlyVertexBase(int var1);

    public abstract int getNumSubParts();

    public abstract void preallocateVertices(int var1);

    public abstract void preallocateIndices(int var1);

    public Vector3f getScaling(Vector3f out) {
        out.set((Tuple3f)this.scaling);
        return out;
    }

    public void setScaling(Vector3f scaling) {
        this.scaling.set((Tuple3f)scaling);
    }

    private static class AabbCalculationCallback
    implements InternalTriangleIndexCallback {
        public final Vector3f aabbMin = new Vector3f(1.0E30f, 1.0E30f, 1.0E30f);
        public final Vector3f aabbMax = new Vector3f(-1.0E30f, -1.0E30f, -1.0E30f);

        private AabbCalculationCallback() {
        }

        public void internalProcessTriangleIndex(Vector3f[] triangle, int partId, int triangleIndex) {
            VectorUtil.setMin(this.aabbMin, triangle[0]);
            VectorUtil.setMax(this.aabbMax, triangle[0]);
            VectorUtil.setMin(this.aabbMin, triangle[1]);
            VectorUtil.setMax(this.aabbMax, triangle[1]);
            VectorUtil.setMin(this.aabbMin, triangle[2]);
            VectorUtil.setMax(this.aabbMax, triangle[2]);
        }
    }
}

