/*
 * Decompiled with CFR 0.152.
 */
package iss.formatter;

import iss.formatter.CodeFormatterApplication;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class JavaCodeFormatterTask
extends Task {
    private Vector filesets = new Vector();
    private String config;
    private boolean quiet;
    private boolean verbose;

    protected void validate() {
        if (this.config == null) {
            throw new BuildException("config not set");
        }
        File file = new File(this.config);
        if (!file.exists()) {
            throw new BuildException("config file does not exists");
        }
        if (this.filesets.size() < 1) {
            throw new BuildException("fileset not set");
        }
        if (this.quiet && this.verbose) {
            throw new BuildException("verbose and quiet cannot both be true");
        }
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setVerbose(String verbose) {
        if (verbose.equals("true")) {
            this.verbose = true;
        }
    }

    public void setQuiet(String quiet) {
        if (quiet.equals("true")) {
            this.quiet = true;
        }
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public void execute() {
        this.validate();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-config");
        arguments.add(this.config);
        if (this.verbose) {
            arguments.add("-verbose");
        }
        if (this.quiet) {
            arguments.add("-quiet");
        }
        CodeFormatterApplication cfa = new CodeFormatterApplication();
        for (Object fileset : this.filesets) {
            String[] srcFiles;
            FileSet fs = (FileSet)fileset;
            DirectoryScanner scanner = fs.getDirectoryScanner(this.project);
            File fromDir = fs.getDir(this.project);
            for (String srcFile : srcFiles = scanner.getIncludedFiles()) {
                arguments.add(new File(fromDir, srcFile).toString());
            }
        }
        String[] str = new String[arguments.size()];
        arguments.toArray(str);
        try {
            cfa.run(arguments.toArray(str));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }
}

