/*
 * Decompiled with CFR 0.152.
 */
package iss.formatter;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEdit;

public class CodeFormatterApplication
implements IPlatformRunnable {
    private final String ARG_CONFIG = "-config";
    private final String ARG_HELP = "-help";
    private final String ARG_QUIET = "-quiet";
    private final String ARG_VERBOSE = "-verbose";
    private final String PDE_LAUNCH = "-pdelaunch";
    private Properties options = null;
    private boolean quiet = false;
    private boolean verbose = false;
    private String configName;
    static boolean format = true;

    private void displayHelp() {
        System.out.println(Messages.bind(Messages.CommandLineUsage));
    }

    private void displayHelp(String message) {
        System.err.println(message);
        System.out.println();
        this.displayHelp();
    }

    private void formatDirTree(File dir, CodeFormatter codeFormatter) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
                continue;
            }
            if (!file.getPath().endsWith(".java")) continue;
            this.formatFile(file, codeFormatter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatFile(File file, CodeFormatter codeFormatter) {
        Document doc = new Document();
        try {
            String absolutePath = file.getAbsolutePath();
            if (this.verbose) {
                System.out.println(Messages.bind(Messages.CommandLineFormatting, absolutePath));
            }
            String contents = new String(Util.getFileCharContent((File)file, null));
            doc.set(contents);
            if (format) {
                TextEdit edit = codeFormatter.format(8, contents, 0, contents.length(), 0, null);
                if (edit != null) {
                    edit.apply((IDocument)doc);
                } else {
                    System.err.println(Messages.bind(Messages.FormatProblem, absolutePath));
                    return;
                }
            }
            BufferedWriter out = new BufferedWriter(new FileWriter(file));
            try {
                out.write(doc.get());
                out.flush();
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
            String errorMessage = Messages.bind(Messages.CaughtException, "IOException", e.getLocalizedMessage());
            org.eclipse.jdt.internal.core.util.Util.log((Throwable)e, (String)errorMessage);
            System.err.println(Messages.bind(Messages.ExceptionSkip, errorMessage));
        }
        catch (BadLocationException e) {
            String errorMessage = Messages.bind(Messages.CaughtException, "BadLocationException", e.getLocalizedMessage());
            org.eclipse.jdt.internal.core.util.Util.log((Throwable)e, (String)errorMessage);
            System.err.println(Messages.bind(Messages.ExceptionSkip, errorMessage));
        }
    }

    private File[] processCommandLine(String[] argsArray) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < argsArray.length; ++i) {
            args.add(argsArray[i]);
        }
        int index = 0;
        int argCount = argsArray.length;
        boolean DEFAULT_MODE = false;
        boolean CONFIG_MODE = true;
        int mode = 0;
        boolean INITIAL_SIZE = true;
        int fileCounter = 0;
        File[] filesToFormat = new File[1];
        while (index < argCount) {
            String currentArg = argsArray[index++];
            switch (mode) {
                case 0: {
                    if ("-pdelaunch".equals(currentArg)) break;
                    if ("-help".equals(currentArg)) {
                        this.displayHelp();
                        return null;
                    }
                    if ("-verbose".equals(currentArg)) {
                        this.verbose = true;
                        break;
                    }
                    if ("-quiet".equals(currentArg)) {
                        this.quiet = true;
                        break;
                    }
                    if ("-config".equals(currentArg)) {
                        mode = 1;
                        break;
                    }
                    File file = new File(currentArg);
                    if (file.exists()) {
                        if (filesToFormat.length == fileCounter) {
                            File[] fileArray = filesToFormat;
                            filesToFormat = new File[fileCounter * 2];
                            System.arraycopy(fileArray, 0, filesToFormat, 0, fileCounter);
                        }
                        filesToFormat[fileCounter++] = file;
                        break;
                    }
                    this.displayHelp(Messages.bind(Messages.CommandLineErrorFile, currentArg));
                    return null;
                }
                case 1: {
                    this.configName = currentArg;
                    this.options = this.readConfig(currentArg);
                    if (this.options == null) {
                        this.displayHelp(Messages.bind(Messages.CommandLineErrorConfig, currentArg));
                        return null;
                    }
                    mode = 0;
                    break;
                }
            }
        }
        if (mode == 1 || this.options == null) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorNoConfigFile));
            return null;
        }
        if (this.quiet && this.verbose) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorQuietVerbose, new String[]{"-quiet", "-verbose"}));
            return null;
        }
        if (fileCounter == 0) {
            this.displayHelp(Messages.bind(Messages.CommandLineErrorFileDir));
            return null;
        }
        if (filesToFormat.length != fileCounter) {
            File[] fileArray = filesToFormat;
            filesToFormat = new File[fileCounter];
            System.arraycopy(fileArray, 0, filesToFormat, 0, fileCounter);
        }
        return filesToFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readConfig(String filename) {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(new File(filename)));
            Properties formatterOptions = new Properties();
            formatterOptions.load(stream);
            Properties properties = formatterOptions;
            return properties;
        }
        catch (IOException e) {
            org.eclipse.jdt.internal.core.util.Util.log((Throwable)e, (String)Messages.bind(Messages.ConfigFileReadingError));
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public Object run(Object args) throws Exception {
        String[] str = (String[])args;
        File[] filesToFormat = this.processCommandLine((String[])args);
        if (filesToFormat == null) {
            return EXIT_OK;
        }
        if (!this.quiet) {
            if (this.configName != null) {
                System.out.println(Messages.bind(Messages.CommandLineConfigFile, this.configName));
            }
            System.out.println(Messages.bind(Messages.CommandLineStart));
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)this.options);
        for (File file : filesToFormat) {
            if (file.isDirectory()) {
                this.formatDirTree(file, codeFormatter);
                continue;
            }
            if (!file.getPath().endsWith(".java")) continue;
            this.formatFile(file, codeFormatter);
        }
        if (!this.quiet) {
            System.out.println(Messages.bind(Messages.CommandLineDone));
        }
        return EXIT_OK;
    }

    class FormatException
    extends Exception {
        FormatException(String msg) {
            super(msg);
        }
    }

    private static final class Messages
    extends NLS {
        private static final String BUNDLE_NAME = "org.eclipse.jdt.core.formatter.messages";
        public static String CaughtException;
        public static String CommandLineConfigFile;
        public static String CommandLineDone;
        public static String CommandLineErrorConfig;
        public static String CommandLineErrorFile;
        public static String CommandLineErrorFileDir;
        public static String CommandLineErrorNoConfigFile;
        public static String CommandLineErrorQuietVerbose;
        public static String CommandLineFormatting;
        public static String CommandLineStart;
        public static String CommandLineUsage;
        public static String ConfigFileReadingError;
        public static String ExceptionSkip;
        public static String FormatProblem;

        private Messages() {
        }

        public static String bind(String message) {
            return Messages.bind(message, null);
        }

        public static String bind(String message, Object binding) {
            return Messages.bind(message, new Object[]{binding});
        }

        public static String bind(String message, Object binding1, Object binding2) {
            return Messages.bind(message, new Object[]{binding1, binding2});
        }

        public static String bind(String message, Object[] bindings) {
            return MessageFormat.format(message, bindings);
        }

        static {
            NLS.initializeMessages((String)BUNDLE_NAME, Messages.class);
        }
    }
}

