/*
 * Decompiled with CFR 0.152.
 */
package iss;

import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SvnStatus
extends Task {
    String outputFile;
    static final int MODIFICATION_COLUMN = 0;
    static final int OUT_OF_DATE_COLUMN = 7;
    static List<String> knownPreffixes = Arrays.asList("Status against", "--- Changelist");

    public void execute() throws BuildException {
        try {
            String line;
            File file = new File(this.outputFile);
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            Process ls_proc = Runtime.getRuntime().exec("svn st -u");
            DataInputStream ls_in = new DataInputStream(ls_proc.getInputStream());
            StringBuffer warningMessage = new StringBuffer();
            while ((line = ls_in.readLine()) != null) {
                if (line.length() <= 0) continue;
                if (line.charAt(0) == '?') {
                    String[] columns = (line = line.trim()).split(" ");
                    String entryName = columns[columns.length - 1];
                    File entryFile = new File(entryName);
                    if (entryFile.isDirectory()) {
                        entryName = entryName + "/**";
                    }
                    output.write(entryName);
                    output.newLine();
                    continue;
                }
                if (!this.containsEntryPreffix(line) || line.charAt(0) == ' ' && line.charAt(7) == ' ') continue;
                warningMessage.append(line + "\n");
            }
            output.close();
            if (warningMessage.length() > 0) {
                System.err.println("Warning, some files or directories differ from the current repository version:");
                System.err.println(warningMessage);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    boolean containsEntryPreffix(String line) {
        for (String preffix : knownPreffixes) {
            if (!line.startsWith(preffix)) continue;
            return false;
        }
        return true;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }
}

