/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreAdaptor;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.SimpleFeatureCollectionBridge;
import org.geotools.data.SimpleFeatureLockingBridge;
import org.geotools.data.SimpleFeatureReaderBrige;
import org.geotools.data.SimpleFeatureSourceBridge;
import org.geotools.data.SimpleFeatureStoreBridge;
import org.geotools.data.collection.CollectionFeatureSource;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.collection.SpatialIndexFeatureSource;
import org.geotools.data.collection.TreeSetFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.view.DefaultView;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.GeometryAttributeImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.BridgeIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.PropertyNameResolvingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Converters;
import org.geotools.util.NullProgressListener;
import org.geotools.util.Utilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.geometry.BoundingBox;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.ProgressListener;

public class DataUtilities {
    static Map<String, Class> typeMap = new HashMap<String, Class>();
    static Map<Class, String> typeEncode = new HashMap<Class, String>();
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
    static final boolean IS_WINDOWS_OS;

    public static String[] attributeNames(SimpleFeatureType featureType) {
        String[] names = new String[featureType.getAttributeCount()];
        int count = featureType.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            names[i] = featureType.getDescriptor(i).getLocalName();
        }
        return names;
    }

    public static URL fileToURL(File file) {
        try {
            URL url = file.toURI().toURL();
            String string = url.toExternalForm();
            if (string.contains("+")) {
                string = string.replace("+", "%2B");
            }
            if (string.contains(" ")) {
                string = string.replace(" ", "%20");
            }
            return new URL(string);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static File urlToFile(URL url) {
        String path3;
        if (!"file".equals(url.getProtocol())) {
            return null;
        }
        String string = url.toExternalForm();
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not decode the URL to UTF-8 format", e);
        }
        String simplePrefix = "file:/";
        String standardPrefix = "file://";
        if (IS_WINDOWS_OS && string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length() - 2);
            File f = new File(path3);
            if (!f.exists()) {
                path3 = path3.substring(2, path3.length());
            }
        } else if (string.startsWith(standardPrefix)) {
            path3 = string.substring(standardPrefix.length());
        } else if (string.startsWith(simplePrefix)) {
            path3 = string.substring(simplePrefix.length() - 1);
        } else {
            String auth = url.getAuthority();
            String path2 = url.getPath().replace("%20", " ");
            path3 = auth != null && !auth.equals("") ? "//" + auth + path2 : path2;
        }
        return new File(path3);
    }

    public static String[] attributeNames(Filter filter, SimpleFeatureType featureType) {
        if (filter == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept((FilterVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static Set<PropertyName> propertyNames(Filter filter, SimpleFeatureType featureType) {
        if (filter == null) {
            return Collections.emptySet();
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        filter.accept((FilterVisitor)attExtractor, null);
        Set<PropertyName> propertyNames = attExtractor.getPropertyNameSet();
        return propertyNames;
    }

    public static String[] attributeNames(Filter filter) {
        return DataUtilities.attributeNames(filter, null);
    }

    public static Set<PropertyName> propertyNames(Filter filter) {
        return DataUtilities.propertyNames(filter, null);
    }

    public static String[] attributeNames(Expression expression, SimpleFeatureType featureType) {
        if (expression == null) {
            return new String[0];
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        expression.accept((ExpressionVisitor)attExtractor, null);
        String[] attributeNames = attExtractor.getAttributeNames();
        return attributeNames;
    }

    public static Set<PropertyName> propertyNames(Expression expression, SimpleFeatureType featureType) {
        if (expression == null) {
            return Collections.emptySet();
        }
        FilterAttributeExtractor attExtractor = new FilterAttributeExtractor(featureType);
        expression.accept((ExpressionVisitor)attExtractor, null);
        Set<PropertyName> propertyNames = attExtractor.getPropertyNameSet();
        return propertyNames;
    }

    public static String[] attributeNames(Expression expression) {
        return DataUtilities.attributeNames(expression, null);
    }

    public static Set<PropertyName> propertyNames(Expression expression) {
        return DataUtilities.propertyNames(expression, null);
    }

    public static int compare(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        int countB;
        if (typeA == typeB) {
            return 0;
        }
        if (typeA == null) {
            return -1;
        }
        if (typeB == null) {
            return -1;
        }
        int countA = typeA.getAttributeCount();
        if (countA > (countB = typeB.getAttributeCount())) {
            return -1;
        }
        int match = 0;
        for (int i = 0; i < countA; ++i) {
            AttributeDescriptor a = typeA.getDescriptor(i);
            if (DataUtilities.isMatch(a, typeB.getDescriptor(i))) {
                ++match;
                continue;
            }
            if (DataUtilities.isMatch(a, typeB.getDescriptor(a.getLocalName()))) continue;
            return -1;
        }
        if (countA == countB && match == countA) {
            return 0;
        }
        return 1;
    }

    public static boolean isMatch(AttributeDescriptor a, AttributeDescriptor b) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return a.getLocalName().equals(b.getLocalName()) && a.getClass().equals(b.getClass());
    }

    public static SimpleFeature reType(SimpleFeatureType featureType, SimpleFeature feature) throws IllegalAttributeException {
        SimpleFeatureType origional = feature.getFeatureType();
        if (featureType.equals(origional)) {
            return SimpleFeatureBuilder.copy(feature);
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeDescriptor curAttType = featureType.getDescriptor(i);
            String xpath = curAttType.getLocalName();
            attributes[i] = DataUtilities.duplicate(feature.getAttribute(xpath));
        }
        return SimpleFeatureBuilder.build(featureType, attributes, id);
    }

    public static SimpleFeature reType(SimpleFeatureType featureType, SimpleFeature feature, boolean duplicate) throws IllegalAttributeException {
        if (duplicate) {
            return DataUtilities.reType(featureType, feature);
        }
        SimpleFeatureType origional = feature.getFeatureType();
        if (featureType.equals(origional)) {
            return feature;
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeDescriptor curAttType = featureType.getDescriptor(i);
            attributes[i] = feature.getAttribute(curAttType.getLocalName());
        }
        return SimpleFeatureBuilder.build(featureType, attributes, id);
    }

    public static Object duplicate(Object src) {
        if (src == null) {
            return null;
        }
        if (src instanceof String || src instanceof Integer || src instanceof Double || src instanceof Float || src instanceof Byte || src instanceof Boolean || src instanceof Short || src instanceof Long || src instanceof Character || src instanceof Number) {
            return src;
        }
        if (src instanceof Date) {
            return new Date(((Date)src).getTime());
        }
        if (src instanceof URL || src instanceof URI) {
            return src;
        }
        if (src instanceof Object[]) {
            Object[] array = (Object[])src;
            Object[] copy = new Object[array.length];
            for (int i = 0; i < array.length; ++i) {
                copy[i] = DataUtilities.duplicate(array[i]);
            }
            return copy;
        }
        if (src instanceof Geometry) {
            Geometry geometry = (Geometry)src;
            return geometry.clone();
        }
        if (src instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)src;
            return SimpleFeatureBuilder.copy(feature);
        }
        Class<?> type = src.getClass();
        if (type.isArray() && type.getComponentType().isPrimitive()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            System.arraycopy(src, 0, copy, 0, length);
            return copy;
        }
        if (type.isArray()) {
            int length = Array.getLength(src);
            Object copy = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                Array.set(copy, i, DataUtilities.duplicate(Array.get(src, i)));
            }
            return copy;
        }
        if (src instanceof List) {
            List list = (List)src;
            ArrayList<Object> copy = new ArrayList<Object>(list.size());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                copy.add(DataUtilities.duplicate(i.next()));
            }
            return Collections.unmodifiableList(copy);
        }
        if (src instanceof Map) {
            Map map = (Map)src;
            HashMap copy = new HashMap(map.size());
            for (Map.Entry entry : map.entrySet()) {
                copy.put(entry.getKey(), DataUtilities.duplicate(entry.getValue()));
            }
            return Collections.unmodifiableMap(copy);
        }
        if (src instanceof GridCoverage) {
            return src;
        }
        throw new IllegalAttributeException(null, (Object)("Do not know how to deep copy " + type.getName()));
    }

    public static SimpleFeature template(SimpleFeatureType featureType) throws IllegalAttributeException {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType), null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureID) {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType), featureID);
    }

    public static Object[] defaultValues(SimpleFeatureType featureType) {
        return DataUtilities.defaultValues(featureType, null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, Object[] providedValues) {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType, providedValues), null);
    }

    public static SimpleFeature template(SimpleFeatureType featureType, String featureID, Object[] providedValues) {
        return SimpleFeatureBuilder.build(featureType, DataUtilities.defaultValues(featureType, providedValues), featureID);
    }

    public static Object[] defaultValues(SimpleFeatureType featureType, Object[] values) {
        if (values == null) {
            values = new Object[featureType.getAttributeCount()];
        } else if (values.length != featureType.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException("values");
        }
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor descriptor = featureType.getDescriptor(i);
            values[i] = descriptor.getDefaultValue();
        }
        return values;
    }

    public static Object defaultValue(AttributeDescriptor attributeType) throws IllegalAttributeException {
        Object value = attributeType.getDefaultValue();
        if (value == null && !attributeType.isNillable()) {
            return null;
        }
        return value;
    }

    public static Object defaultValue(Class type) {
        if (type == String.class || type == Object.class) {
            return "";
        }
        if (type == Integer.class) {
            return new Integer(0);
        }
        if (type == Double.class) {
            return new Double(0.0);
        }
        if (type == Long.class) {
            return new Long(0L);
        }
        if (type == Short.class) {
            return new Short(0);
        }
        if (type == Float.class) {
            return new Float(0.0f);
        }
        if (type == BigDecimal.class) {
            return BigDecimal.valueOf(0L);
        }
        if (type == BigInteger.class) {
            return BigInteger.valueOf(0L);
        }
        if (type == Character.class) {
            return new Character(' ');
        }
        if (type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == UUID.class) {
            return UUID.fromString("00000000-0000-0000-0000-000000000000");
        }
        if (type == Timestamp.class) {
            return new Timestamp(0L);
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(0L);
        }
        if (type == Time.class) {
            return new Time(0L);
        }
        if (type == Date.class) {
            return new Date(0L);
        }
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        if (type == Point.class) {
            return point;
        }
        if (type == MultiPoint.class) {
            return fac.createMultiPoint(new Point[]{point});
        }
        LineString lineString = fac.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0)});
        if (type == LineString.class) {
            return lineString;
        }
        LinearRing linearRing = fac.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(1.0, 1.0), new Coordinate(1.0, 0.0), new Coordinate(0.0, 0.0)});
        if (type == LinearRing.class) {
            return linearRing;
        }
        if (type == MultiLineString.class) {
            return fac.createMultiLineString(new LineString[]{lineString});
        }
        Polygon polygon = fac.createPolygon(linearRing, new LinearRing[0]);
        if (type == Polygon.class) {
            return polygon;
        }
        if (type == MultiPolygon.class) {
            return fac.createMultiPolygon(new Polygon[]{polygon});
        }
        throw new IllegalArgumentException(type + " is not supported by this method");
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(final SimpleFeature[] features) throws IOException {
        if (features == null || features.length == 0) {
            throw new IOException("Provided features where empty");
        }
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){
            SimpleFeature[] array;
            int offset;
            {
                this.array = features;
                this.offset = -1;
            }

            public SimpleFeatureType getFeatureType() {
                return features[0].getFeatureType();
            }

            public SimpleFeature next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more features");
                }
                return this.array[++this.offset];
            }

            public boolean hasNext() {
                return this.array != null && this.offset < this.array.length - 1;
            }

            public void close() {
                this.array = null;
                this.offset = -1;
            }
        };
    }

    public static SimpleFeatureSource source(SimpleFeature[] featureArray) {
        SimpleFeatureType featureType = featureArray == null || featureArray.length == 0 ? FeatureTypes.EMPTY : featureArray[0].getFeatureType();
        ListFeatureCollection collection = new ListFeatureCollection(featureType, featureArray);
        for (SimpleFeature feature : collection) {
            if (feature.getFeatureType() == featureType) continue;
            String typeName = featureType.getTypeName();
            throw new IllegalStateException("Array inconsistent, expected each feature of type  " + typeName);
        }
        return DataUtilities.source((FeatureCollection<SimpleFeatureType, SimpleFeature>)collection);
    }

    public static SimpleFeatureSource source(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection == null) {
            throw new NullPointerException("No content provided");
        }
        if (collection instanceof ListFeatureCollection) {
            ListFeatureCollection list = (ListFeatureCollection)collection;
            CollectionFeatureSource source = new CollectionFeatureSource(list);
            return source;
        }
        if (collection instanceof SpatialIndexFeatureCollection) {
            SpatialIndexFeatureCollection indexed = (SpatialIndexFeatureCollection)collection;
            SpatialIndexFeatureSource source = new SpatialIndexFeatureSource(indexed);
            return source;
        }
        if (collection instanceof TreeSetFeatureCollection) {
            TreeSetFeatureCollection tree = (TreeSetFeatureCollection)collection;
            CollectionFeatureSource source = new CollectionFeatureSource(tree);
            return source;
        }
        SimpleFeatureCollection simpleFeatureCollection = DataUtilities.simple(collection);
        CollectionFeatureSource source = new CollectionFeatureSource(simpleFeatureCollection);
        return source;
    }

    public static SimpleFeatureSource createView(DataStore store, Query query) throws IOException, SchemaException {
        return DataUtilities.createView(store.getFeatureSource(query.getTypeName()), query);
    }

    public static SimpleFeatureSource createView(SimpleFeatureSource source, Query query) throws IOException, SchemaException {
        return new DefaultView(source, query);
    }

    public static DataStore dataStore(SimpleFeatureCollection features) {
        SimpleFeatureSource source = DataUtilities.source((FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
        return DataUtilities.dataStore(source);
    }

    public static DataStore dataStore(SimpleFeatureSource source) {
        return new DataStoreAdaptor(source);
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(Collection<SimpleFeature> collection) throws IOException {
        return DataUtilities.reader(collection.toArray(new SimpleFeature[collection.size()]));
    }

    public static FeatureReader<SimpleFeatureType, SimpleFeature> reader(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        return DataUtilities.reader((SimpleFeature[])collection.toArray((Object[])new SimpleFeature[collection.size()]));
    }

    public static SimpleFeatureCollection collection(SimpleFeature[] features) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        int length = features.length;
        for (int i = 0; i < length; ++i) {
            collection.add(features[i]);
        }
        return collection;
    }

    public static DefaultFeatureCollection collection(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        return new DefaultFeatureCollection(featureCollection);
    }

    public static void close(Iterator<?> iterator) {
        if (iterator != null && iterator instanceof Closeable) {
            try {
                ((Closeable)((Object)iterator)).close();
            }
            catch (IOException e) {
                String name = iterator.getClass().getPackage().toString();
                Logger log = Logger.getLogger(name);
                log.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <F extends Feature> F first(FeatureCollection<?, F> featureCollection) {
        if (featureCollection == null) {
            return null;
        }
        try (FeatureIterator iter = featureCollection.features();){
            while (iter.hasNext()) {
                Feature feature = iter.next();
                if (feature == null) continue;
                Feature feature2 = feature;
                return (F)feature2;
            }
            F f = null;
            return f;
        }
    }

    public static SimpleFeatureCollection simple(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        if (featureCollection instanceof SimpleFeatureCollection) {
            return (SimpleFeatureCollection)featureCollection;
        }
        if (featureCollection.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureCollectionBridge(featureCollection);
        }
        throw new IllegalArgumentException("The provided feature collection contains complex features, cannot be bridged to a simple one");
    }

    public static SimpleFeatureReader simple(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        if (reader instanceof SimpleFeatureReader) {
            return (SimpleFeatureReader)reader;
        }
        return new SimpleFeatureReaderBrige(reader);
    }

    public static SimpleFeatureSource simple(FeatureSource source) {
        if (source instanceof FeatureLocking) {
            return DataUtilities.simple((FeatureLocking)source);
        }
        if (source instanceof FeatureStore) {
            return DataUtilities.simple((FeatureStore)source);
        }
        if (source instanceof SimpleFeatureSource) {
            return (SimpleFeatureSource)source;
        }
        if (source.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureSourceBridge((FeatureSource<SimpleFeatureType, SimpleFeature>)source);
        }
        throw new IllegalArgumentException("The provided feature source contains complex features, cannot be bridged to a simple one");
    }

    public static SimpleFeatureStore simple(FeatureStore store) {
        if (store instanceof FeatureLocking) {
            return DataUtilities.simple((FeatureLocking)store);
        }
        if (store instanceof SimpleFeatureStore) {
            return (SimpleFeatureStore)store;
        }
        if (store.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureStoreBridge((FeatureStore<SimpleFeatureType, SimpleFeature>)store);
        }
        throw new IllegalArgumentException("The provided feature store contains complex features, cannot be bridged to a simple one");
    }

    public static SimpleFeatureType simple(FeatureType featureType) throws DataSourceException {
        SimpleFeatureType simpleFeatureType;
        if (featureType == null) {
            return null;
        }
        Collection descriptors = featureType.getDescriptors();
        ArrayList attributes = new ArrayList(descriptors);
        ArrayList<String> simpleProperties = new ArrayList<String>();
        ArrayList<AttributeDescriptor> simpleAttributes = new ArrayList<AttributeDescriptor>();
        List<String> ignoreList = Arrays.asList("location", "metaDataProperty", "description", "name", "boundedBy");
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            AttributeDescriptor descriptor;
            Name name;
            PropertyDescriptor property = (PropertyDescriptor)it.next();
            if (!(property instanceof AttributeDescriptor) || !ignoreList.contains((name = (descriptor = (AttributeDescriptor)property).getName()).getLocalPart())) continue;
            it.remove();
        }
        for (PropertyDescriptor descriptor : attributes) {
            Class binding = descriptor.getType().getBinding();
            int maxOccurs = descriptor.getMaxOccurs();
            Name name = descriptor.getName();
            if (Object.class.equals((Object)binding) || maxOccurs > 1 || "http://www.opengis.net/gml".equals(name.getNamespaceURI()) || !(descriptor instanceof AttributeDescriptor)) continue;
            AttributeDescriptor attribute = (AttributeDescriptor)descriptor;
            simpleAttributes.add(attribute);
            simpleProperties.add(attribute.getLocalName());
        }
        String[] properties = simpleProperties.toArray(new String[simpleProperties.size()]);
        try {
            if (featureType instanceof SimpleFeature) {
                simpleFeatureType = DataUtilities.createSubType((SimpleFeatureType)featureType, properties);
            } else {
                SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
                build.setName(featureType.getName());
                build.setAttributes(simpleAttributes);
                build.setDefaultGeometry(featureType.getGeometryDescriptor().getLocalName());
                simpleFeatureType = build.buildFeatureType();
            }
        }
        catch (SchemaException e) {
            throw new DataSourceException((Throwable)e);
        }
        return simpleFeatureType;
    }

    public static SimpleFeatureLocking simple(FeatureLocking locking) {
        if (locking instanceof SimpleFeatureLocking) {
            return (SimpleFeatureLocking)locking;
        }
        if (locking.getSchema() instanceof SimpleFeatureType) {
            return new SimpleFeatureLockingBridge((FeatureLocking<SimpleFeatureType, SimpleFeature>)locking);
        }
        throw new IllegalArgumentException("The provided feature store contains complex features, cannot be bridged to a simple one");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <F extends Feature> List<F> list(FeatureCollection<?, F> featureCollection) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        try (FeatureIterator iter = featureCollection.features();){
            while (iter.hasNext()) {
                Feature feature = iter.next();
                list.add(feature);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <F extends Feature> List<F> list(FeatureCollection<?, F> featureCollection, int maxFeatures) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        try (FeatureIterator iter = featureCollection.features();){
            for (int count = 0; iter.hasNext() && count < maxFeatures; ++count) {
                Feature feature = iter.next();
                list.add(feature);
            }
        }
        return list;
    }

    public static <F extends Feature> Iterator<F> iterator(FeatureIterator<F> featureIterator) {
        return new BridgeIterator<F>(featureIterator);
    }

    public static Set<String> fidSet(FeatureCollection<?, ?> featureCollection) {
        final HashSet<String> fids = new HashSet<String>();
        try {
            featureCollection.accepts(new FeatureVisitor(){

                public void visit(Feature feature) {
                    fids.add(feature.getIdentifier().getID());
                }
            }, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fids;
    }

    public static <F extends Feature> Collection<F> collectionCast(FeatureCollection<?, F> featureCollection) {
        if (featureCollection instanceof Collection) {
            return (Collection)featureCollection;
        }
        throw new IllegalArgumentException("Require access to SimpleFeatureCollection implementing Collecion.add");
    }

    public static SimpleFeatureCollection collection(List<SimpleFeature> list) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        for (SimpleFeature feature : list) {
            collection.add(feature);
        }
        return collection;
    }

    public static SimpleFeatureCollection collection(SimpleFeature feature) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        collection.add(feature);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimpleFeatureCollection collection(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        try {
            while (reader.hasNext()) {
                try {
                    collection.add((SimpleFeature)reader.next());
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                }
                catch (IllegalAttributeException e) {
                    throw (IOException)new IOException().initCause(e);
                    return collection;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SimpleFeatureCollection collection(SimpleFeatureIterator reader) throws IOException {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        try {
            while (reader.hasNext()) {
                try {
                    collection.add((SimpleFeature)reader.next());
                }
                catch (NoSuchElementException e) {
                    throw (IOException)new IOException("EOF").initCause(e);
                    return collection;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    public static boolean attributesEqual(Object att, Object otherAtt) {
        return !(att == null ? otherAtt != null : !att.equals(otherAtt));
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties, CoordinateReferenceSystem override) throws SchemaException {
        URI namespaceURI = null;
        if (featureType.getName().getNamespaceURI() != null) {
            try {
                namespaceURI = new URI(featureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return DataUtilities.createSubType(featureType, properties, override, featureType.getTypeName(), namespaceURI);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties, CoordinateReferenceSystem override, String typeName, URI namespace) throws SchemaException {
        if (properties == null && override == null) {
            return featureType;
        }
        if (properties == null) {
            properties = new String[featureType.getAttributeCount()];
            for (int i = 0; i < properties.length; ++i) {
                properties[i] = featureType.getDescriptor(i).getLocalName();
            }
        }
        String namespaceURI = namespace != null ? namespace.toString() : null;
        boolean same = featureType.getAttributeCount() == properties.length && featureType.getTypeName().equals(typeName) && Utilities.equals((Object)featureType.getName().getNamespaceURI(), (Object)namespaceURI);
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            AttributeDescriptor type = featureType.getDescriptor(i);
            same = type.getLocalName().equals(properties[i]) && (override == null || !(type instanceof GeometryDescriptor) || DataUtilities.assertEquals(override, ((GeometryDescriptor)type).getCoordinateReferenceSystem()));
        }
        if (same) {
            return featureType;
        }
        AttributeDescriptor[] types = new AttributeDescriptor[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = featureType.getDescriptor(properties[i]);
            if (override == null || !(types[i] instanceof GeometryDescriptor)) continue;
            AttributeTypeBuilder ab = new AttributeTypeBuilder();
            ab.init(types[i]);
            ab.setCRS(override);
            types[i] = ab.buildDescriptor(types[i].getLocalName(), ab.buildGeometryType());
        }
        if (typeName == null) {
            typeName = featureType.getTypeName();
        }
        if (namespace == null && featureType.getName().getNamespaceURI() != null) {
            try {
                namespace = new URI(featureType.getName().getNamespaceURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(typeName);
        tb.setNamespaceURI(namespace);
        tb.setCRS(null);
        tb.addAll(types);
        DataUtilities.setDefaultGeometry(tb, properties, featureType);
        return tb.buildFeatureType();
    }

    private static boolean assertEquals(Object o1, Object o2) {
        return o1 == null && o2 == null ? true : (o1 != null ? o1.equals(o2) : false);
    }

    public static SimpleFeatureType createSubType(SimpleFeatureType featureType, String[] properties) throws SchemaException {
        if (properties == null) {
            return featureType;
        }
        boolean same = featureType.getAttributeCount() == properties.length;
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            same = featureType.getDescriptor(i).getLocalName().equals(properties[i]);
        }
        if (same) {
            return featureType;
        }
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(featureType.getName());
        tb.setCRS(null);
        for (int i = 0; i < properties.length; ++i) {
            tb.add(featureType.getDescriptor(properties[i]));
        }
        DataUtilities.setDefaultGeometry(tb, properties, featureType);
        return tb.buildFeatureType();
    }

    private static void setDefaultGeometry(SimpleFeatureTypeBuilder typeBuilder, String[] properties, SimpleFeatureType featureType) {
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        if (geometryDescriptor != null) {
            String propertyName = geometryDescriptor.getLocalName();
            if (Arrays.asList(properties).contains(propertyName)) {
                typeBuilder.setDefaultGeometry(propertyName);
            }
        }
    }

    public static SimpleFeatureType createType(String typeName, String typeSpec) throws SchemaException {
        int split = typeName.lastIndexOf(46);
        String namespace = split == -1 ? null : typeName.substring(0, split);
        String name = split == -1 ? typeName : typeName.substring(split + 1);
        return DataUtilities.createType(namespace, name, typeSpec);
    }

    public static SimpleFeatureType createType(String namespace, String name, String typeSpec) throws SchemaException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(name);
        builder.setNamespaceURI(namespace);
        String[] types = typeSpec.split(",");
        builder.setCRS(null);
        for (int i = 0; i < types.length; ++i) {
            boolean defaultGeometry = types[i].startsWith("*");
            if (types[i].startsWith("*")) {
                types[i] = types[i].substring(1);
            }
            AttributeDescriptor attributeType = DataUtilities.createAttribute(types[i]);
            builder.add(attributeType);
            if (!defaultGeometry) continue;
            builder.setDefaultGeometry(attributeType.getLocalName());
        }
        return builder.buildFeatureType();
    }

    public static String encodeType(SimpleFeatureType featureType) {
        Collection types = featureType.getDescriptors();
        StringBuffer buf = new StringBuffer();
        for (PropertyDescriptor type : types) {
            GeometryDescriptor gd;
            int srid;
            buf.append(type.getName().getLocalPart());
            buf.append(":");
            buf.append(DataUtilities.typeMap(type.getType().getBinding()));
            if (type instanceof GeometryDescriptor && (srid = DataUtilities.toSRID((gd = (GeometryDescriptor)type).getCoordinateReferenceSystem())) != -1) {
                buf.append(":srid=" + srid);
            }
            buf.append(",");
        }
        buf.delete(buf.length() - 1, buf.length());
        return buf.toString();
    }

    private static int toSRID(CoordinateReferenceSystem crs) {
        if (crs == null || crs.getIdentifiers() == null) {
            return -1;
        }
        for (ReferenceIdentifier id : crs.getIdentifiers()) {
            Citation authority = id.getAuthority();
            if (authority == null || !authority.getTitle().equals(Citations.EPSG.getTitle())) continue;
            try {
                return Integer.parseInt(id.getCode());
            }
            catch (NumberFormatException nanException) {
            }
        }
        return -1;
    }

    public static String spec(FeatureType featureType) {
        Collection types = featureType.getDescriptors();
        StringBuffer buf = new StringBuffer();
        for (PropertyDescriptor type : types) {
            GeometryDescriptor gd;
            buf.append(type.getName().getLocalPart());
            buf.append(":");
            buf.append(DataUtilities.typeMap(type.getType().getBinding()));
            if (type instanceof GeometryDescriptor && (gd = (GeometryDescriptor)type).getCoordinateReferenceSystem() != null && gd.getCoordinateReferenceSystem().getIdentifiers() != null) {
                for (ReferenceIdentifier id : gd.getCoordinateReferenceSystem().getIdentifiers()) {
                    if (id.getAuthority() == null || !id.getAuthority().getTitle().equals(Citations.EPSG.getTitle())) continue;
                    buf.append(":srid=" + id.getCode());
                    break;
                }
            }
            buf.append(",");
        }
        buf.delete(buf.length() - 1, buf.length());
        return buf.toString();
    }

    public static SimpleFeature createFeature(SimpleFeatureType featureType, String line) {
        int fidSplit = line.indexOf(61);
        int barSplit = line.indexOf(124);
        String fid = fidSplit == -1 || barSplit != -1 && barSplit < fidSplit ? null : line.substring(0, fidSplit);
        String data = line.substring(fidSplit + 1);
        String[] text = DataUtilities.splitIntoText(data, featureType);
        Object[] values = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            Object value;
            AttributeDescriptor descriptor = featureType.getDescriptor(i);
            values[i] = value = DataUtilities.createValue(descriptor, text[i]);
        }
        SimpleFeature feature = SimpleFeatureBuilder.build(featureType, values, fid);
        return feature;
    }

    private static String[] splitIntoText(String data, SimpleFeatureType type) {
        String[] text = new String[type.getAttributeCount()];
        int i = 0;
        StringBuilder item = new StringBuilder();
        for (String str : data.split("\\|", -1)) {
            if (i == type.getAttributeCount()) {
                throw new IllegalArgumentException("format error: expected " + text.length + " attributes, stopped after finding " + i + ". [" + data + "] split into " + Arrays.asList(text));
            }
            if (str.endsWith("\\")) {
                item.append(str);
                item.append("|");
                continue;
            }
            item.append(str);
            text[i] = item.toString();
            ++i;
            item = new StringBuilder();
        }
        if (i < type.getAttributeCount()) {
            throw new IllegalArgumentException("createFeature format error: expected " + type.getAttributeCount() + " attributes, but only found " + i + ". [" + data + "] split into " + Arrays.asList(text));
        }
        return text;
    }

    private static Object createValue(AttributeDescriptor descriptor, String rawText) {
        CoordinateReferenceSystem crs;
        String stringValue = null;
        try {
            stringValue = DataUtilities.decodeEscapedCharacters(rawText);
        }
        catch (RuntimeException huh) {
            huh.printStackTrace();
            stringValue = null;
        }
        if ("<null>".equals(stringValue)) {
            stringValue = null;
        }
        if (stringValue == null && descriptor.isNillable()) {
            return null;
        }
        Object value = Converters.convert((Object)stringValue, (Class)descriptor.getType().getBinding());
        if (descriptor.getType() instanceof GeometryType && (crs = ((GeometryType)descriptor.getType()).getCoordinateReferenceSystem()) != null && value != null && value instanceof Geometry) {
            ((Geometry)value).setUserData((Object)crs);
        }
        return value;
    }

    public static String encodeFeature(SimpleFeature feature) {
        return DataUtilities.encodeFeature(feature, true);
    }

    public static String encodeFeature(SimpleFeature feature, boolean includeFid) {
        StringBuilder build = new StringBuilder();
        if (includeFid) {
            String fid = feature.getID();
            if (feature.getUserData().containsKey(Hints.PROVIDED_FID)) {
                fid = (String)feature.getUserData().get(Hints.PROVIDED_FID);
            }
            build.append(fid);
            build.append("=");
        }
        for (int i = 0; i < feature.getAttributeCount(); ++i) {
            String txt;
            Object attribute = feature.getAttribute(i);
            if (i != 0) {
                build.append("|");
            }
            if (attribute == null) {
                build.append("<null>");
                continue;
            }
            if (attribute instanceof String) {
                txt = DataUtilities.encodeString((String)attribute);
                build.append(txt);
                continue;
            }
            if (attribute instanceof Geometry) {
                Geometry geometry = (Geometry)attribute;
                String txt2 = geometry.toText();
                txt2 = DataUtilities.encodeString(txt2);
                build.append(txt2);
                continue;
            }
            txt = (String)Converters.convert((Object)attribute, String.class);
            if (txt == null) {
                txt = attribute.toString();
            }
            txt = DataUtilities.encodeString(txt);
            build.append(txt);
        }
        return build.toString();
    }

    public static SimpleFeature parse(SimpleFeatureType type, String fid, String[] text) throws IllegalAttributeException {
        Object[] attributes = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            AttributeType attType = type.getDescriptor(i).getType();
            attributes[i] = Converters.convert((Object)text[i], (Class)attType.getBinding());
        }
        return SimpleFeatureBuilder.build(type, attributes, fid);
    }

    private static String decodeEscapedCharacters(String txt) {
        txt = txt.replace("\\n", "\n");
        txt = txt.replaceAll("\\r", "\r");
        txt = txt.replace("\\|", "|");
        return txt;
    }

    private static String encodeString(String txt) {
        txt = txt.replace("|", "\\|");
        txt = txt.replace("\n", "\\n");
        txt = txt.replace("\r", "\\r");
        return txt;
    }

    static Class<?> type(String typeName) throws ClassNotFoundException {
        if (typeMap.containsKey(typeName)) {
            return typeMap.get(typeName);
        }
        return Class.forName(typeName);
    }

    static String typeMap(Class<?> type) {
        if (typeEncode.containsKey(type)) {
            return typeEncode.get(type);
        }
        return type.getName();
    }

    public static Comparator<SimpleFeature> sortComparator(SortBy sortBy) {
        if (sortBy == null) {
            sortBy = SortBy.NATURAL_ORDER;
        }
        if (sortBy == SortBy.NATURAL_ORDER) {
            return new Comparator<SimpleFeature>(){

                @Override
                public int compare(SimpleFeature f1, SimpleFeature f2) {
                    return f1.getID().compareTo(f2.getID());
                }
            };
        }
        if (sortBy == SortBy.REVERSE_ORDER) {
            return new Comparator<SimpleFeature>(){

                @Override
                public int compare(SimpleFeature f1, SimpleFeature f2) {
                    int compare = f1.getID().compareTo(f2.getID());
                    return -compare;
                }
            };
        }
        final PropertyName PROPERTY = sortBy.getPropertyName();
        return new Comparator<SimpleFeature>(){

            @Override
            public int compare(SimpleFeature f1, SimpleFeature f2) {
                Object value1 = PROPERTY.evaluate((Object)f1, Comparable.class);
                Object value2 = PROPERTY.evaluate((Object)f2, Comparable.class);
                if (value1 == null || value2 == null) {
                    return 0;
                }
                if (value1 instanceof Comparable && value1.getClass().isInstance(value2)) {
                    return ((Comparable)value1).compareTo(value2);
                }
                return 0;
            }
        };
    }

    public static Query mixQueries(Query firstQuery, Query secondQuery, String handle) {
        String version;
        if (firstQuery == null && secondQuery == null) {
            return Query.ALL;
        }
        if (firstQuery == null || firstQuery.equals((Object)Query.ALL)) {
            return secondQuery;
        }
        if (secondQuery == null || secondQuery.equals((Object)Query.ALL)) {
            return firstQuery;
        }
        if (firstQuery.getTypeName() != null && secondQuery.getTypeName() != null && !firstQuery.getTypeName().equals(secondQuery.getTypeName())) {
            String msg = "Type names do not match: " + firstQuery.getTypeName() + " != " + secondQuery.getTypeName();
            throw new IllegalArgumentException(msg);
        }
        if (firstQuery.getVersion() != null) {
            if (secondQuery.getVersion() != null && !secondQuery.getVersion().equals(firstQuery.getVersion())) {
                throw new IllegalArgumentException("First and second query refer different versions");
            }
            version = firstQuery.getVersion();
        } else {
            version = secondQuery.getVersion();
        }
        int maxFeatures = Math.min(firstQuery.getMaxFeatures(), secondQuery.getMaxFeatures());
        List<PropertyName> propNames = DataUtilities.joinAttributes(firstQuery.getProperties(), secondQuery.getProperties());
        Filter filter = firstQuery.getFilter();
        Filter filter2 = secondQuery.getFilter();
        if (filter == null || filter.equals(Filter.INCLUDE)) {
            filter = filter2;
        } else if (filter2 != null && !filter2.equals(Filter.INCLUDE)) {
            filter = ff.and(filter, filter2);
        }
        filter = SimplifyingFilterVisitor.simplify(filter);
        Integer start = 0;
        if (firstQuery.getStartIndex() != null) {
            start = firstQuery.getStartIndex();
        }
        if (secondQuery.getStartIndex() != null) {
            start = start + secondQuery.getStartIndex();
        }
        Hints hints = new Hints();
        if (firstQuery.getHints() != null) {
            hints.putAll((Map)firstQuery.getHints());
        }
        if (secondQuery.getHints() != null) {
            hints.putAll((Map)secondQuery.getHints());
        }
        String typeName = firstQuery.getTypeName() != null ? firstQuery.getTypeName() : secondQuery.getTypeName();
        Query mixed = new Query(typeName, filter, maxFeatures, propNames, handle);
        mixed.setVersion(version);
        mixed.setHints(hints);
        if (start != 0) {
            mixed.setStartIndex(start);
        }
        return mixed;
    }

    public static Query simplifyFilter(Query query) {
        if (query == null) {
            return query;
        }
        Filter filter = SimplifyingFilterVisitor.simplify(query.getFilter());
        query.setFilter(filter);
        return query;
    }

    public static Query resolvePropertyNames(Query query, SimpleFeatureType schema) {
        Filter resolved = DataUtilities.resolvePropertyNames(query.getFilter(), schema);
        if (resolved == query.getFilter()) {
            return query;
        }
        Query newQuery = new Query(query);
        newQuery.setFilter(resolved);
        return newQuery;
    }

    public static Filter resolvePropertyNames(Filter filter, SimpleFeatureType schema) {
        if (filter == null || filter == Filter.INCLUDE || filter == Filter.EXCLUDE) {
            return filter;
        }
        return (Filter)filter.accept((FilterVisitor)new PropertyNameResolvingVisitor(schema), null);
    }

    private static List<PropertyName> joinAttributes(List<PropertyName> atts1, List<PropertyName> atts2) {
        if (atts1 == null && atts2 == null) {
            return null;
        }
        LinkedList<PropertyName> atts = new LinkedList<PropertyName>();
        if (atts1 != null) {
            atts.addAll(atts1);
        }
        if (atts2 != null) {
            for (int i = 0; i < atts2.size(); ++i) {
                if (atts.contains(atts2.get(i))) continue;
                atts.add(atts2.get(i));
            }
        }
        return atts;
    }

    public static List<PropertyName> addMandatoryProperties(SimpleFeatureType type, List<PropertyName> oldProps) {
        Iterator ii = type.getDescriptors().iterator();
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        while (ii.hasNext()) {
            PropertyDescriptor descr = (PropertyDescriptor)ii.next();
            PropertyName propName = ff.property(descr.getName());
            if (oldProps != null && oldProps.contains(propName)) {
                properties.add(propName);
                continue;
            }
            if (descr.getMinOccurs() <= 0 || descr.getMaxOccurs() == 0) continue;
            properties.add(propName);
        }
        return properties;
    }

    static AttributeDescriptor createAttribute(String typeSpec) throws SchemaException {
        String type;
        String name;
        int split = typeSpec.indexOf(":");
        String hint = null;
        if (split == -1) {
            name = typeSpec;
            type = "String";
        } else {
            name = typeSpec.substring(0, split);
            int split2 = typeSpec.indexOf(":", split + 1);
            if (split2 == -1) {
                type = typeSpec.substring(split + 1);
            } else {
                type = typeSpec.substring(split + 1, split2);
                hint = typeSpec.substring(split2 + 1);
            }
        }
        try {
            AttributeTypeImpl at;
            Class<?> clazz;
            boolean nillable = true;
            CoordinateReferenceSystem crs = null;
            if (hint != null) {
                StringTokenizer st = new StringTokenizer(hint, ";");
                while (st.hasMoreTokens()) {
                    String h = st.nextToken();
                    if ((h = h.trim()).equals("nillable")) {
                        nillable = true;
                    }
                    if (!h.startsWith("srid=")) continue;
                    String srid = h.split("=")[1];
                    Integer.parseInt(srid);
                    try {
                        crs = CRS.decode((String)("EPSG:" + srid));
                    }
                    catch (Exception e) {
                        String msg = "Error decoding srs: " + srid;
                        throw new SchemaException(msg, (Throwable)e);
                    }
                }
            }
            if (Geometry.class.isAssignableFrom(clazz = DataUtilities.type(type))) {
                at = new GeometryTypeImpl((Name)new NameImpl(name), clazz, crs, false, false, Collections.EMPTY_LIST, null, null);
                return new GeometryDescriptorImpl((GeometryType)at, (Name)new NameImpl(name), 0, 1, nillable, null);
            }
            at = new AttributeTypeImpl((Name)new NameImpl(name), clazz, false, false, Collections.EMPTY_LIST, null, null);
            return new AttributeDescriptorImpl(at, (Name)new NameImpl(name), 0, 1, nillable, null);
        }
        catch (ClassNotFoundException e) {
            throw new SchemaException("Could not type " + name + " as:" + type, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count(FeatureIterator<?> iterator) {
        int count = 0;
        if (iterator != null) {
            try {
                while (iterator.hasNext()) {
                    Feature feature = iterator.next();
                    ++count;
                }
                int n = count;
                return n;
            }
            finally {
                iterator.close();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int count(FeatureCollection<? extends FeatureType, ? extends Feature> collection) {
        int count = 0;
        try (FeatureIterator i = collection.features();){
            while (i.hasNext()) {
                Feature feature = i.next();
                ++count;
            }
            int n = count;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencedEnvelope bounds(FeatureIterator<?> iterator) {
        if (iterator == null) {
            return null;
        }
        try {
            ReferencedEnvelope bounds = null;
            while (iterator.hasNext()) {
                Feature feature = iterator.next();
                ReferencedEnvelope featureEnvelope = null;
                if (feature != null && feature.getBounds() != null) {
                    featureEnvelope = ReferencedEnvelope.reference((BoundingBox)feature.getBounds());
                }
                if (featureEnvelope == null) continue;
                if (bounds == null) {
                    bounds = new ReferencedEnvelope(featureEnvelope);
                    continue;
                }
                bounds.expandToInclude((Envelope)featureEnvelope);
            }
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
        finally {
            iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencedEnvelope bounds(FeatureCollection<? extends FeatureType, ? extends Feature> collection) {
        try (FeatureIterator i = collection.features();){
            CoordinateReferenceSystem crs = collection.getSchema().getCoordinateReferenceSystem();
            ReferencedEnvelope bounds = new ReferencedEnvelope(crs);
            while (i.hasNext()) {
                BoundingBox geomBounds;
                Feature feature = i.next();
                if (feature == null || (geomBounds = feature.getBounds()) == null || geomBounds.isEmpty()) continue;
                bounds.include(geomBounds);
            }
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void visit(FeatureCollection<?, ?> collection, FeatureVisitor visitor, ProgressListener progress) throws IOException {
        float size;
        FeatureIterator iterator = null;
        float f = size = progress != null ? (float)collection.size() : 0.0f;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float position = 0.0f;
            progress.started();
            iterator = collection.features();
            while (!progress.isCanceled() && iterator.hasNext()) {
                Feature feature = null;
                try {
                    feature = iterator.next();
                    visitor.visit(feature);
                    if (!(size > 0.0f)) continue;
                    float f2 = position;
                    position = f2 + 1.0f;
                    progress.progress(f2 / size);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                    String fid = feature == null ? "feature" : feature.getIdentifier().toString();
                    throw new IOException("Problem with " + collection.getID() + " visiting " + fid + ":" + erp, erp);
                    return;
                }
            }
        }
        finally {
            progress.complete();
            if (iterator != null) {
                iterator.close();
            }
        }
    }

    public static URL changeUrlExt(URL url, String postfix) throws IllegalArgumentException {
        String a = url.toExternalForm();
        int lastDotPos = a.lastIndexOf(46);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        a = a + "." + postfix;
        try {
            return new URL(a);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("can't create a new URL for " + url + " with new extension " + postfix, e);
        }
    }

    public static URL getParentUrl(URL url) throws MalformedURLException {
        String a = url.toExternalForm();
        int lastDotPos = a.lastIndexOf(47);
        if (lastDotPos >= 0) {
            a = a.substring(0, lastDotPos);
        }
        if (a.endsWith("!")) {
            a = a + "/";
        }
        return new URL(a);
    }

    public static URL extendURL(URL base, String extension) throws MalformedURLException {
        if (base == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"base"));
        }
        if (extension == null) {
            throw new NullPointerException(Errors.format((int)143, (Object)"extension"));
        }
        String a = base.toExternalForm();
        if (!a.endsWith("/")) {
            a = a + "/";
        }
        a = a + extension;
        return new URL(a);
    }

    public static boolean checkFileReadable(File file, Logger logger) {
        if (logger != null && logger.isLoggable(Level.FINE)) {
            StringBuilder builder = new StringBuilder("Checking file:").append(file.getAbsolutePath()).append("\n").append("canRead:").append(file.canRead()).append("\n").append("isHidden:").append(file.isHidden()).append("\n").append("isFile").append(file.isFile()).append("\n").append("canWrite").append(file.canWrite()).append("\n");
            logger.fine(builder.toString());
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static File checkDirectory(File file) throws IllegalArgumentException {
        String directoryPath = file.getPath();
        File inDir = file;
        if (!inDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directoryPath);
        }
        if (!inDir.canRead()) {
            throw new IllegalArgumentException("Not a writable directory: " + directoryPath);
        }
        try {
            directoryPath = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        inDir = new File(directoryPath);
        if (!inDir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + directoryPath);
        }
        if (!inDir.canRead()) {
            throw new IllegalArgumentException("Not a writable directory: " + directoryPath);
        }
        return new File(directoryPath);
    }

    public static boolean canProcess(Map params, DataAccessFactory.Param[] arrayParameters) {
        if (params == null) {
            return false;
        }
        for (int i = 0; i < arrayParameters.length; ++i) {
            List options;
            Object value;
            DataAccessFactory.Param param = arrayParameters[i];
            if (!params.containsKey(param.key)) {
                if (!param.required) continue;
                return false;
            }
            try {
                value = param.lookUp(params);
            }
            catch (IOException e) {
                return false;
            }
            if (value == null) {
                if (!param.required) continue;
                return false;
            }
            if (!param.type.isInstance(value)) {
                return false;
            }
            if (param.metadata == null || !param.metadata.containsKey("options") || (options = (List)param.metadata.get("options")) == null || options.contains(value)) continue;
            return false;
        }
        return true;
    }

    public static FilenameFilter excludeFilters(final FilenameFilter inputFilter, final FilenameFilter ... filters) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (inputFilter.accept(dir, name)) {
                    for (FilenameFilter exclude : filters) {
                        if (!exclude.accept(dir, name)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static FilenameFilter includeFilters(final FilenameFilter inputFilter, final FilenameFilter ... filters) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (inputFilter.accept(dir, name)) {
                    return true;
                }
                for (FilenameFilter include : filters) {
                    if (!include.accept(dir, name)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Feature templateFeature(FeatureType schema) {
        FeatureFactory ff = CommonFactoryFinder.getFeatureFactory(null);
        ArrayList<AttributeImpl> value = new ArrayList<AttributeImpl>();
        for (PropertyDescriptor pd : schema.getDescriptors()) {
            if (!(pd instanceof AttributeDescriptor)) continue;
            if (pd instanceof GeometryDescriptor) {
                value.add(new GeometryAttributeImpl(((AttributeDescriptor)pd).getDefaultValue(), (GeometryDescriptor)pd, null));
                continue;
            }
            value.add(new AttributeImpl(((AttributeDescriptor)pd).getDefaultValue(), (AttributeDescriptor)pd, null));
        }
        return ff.createFeature(value, schema, SimpleFeatureBuilder.createDefaultFeatureId());
    }

    static {
        typeEncode.put(String.class, "String");
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        typeMap.put("\"\"", String.class);
        typeEncode.put(Integer.class, "Integer");
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.class);
        typeMap.put("0", Integer.class);
        typeEncode.put(Double.class, "Double");
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.class);
        typeMap.put("0.0", Double.class);
        typeEncode.put(Float.class, "Float");
        typeMap.put("Float", Float.class);
        typeMap.put("float", Float.class);
        typeMap.put("0.0f", Float.class);
        typeEncode.put(Boolean.class, "Boolean");
        typeMap.put("Boolean", Boolean.class);
        typeMap.put("true", Boolean.class);
        typeMap.put("false", Boolean.class);
        typeEncode.put(UUID.class, "UUID");
        typeMap.put("UUID", UUID.class);
        typeEncode.put(Geometry.class, "Geometry");
        typeMap.put("Geometry", Geometry.class);
        typeEncode.put(Point.class, "Point");
        typeMap.put("Point", Point.class);
        typeEncode.put(LineString.class, "LineString");
        typeMap.put("LineString", LineString.class);
        typeEncode.put(Polygon.class, "Polygon");
        typeMap.put("Polygon", Polygon.class);
        typeEncode.put(MultiPoint.class, "MultiPoint");
        typeMap.put("MultiPoint", MultiPoint.class);
        typeEncode.put(MultiLineString.class, "MultiLineString");
        typeMap.put("MultiLineString", MultiLineString.class);
        typeEncode.put(MultiPolygon.class, "MultiPolygon");
        typeMap.put("MultiPolygon", MultiPolygon.class);
        typeEncode.put(GeometryCollection.class, "GeometryCollection");
        typeMap.put("GeometryCollection", GeometryCollection.class);
        typeEncode.put(Date.class, "Date");
        typeMap.put("Date", Date.class);
        String os = System.getProperty("os.name");
        IS_WINDOWS_OS = os.toUpperCase().contains("WINDOWS");
    }
}

