/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.AbstractTimeBasedModel;

public class SimpleExponentialSmoothingModel
extends AbstractTimeBasedModel {
    private static double DEFAULT_SMOOTHING_CONSTANT_TOLERANCE = 0.001;
    public static final int HUNTER = 1;
    public static final int ROBERTS = 2;
    private double alpha;
    private int approach;

    public static SimpleExponentialSmoothingModel getBestFitModel(DataSet dataSet) {
        return SimpleExponentialSmoothingModel.getBestFitModel(dataSet, DEFAULT_SMOOTHING_CONSTANT_TOLERANCE);
    }

    public static SimpleExponentialSmoothingModel getBestFitModel(DataSet dataSet, double alphaTolerance) {
        SimpleExponentialSmoothingModel model1 = new SimpleExponentialSmoothingModel(0.0);
        SimpleExponentialSmoothingModel model2 = new SimpleExponentialSmoothingModel(0.5);
        SimpleExponentialSmoothingModel model3 = new SimpleExponentialSmoothingModel(1.0);
        return SimpleExponentialSmoothingModel.findBestFit(dataSet, model1, model2, model3, AbstractForecastingModel.TOLERANCE);
    }

    private static SimpleExponentialSmoothingModel findBestFit(DataSet dataSet, SimpleExponentialSmoothingModel modelMin, SimpleExponentialSmoothingModel modelMid, SimpleExponentialSmoothingModel modelMax, double alphaTolerance) {
        double alphaMin = modelMin.getAlpha();
        double alphaMid = modelMid.getAlpha();
        double alphaMax = modelMax.getAlpha();
        if (Math.abs(alphaMid - alphaMin) < alphaTolerance && Math.abs(alphaMax - alphaMid) < alphaTolerance) {
            return modelMid;
        }
        SimpleExponentialSmoothingModel[] model = new SimpleExponentialSmoothingModel[]{modelMin, new SimpleExponentialSmoothingModel((alphaMin + alphaMid) / 2.0), modelMid, new SimpleExponentialSmoothingModel((alphaMid + alphaMax) / 2.0), modelMax};
        int m = 0;
        while (m < 5) {
            model[m].init(dataSet);
            ++m;
        }
        int bestModelIndex = 0;
        int m2 = 1;
        while (m2 < 5) {
            if (model[m2].getMSE() < model[bestModelIndex].getMSE()) {
                bestModelIndex = m2;
            }
            ++m2;
        }
        switch (bestModelIndex) {
            case 1: {
                model[3] = null;
                model[4] = null;
                return SimpleExponentialSmoothingModel.findBestFit(dataSet, model[0], model[1], model[2], alphaTolerance);
            }
            case 2: {
                model[0] = null;
                model[4] = null;
                return SimpleExponentialSmoothingModel.findBestFit(dataSet, model[1], model[2], model[3], alphaTolerance);
            }
            case 3: {
                model[0] = null;
                model[1] = null;
                return SimpleExponentialSmoothingModel.findBestFit(dataSet, model[2], model[3], model[4], alphaTolerance);
            }
        }
        int m3 = 0;
        while (m3 < 5) {
            if (m3 != bestModelIndex) {
                model[m3] = null;
            }
            ++m3;
        }
        return model[bestModelIndex];
    }

    public SimpleExponentialSmoothingModel(double alpha) {
        this(alpha, 1);
    }

    public SimpleExponentialSmoothingModel(String independentVariable, double alpha) {
        this(independentVariable, alpha, 1);
    }

    public SimpleExponentialSmoothingModel(double alpha, int approach) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("SimpleExponentialSmoothingModel: Invalid smoothing constant, " + alpha + " - must be in the range 0.0-1.0.");
        }
        this.alpha = alpha;
        this.approach = approach;
    }

    public SimpleExponentialSmoothingModel(String independentVariable, double alpha, int approach) {
        super(independentVariable);
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("SimpleExponentialSmoothingModel: Invalid smoothing constant, " + alpha + " - must be in the range 0.0-1.0.");
        }
        this.alpha = alpha;
        this.approach = approach;
    }

    protected double forecast(double timeValue) throws IllegalArgumentException {
        double forecast;
        if (timeValue - this.getMinimumTimeValue() < AbstractForecastingModel.TOLERANCE) {
            return this.getObservedValue(timeValue);
        }
        double previousTime = timeValue - this.getTimeInterval();
        try {
            forecast = this.approach == 2 ? this.alpha * this.getObservedValue(timeValue) + (1.0 - this.alpha) * this.getForecastValue(previousTime) : this.alpha * this.getObservedValue(previousTime) + (1.0 - this.alpha) * this.getForecastValue(previousTime);
        }
        catch (IllegalArgumentException iaex) {
            if (timeValue > this.getMaximumTimeValue() - AbstractForecastingModel.TOLERANCE) {
                return this.getForecastValue(this.getMaximumTimeValue());
            }
            throw iaex;
        }
        return forecast;
    }

    protected int getNumberOfPeriods() {
        return 1;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public String getForecastType() {
        return "simple exponential smoothing";
    }

    public String toString() {
        return "Simple exponential smoothing model (using " + (this.approach == 2 ? "Roberts" : "Hunters") + " formula), with a smoothing constant of " + this.alpha + " and using an independent variable of " + this.getIndependentVariable();
    }

    static {
        HUNTER = 1;
        ROBERTS = 2;
    }
}

