/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.input;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.input.AbstractBuilder;

public class ResultSetBuilder
extends AbstractBuilder {
    private ResultSet rs;

    public ResultSetBuilder(ResultSet resultSet) {
        this.rs = resultSet;
    }

    public DataSet build() throws SQLException {
        DataSet dataSet = new DataSet();
        this.setColumnNames();
        if (!this.rs.isBeforeFirst()) {
            this.rs.beforeFirst();
        }
        while (this.rs.next()) {
            DataPoint dp = this.build(this.rs);
            dataSet.add(dp);
        }
        return dataSet;
    }

    private DataPoint build(ResultSet rs) throws SQLException {
        Observation dataPoint = new Observation(0.0);
        int n = this.getNumberOfVariables();
        int column = 0;
        while (column < n) {
            double value = rs.getDouble(column);
            if (column == n) {
                dataPoint.setDependentValue(value);
            } else {
                dataPoint.setIndependentValue(this.getVariableName(column), value);
            }
            ++column;
        }
        return dataPoint;
    }

    private void setColumnNames() throws SQLException {
        ResultSetMetaData metaData = this.rs.getMetaData();
        int n = metaData.getColumnCount() - 1;
        int column = 0;
        while (column < n) {
            this.setVariableName(column, metaData.getColumnLabel(column));
            ++column;
        }
    }
}

