/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.Observation;

public class DataSet
implements Collection {
    private Collection dataPoints = new ArrayList();
    private String timeVariable;
    private int periodsPerYear;

    public DataSet() {
        this.timeVariable = null;
        this.periodsPerYear = 0;
    }

    public DataSet(DataSet dataSet) {
        this(dataSet.getTimeVariable(), dataSet.getPeriodsPerYear(), dataSet.dataPoints);
    }

    public DataSet(String timeVariable, int periodsPerYear, Collection c) {
        this.timeVariable = timeVariable;
        this.periodsPerYear = periodsPerYear;
        this.addAll(c);
    }

    public boolean add(Object obj) {
        if (obj == null) {
            throw new NullPointerException("DataSet does not support addition of null DataPoints");
        }
        return this.dataPoints.add(new Observation((DataPoint)obj));
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add((DataPoint)it.next());
        }
        return true;
    }

    public void clear() {
        this.dataPoints.clear();
    }

    public boolean isEmpty() {
        return this.dataPoints.isEmpty();
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            throw new NullPointerException("DataSet does not support null DataPoint objects");
        }
        DataPoint dataPoint = (DataPoint)obj;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            if (!dataPoint.equals(dp)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) throws ClassCastException, NullPointerException {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            if (this.contains(dp)) continue;
            return false;
        }
        return true;
    }

    public boolean remove(Object obj) {
        if (obj == null) {
            throw new NullPointerException("DataSet does not support null DataPoint objects");
        }
        return this.dataPoints.remove((DataPoint)obj);
    }

    public int size() {
        return this.dataPoints.size();
    }

    public Iterator iterator() {
        return this.dataPoints.iterator();
    }

    public void sort(String independentVariable) {
        TreeMap<Double, DataPoint> sortedMap = new TreeMap<Double, DataPoint>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Double)o1).compareTo((Double)o2);
            }
        });
        Iterator it = this.dataPoints.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            sortedMap.put(new Double(dp.getIndependentValue(independentVariable)), dp);
        }
        this.dataPoints.clear();
        this.dataPoints.addAll(sortedMap.values());
    }

    public String[] getIndependentVariables() {
        int i;
        String[] names;
        ArrayList<String> variables = new ArrayList<String>();
        Iterator it = this.dataPoints.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            names = dp.getIndependentVariableNames();
            i = 0;
            while (i < names.length) {
                if (!variables.contains(names[i])) {
                    variables.add(names[i]);
                }
                ++i;
            }
        }
        Collections.sort(variables);
        int count = variables.size();
        names = new String[count];
        i = 0;
        while (i < count) {
            names[i] = (String)variables.get(i);
            ++i;
        }
        return names;
    }

    public Object[] toArray() {
        return this.dataPoints.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.dataPoints.toArray(a);
    }

    public void setTimeVariable(String timeVariable) {
        this.timeVariable = timeVariable;
    }

    public String getTimeVariable() {
        return this.timeVariable;
    }

    public void setPeriodsPerYear(int periodsPerYear) {
        if (periodsPerYear < 1) {
            throw new IllegalArgumentException("periodsPerYear parameter must be at least 1");
        }
        this.periodsPerYear = periodsPerYear;
    }

    public int getPeriodsPerYear() {
        return this.periodsPerYear;
    }

    public boolean removeAll(Collection c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("DataSet.removeAll not yet supported");
    }

    public boolean retainAll(Collection c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("DataSet.retainAll not yet supported");
    }

    public int hashCode() {
        return this.dataPoints.size() * 100 + this.getIndependentVariables().length;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        return this.equals((DataSet)obj);
    }

    public boolean equals(DataSet dataSet) {
        if (dataSet == null) {
            return false;
        }
        if (this.size() != dataSet.size()) {
            return false;
        }
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            DataPoint dataPoint = (DataPoint)it.next();
            if (this.contains(dataPoint)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        String result = "( " + lineSeparator;
        Iterator it = this.dataPoints.iterator();
        while (it.hasNext()) {
            result = result + "  " + ((DataPoint)it.next()).toString() + lineSeparator;
        }
        return result + ")";
    }
}

