/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.impl.hash;

import gnu.trove.impl.HashFunctions;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.procedure.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class TLongLongHash
extends TPrimitiveHash {
    public transient long[] _set;
    protected long no_entry_key;
    protected long no_entry_value;

    public TLongLongHash() {
        this.no_entry_key = 0L;
        this.no_entry_value = 0L;
    }

    public TLongLongHash(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_key = 0L;
        this.no_entry_value = 0L;
    }

    public TLongLongHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = 0L;
        this.no_entry_value = 0L;
    }

    public TLongLongHash(int initialCapacity, float loadFactor, long no_entry_key, long no_entry_value) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = no_entry_key;
        this.no_entry_value = no_entry_value;
    }

    public long getNoEntryKey() {
        return this.no_entry_key;
    }

    public long getNoEntryValue() {
        return this.no_entry_value;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TLongProcedure procedure) {
        byte[] states = this._states;
        long[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public void removeAt(int index) {
        this._set[index] = this.no_entry_key;
        super.removeAt(index);
    }

    protected int index(long key) {
        byte[] states = this._states;
        long[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != key)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != key));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(long key) {
        byte[] states = this._states;
        long[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == key) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states[index] != 2) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] == 1 && set[index] != key);
        }
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != key)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeLong(this.no_entry_key);
        out.writeLong(this.no_entry_value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.no_entry_key = in.readLong();
        this.no_entry_value = in.readLong();
    }
}

