/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.jogamp.common.nio.Buffers;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import saf.v3d.AppearanceFactory;
import saf.v3d.Canvas2D;
import saf.v3d.CanvasListener;
import saf.v3d.ShapeFactory2D;
import saf.v3d.grid.GridColorMap;
import saf.v3d.grid.GridMesh;
import saf.v3d.picking.PickEvent;
import saf.v3d.picking.PickListener;
import saf.v3d.render.DisplayListRenderer;
import saf.v3d.render.PolygonShape;
import saf.v3d.scene.Label;
import saf.v3d.scene.Position;
import saf.v3d.scene.TextureLayer;
import saf.v3d.scene.VComposite;
import saf.v3d.scene.VEdge2D;
import saf.v3d.scene.VEdgeLayer;
import saf.v3d.scene.VImage2D;
import saf.v3d.scene.VLabelLayer;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VNode;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VShape;
import saf.v3d.scene.VSpatial;

public class Test2D {
    private static int EDGE_COUNT = 50;

    public void run() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        final Canvas2D canvas = new Canvas2D();
        final Display2D d2d = new Display2D(canvas.getShapeFactory());
        canvas.addCanvasListener(d2d);
        canvas.addPickListener(d2d);
        frame.add((Component)canvas.getPanel(), "Center");
        JPanel buttonPanel = new JPanel();
        JButton button = new JButton("run");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (d2d.colorMap.flag == 0) {
                    d2d.colorMap.flag = 1;
                } else if (d2d.colorMap.flag == 1) {
                    d2d.colorMap.flag = 0;
                }
                d2d.grid.update();
                canvas.update();
            }
        });
        frame.add((Component)buttonPanel, "North");
        buttonPanel.add(button);
        button = new JButton("New Frame");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFrame aFrame = new JFrame();
                aFrame.setLayout(new BorderLayout());
                aFrame.setDefaultCloseOperation(3);
                aFrame.add((Component)canvas.getPanel(), "Center");
                aFrame.setSize(800, 800);
                aFrame.setVisible(true);
            }
        });
        buttonPanel.add(button);
        button = new JButton("Image");
        buttonPanel.add(button);
        frame.setSize(800, 800);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        new Test2D().run();
    }

    public static class Display2D
    implements CanvasListener,
    PickListener {
        boolean added = false;
        List<VSpatial> items = new ArrayList<VSpatial>();
        List<VEdge2D> edges = new ArrayList<VEdge2D>();
        GLAutoDrawable drawable;
        TestColorMap colorMap;
        GridMesh grid;
        ShapeFactory2D shapeFactory;

        public Display2D(ShapeFactory2D fac) {
            this.shapeFactory = fac;
        }

        @Override
        public void init(GLAutoDrawable drawable, VRoot root) {
            this.drawable = drawable;
        }

        public void run() {
            long start = new Date().getTime();
            int i = 0;
            while (i < 100) {
                Random rnd = new Random();
                for (VSpatial spatial : this.items) {
                    int x = (int)Math.round(Math.random() * 49.0);
                    int y = (int)Math.round(Math.random() * 49.0);
                    spatial.translate(x * 10 + 4, y * 10 + 4, 0.0f);
                }
                VComposite root = this.edges.get(0).getParent();
                int j = 0;
                while (j < EDGE_COUNT) {
                    VEdge2D edge = this.edges.get(rnd.nextInt(this.edges.size()));
                    root.removeChild(edge);
                    this.edges.remove(edge);
                    ++j;
                }
                j = 0;
                while (j < EDGE_COUNT) {
                    int index = rnd.nextInt(this.items.size());
                    VSpatial source = this.items.get(index);
                    int tIndex = rnd.nextInt(this.items.size());
                    while (index == tIndex) {
                        tIndex = rnd.nextInt(this.items.size());
                    }
                    VSpatial target = this.items.get(tIndex);
                    VEdge2D edge = new VEdge2D(source, target, true);
                    edge.putProperty("ID", "EDGE " + j);
                    root.addChild(edge);
                    this.edges.add(edge);
                    ++j;
                }
                this.drawable.display();
                ++i;
            }
            long delta = new Date().getTime() - start;
            System.out.printf("Elapsed time: %d seconds%n", delta /= 1000L);
            System.out.printf("DPS: %d%n", 1000L / delta);
        }

        private Shape createRectTri() {
            float[] rect = new float[]{-75.0f, -75.0f, 75.0f, -75.0f, 75.0f, 75.0f, -75.0f, 75.0f};
            float[] tri = new float[]{-50.0f, -50.0f, 0.0f, 50.0f, 50.0f, -50.0f};
            Path2D.Float shape = new Path2D.Float(0);
            shape.moveTo(rect[0], rect[1]);
            shape.lineTo(rect[2], rect[3]);
            shape.lineTo(rect[4], rect[5]);
            shape.lineTo(rect[6], rect[7]);
            shape.closePath();
            shape.moveTo(tri[0], tri[1]);
            shape.lineTo(tri[2], tri[3]);
            shape.lineTo(tri[4], tri[5]);
            shape.closePath();
            return shape;
        }

        private Shape getStar() {
            float[] star = new float[]{250.0f, 50.0f, 325.0f, 200.0f, 400.0f, 50.0f, 250.0f, 150.0f, 400.0f, 150.0f};
            Path2D.Float shape = new Path2D.Float(0);
            shape.moveTo(star[0], star[1]);
            shape.lineTo(star[2], star[3]);
            shape.lineTo(star[4], star[5]);
            shape.lineTo(star[6], star[7]);
            shape.lineTo(star[8], star[9]);
            shape.closePath();
            return shape;
        }

        private FloatBuffer getQuads() {
            float[] data = new float[]{10.0f, 10.0f, 0.0f, 20.0f, 10.0f, 0.0f, 20.0f, 50.0f, 0.0f, 10.0f, 50.0f, 0.0f, 20.0f, 12.0f, 0.0f, 40.0f, 12.0f, 0.0f, 40.0f, 48.0f, 0.0f, 20.0f, 48.0f, 0.0f};
            FloatBuffer buf = Buffers.newDirectFloatBuffer((int)24);
            buf.put(data);
            return buf;
        }

        private FloatBuffer getQuadStrip() {
            float[] data = new float[]{10.0f, 10.0f, 0.0f, 10.0f, 50.0f, 0.0f, 40.0f, 10.0f, 0.0f, 45.0f, 51.0f, 0.0f, 60.0f, 12.0f, 0.0f, 58.0f, 60.0f, 0.0f};
            FloatBuffer buf = Buffers.newDirectFloatBuffer((int)18);
            buf.put(data);
            return buf;
        }

        private Shape getLines() {
            Path2D.Float shape = new Path2D.Float();
            shape.moveTo(-5.0f, -5.0f);
            shape.lineTo(5.0f, 5.0f);
            shape.lineTo(15.0f, 25.0f);
            shape.moveTo(10.0f, -5.0f);
            shape.lineTo(-20.0f, 20.0f);
            return shape;
        }

        @Override
        public void reshape(GLAutoDrawable drawable, float width, float height, VRoot root) {
            if (!this.added) {
                try {
                    VLabelLayer layers = new VLabelLayer(new JLabel().getFont());
                    VLayer layer = new VLayer();
                    root.addChild(layer);
                    this.colorMap = new TestColorMap();
                    this.grid = new GridMesh(2, 3, 20.0f, this.colorMap);
                    VShape aGrid = new VShape(this.grid);
                    layer.addChild(aGrid);
                    aGrid.translate(0.0f, 400.0f, 0.0f);
                    DisplayListRenderer renderer = new DisplayListRenderer(this.getQuads(), 7);
                    VShape quads = new VShape(new PolygonShape(renderer));
                    layer.addChild(quads);
                    quads.translate(600.0f, 600.0f, 0.0f);
                    renderer = new DisplayListRenderer(this.getQuadStrip(), 8);
                    quads = new VShape(new PolygonShape(renderer));
                    layer.addChild(quads);
                    quads.translate(400.0f, 400.0f, 0.0f);
                    VShape line = this.shapeFactory.createShape(this.getLines());
                    line.translate(10.0f, 10.0f, 0.0f);
                    line.putProperty("ID", "LINES");
                    layer.addChild(line);
                    VShape jShape = this.shapeFactory.createShape(this.getStar());
                    jShape.putProperty("ID", "STAR SHAPE");
                    layer.addChild(jShape);
                    jShape.translate(100.0f, 400.0f, 0.0f);
                    jShape.setBorderStrokeSize(5);
                    jShape.setBorderColor(Color.CYAN);
                    Rectangle2D.Float shape = new Rectangle2D.Float(-10.0f, -15.0f, 20.0f, 30.0f);
                    jShape = this.shapeFactory.createShape(shape);
                    layer.addChild(jShape);
                    jShape.translate(100.0f, 100.0f, 0.0f);
                    jShape = this.shapeFactory.createShape(this.createRectTri());
                    layer.addChild(jShape);
                    jShape.translate(200.0f, 400.0f, 0.0f);
                    jShape.rotate2D(45.0f);
                    Position position = Position.SOUTH_WEST;
                    VShape circle = this.shapeFactory.createCircle(18.0f, 16);
                    circle.putProperty("ID", "CIRCLE");
                    layer.addChild(circle);
                    circle.translate(50.0f, 40.0f, 0.0f);
                    circle.setAppearance(AppearanceFactory.createColorAppearance(new Color(255, 0, 0, 128)));
                    layers.addLabel(new Label("Circle", circle, position));
                    VNode compNode = new VNode(this.shapeFactory.createRectangle(40, 40));
                    Color red = new Color(255, 0, 0, 128);
                    compNode.setAppearance(AppearanceFactory.createColorAppearance(red));
                    VShape child = this.shapeFactory.createCircle(10.0f, 16);
                    compNode.addChild(child);
                    child.translate(30.0f, 30.0f, 0.0f);
                    layer.addChild(compNode);
                    compNode.scale(2.0f);
                    compNode.translate(200.0f, 600.0f, 0.0f);
                    compNode.putProperty("ID", "COMP_NODE");
                    TextureLayer textureLayer = new TextureLayer();
                    String path = "./test/test/bookmark.png";
                    VImage2D sprite = this.shapeFactory.createImage(path);
                    sprite.putProperty("ID", "STAR 1");
                    sprite.scale(2.0f);
                    sprite.translate(300.0f, 300.0f, 0.0f);
                    textureLayer.addChild(sprite);
                    layers.addLabel(new Label("Star 1", sprite, position));
                    VImage2D sprite2 = this.shapeFactory.createImage(path, 0.5f);
                    sprite2.putProperty("ID", "STAR 2");
                    sprite2.translate(500.0f, 100.0f, 0.0f);
                    textureLayer.addChild(sprite2);
                    layers.addLabel(new Label("Star 2", sprite2, position));
                    VImage2D lockImg = this.shapeFactory.createImage("./test/test/zombie.png");
                    lockImg.putProperty("ID", "LOCK");
                    lockImg.translate(10.0f, 250.0f, 0.0f);
                    textureLayer.addChild(lockImg);
                    root.addChild(textureLayer);
                    VEdgeLayer edgeLayer = new VEdgeLayer();
                    VEdge2D edge = new VEdge2D(sprite, sprite2, true);
                    edge.putProperty("ID", "EDGE");
                    edgeLayer.addChild(edge);
                    edge = new VEdge2D(circle, jShape, true);
                    edgeLayer.addChild(edge);
                    edge = new VEdge2D(compNode, circle, true);
                    edge.setAppearance(AppearanceFactory.createColorAppearance(Color.green));
                    edgeLayer.addChild(edge);
                    layer.addChild(edgeLayer);
                    root.addChild(layers);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                Color color = Color.RED;
                int i = 0;
                while (i < 3000) {
                    if (i == 1000) {
                        color = Color.BLUE;
                    }
                    if (i == 2000) {
                        color = Color.GREEN;
                    }
                    int x = (int)Math.round(Math.random() * 49.0);
                    int y = (int)Math.round(Math.random() * 49.0);
                    VShape circle = this.shapeFactory.createCircle(4.0f, 16);
                    circle.setBorderStrokeSize(2);
                    circle.putProperty("ID", i);
                    circle.setAppearance(AppearanceFactory.createColorAppearance(color));
                    circle.translate(x * 10 + 4, y * 10 + 4, 0.0f);
                    this.items.add(circle);
                    ++i;
                }
                Random rnd = new Random();
                int i2 = 0;
                while (i2 < EDGE_COUNT) {
                    int index = rnd.nextInt(this.items.size());
                    VSpatial source = this.items.get(index);
                    int tIndex = rnd.nextInt(this.items.size());
                    while (index == tIndex) {
                        tIndex = rnd.nextInt(this.items.size());
                    }
                    VSpatial target = this.items.get(tIndex);
                    VEdge2D edge = new VEdge2D(source, target, true);
                    edge.putProperty("ID", "EDGE " + i2);
                    this.edges.add(edge);
                    ++i2;
                }
                this.added = true;
            }
        }

        @Override
        public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
        }

        @Override
        public void dispose(GLAutoDrawable drawable) {
        }

        @Override
        public void pickPerformed(PickEvent evt) {
            System.out.println(evt);
            for (VSpatial node : evt.getPicked()) {
                System.out.println(node.getProperty("ID"));
            }
        }
    }

    public static class TestColorMap
    implements GridColorMap {
        int flag = 0;

        @Override
        public void getColor(int x, int y, Color3f color) {
            System.out.printf("x: %d, y: %d%n", x, y);
            if (this.flag == 0) {
                if (y == 0) {
                    if (x == 0) {
                        color.set(Color.RED);
                    } else if (x == 1) {
                        color.set(Color.GREEN);
                    } else if (x == 2) {
                        color.set(Color.BLUE);
                    } else {
                        color.set(Color.GRAY);
                    }
                } else if (x == 0) {
                    color.set(Color.BLUE);
                } else if (x == 1) {
                    color.set(Color.PINK);
                } else if (x == 2) {
                    color.set(Color.CYAN);
                } else {
                    color.set(Color.GRAY);
                }
            } else if (y == 1) {
                if (x == 0) {
                    color.set(Color.RED);
                } else if (x == 1) {
                    color.set(Color.GREEN);
                } else if (x == 2) {
                    color.set(Color.BLUE);
                } else {
                    color.set(Color.GRAY);
                }
            } else if (x == 0) {
                color.set(Color.BLUE);
            } else if (x == 1) {
                color.set(Color.PINK);
            } else if (x == 2) {
                color.set(Color.CYAN);
            } else {
                color.set(Color.GRAY);
            }
        }
    }
}

