/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3f;
import saf.v3d.AppearanceFactory;
import saf.v3d.Canvas2D;
import saf.v3d.CanvasListener;
import saf.v3d.ShapeFactory2D;
import saf.v3d.picking.PickEvent;
import saf.v3d.picking.PickListener;
import saf.v3d.scene.TextureLayer;
import saf.v3d.scene.VLayer;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VShape;
import saf.v3d.scene.VSpatial;

public class TabbedPanelTests {
    public void run() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        final JTabbedPane tabs = new JTabbedPane();
        frame.add((Component)tabs, "Center");
        Canvas2D canvas = new Canvas2D();
        Display2D d2d = new Display2D(canvas.getShapeFactory());
        canvas.addCanvasListener(d2d);
        canvas.addPickListener(d2d);
        tabs.add("Display 1", canvas.getPanel());
        Canvas2D canvas2 = new Canvas2D();
        Display2D d2d2 = new Display2D(canvas2.getShapeFactory());
        d2d2.showCircle = true;
        canvas2.addCanvasListener(d2d2);
        canvas2.addPickListener(d2d2);
        tabs.add("Display 2", canvas2.getPanel());
        tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component comp = tabs.getSelectedComponent();
            }
        });
        frame.setSize(800, 800);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new TabbedPanelTests().run();
            }
        });
    }

    public static class Display2D
    implements CanvasListener,
    PickListener {
        ShapeFactory2D shapeFactory;
        GLAutoDrawable drawable;
        boolean added = false;
        boolean showCircle = false;

        public Display2D(ShapeFactory2D fac) {
            this.shapeFactory = fac;
        }

        @Override
        public void pickPerformed(PickEvent evt) {
        }

        @Override
        public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
        }

        @Override
        public void init(GLAutoDrawable drawable, VRoot root) {
            this.drawable = drawable;
        }

        @Override
        public void reshape(GLAutoDrawable drawable, float width, float height, VRoot root) {
            System.out.println("reshape " + (this.showCircle ? "circle" : "star"));
            if (!this.added) {
                VLayer layer = new VLayer();
                root.addChild(layer);
                if (this.showCircle) {
                    VShape circle = this.shapeFactory.createCircle(18.0f, 16);
                    circle.putProperty("ID", "CIRCLE");
                    layer.addChild(circle);
                    circle.translate(50.0f, 40.0f, 0.0f);
                    circle.setAppearance(AppearanceFactory.createColorAppearance(new Color(255, 0, 0, 128)));
                } else {
                    VShape jShape = this.shapeFactory.createShape(this.getStar());
                    jShape.putProperty("ID", "STAR SHAPE");
                    layer.addChild(jShape);
                    jShape.translate(100.0f, 400.0f, 0.0f);
                    jShape.setBorderStrokeSize(5);
                    jShape.setBorderColor(Color.CYAN);
                    try {
                        TextureLayer texLayer = new TextureLayer();
                        root.addChild(texLayer);
                        BufferedImage img = ImageIO.read(new File("./test/test/zombie.png"));
                        this.shapeFactory.registerImage("zombie", img);
                        VSpatial zombie = this.shapeFactory.getNamedSpatial("zombie");
                        texLayer.addChild(zombie);
                        zombie.translate(10.0f, 10.0f, 0.0f);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                this.added = true;
            }
        }

        private Shape getStar() {
            float[] star = new float[]{250.0f, 50.0f, 325.0f, 200.0f, 400.0f, 50.0f, 250.0f, 150.0f, 400.0f, 150.0f};
            Path2D.Float shape = new Path2D.Float(0);
            shape.moveTo(star[0], star[1]);
            shape.lineTo(star[2], star[3]);
            shape.lineTo(star[4], star[5]);
            shape.lineTo(star[6], star[7]);
            shape.lineTo(star[8], star[9]);
            shape.closePath();
            return shape;
        }

        @Override
        public void dispose(GLAutoDrawable drawable) {
        }
    }
}

