/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import test.Line;

public class OGLExp {
    private static final int LINE_COUNT = 20000;
    private GLCanvas canvas;
    private List<Line> lines = new ArrayList<Line>();
    private JButton button = new JButton("Go");

    public OGLExp() {
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        GLProfile gp = GLProfile.get((String)"GL2");
        GLCapabilities caps = new GLCapabilities(gp);
        caps.setSampleBuffers(true);
        caps.setNumSamples(4);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)caps);
        this.canvas.addGLEventListener((GLEventListener)new ExpEvtListener());
        this.canvas.setAutoSwapBufferMode(false);
        frame.setLayout(new BorderLayout());
        frame.add((Component)this.canvas, "Center");
        frame.setSize(new Dimension(800, 800));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OGLExp.this.run();
            }
        });
        frame.add((Component)this.button, "North");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                frame.setVisible(true);
            }
        });
    }

    private void run() {
        this.lines.clear();
        int i = 0;
        while (i < 20000) {
            this.lines.add(new Line(this.canvas.getWidth(), this.canvas.getHeight()));
            ++i;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                long start = new Date().getTime();
                int i = 0;
                while (i < 100) {
                    for (Line line : OGLExp.this.lines) {
                        line.update();
                    }
                    OGLExp.this.canvas.display();
                    ++i;
                }
                long duration = new Date().getTime() - start;
                System.out.printf("Duration: %f%n", Float.valueOf((float)duration / 1000.0f));
            }
        });
    }

    public static void main(String[] args) {
        new OGLExp();
    }

    class ExpEvtListener
    implements GLEventListener {
        int vboIndex;
        int colorIndex;

        ExpEvtListener() {
        }

        public void display(GLAutoDrawable drawable) {
            GL2 gl = drawable.getGL().getGL2();
            gl.glClear(16384);
            gl.glLoadIdentity();
            gl.glColor3f(1.0f, 0.0f, 0.0f);
            if (OGLExp.this.lines.size() > 0) {
                HashMap map = new HashMap();
                ArrayList<Line> ones = new ArrayList<Line>();
                for (Line line : OGLExp.this.lines) {
                    float val = line.getWidth();
                    if ((double)val == 1.0) {
                        ones.add(line);
                        continue;
                    }
                    ArrayList<Line> list = (ArrayList<Line>)map.get(Float.valueOf(val));
                    if (list == null) {
                        list = new ArrayList<Line>();
                        map.put(Float.valueOf(val), list);
                    }
                    list.add(line);
                }
                map.put(Float.valueOf(1.0f), ones);
                gl.glBindBuffer(34962, this.vboIndex);
                ByteBuffer buf = gl.glMapBuffer(34962, 35001);
                buf.position(0);
                for (List list : map.values()) {
                    for (Line line : list) {
                        line.vboDraw(gl, buf);
                    }
                }
                gl.glUnmapBuffer(34962);
                gl.glVertexPointer(2, 5126, 20, 0L);
                gl.glColorPointer(3, 5126, 20, 8L);
                gl.glEnableClientState(32884);
                gl.glEnableClientState(32886);
                int start = 0;
                for (Map.Entry vals : map.entrySet()) {
                    gl.glLineWidth(1.0f);
                    int end = ((List)vals.getValue()).size() * 2;
                    gl.glDrawArrays(1, start, end);
                    start = end;
                }
                gl.glDisableClientState(32886);
                gl.glDisableClientState(32884);
                gl.glBindBuffer(34962, 0);
            }
            drawable.swapBuffers();
        }

        public void dispose(GLAutoDrawable arg0) {
        }

        public void init(GLAutoDrawable drawable) {
            System.out.println("init");
            GL2 gl = drawable.getGL().getGL2();
            gl.setSwapInterval(0);
            gl.glClearColor(1.0f, 1.0f, 1.0f, 0.0f);
            gl.glDisable(2929);
            int[] indices = new int[1];
            gl.glGenBuffers(1, indices, 0);
            this.vboIndex = indices[0];
            gl.glBindBuffer(34962, this.vboIndex);
            gl.glBufferData(34962, 800000L, null, 35040);
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            System.out.println("reshape");
            GL2 gl = drawable.getGL().getGL2();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
            gl.glMatrixMode(5888);
            gl.glPushMatrix();
            gl.glLoadIdentity();
            gl.glTranslatef(0.375f, 0.375f, 0.0f);
            gl.glDisable(2929);
            gl.glDisable(2896);
        }
    }
}

