/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.media.opengl.GLAutoDrawable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3f;
import saf.v3d.Canvas2D;
import saf.v3d.CanvasListener;
import saf.v3d.ShapeFactory2D;
import saf.v3d.picking.PickEvent;
import saf.v3d.picking.PickListener;
import saf.v3d.scene.Label;
import saf.v3d.scene.Position;
import saf.v3d.scene.VLabelLayer;
import saf.v3d.scene.VRoot;
import saf.v3d.scene.VShape;
import saf.v3d.scene.VSpatial;

public class DynamicTest2D {
    public void run() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLayout(new BorderLayout());
        final Canvas2D canvas = new Canvas2D();
        final Display2D d2d = new Display2D(canvas.getShapeFactory());
        canvas.addCanvasListener(d2d);
        canvas.addPickListener(d2d);
        frame.add((Component)canvas.getPanel(), "Center");
        JPanel buttonPanel = new JPanel();
        frame.add((Component)buttonPanel, "North");
        JButton button = new JButton("run");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Date start = new Date();
                int i = 0;
                while (i < 400) {
                    d2d.run();
                    canvas.update();
                    ++i;
                }
                Date end = new Date();
                double seconds = (double)(end.getTime() - start.getTime()) / 1000.0;
                System.out.println(seconds);
            }
        });
        buttonPanel.add(button);
        frame.setSize(800, 800);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DynamicTest2D().run();
            }
        });
    }

    public static class Display2D
    implements CanvasListener,
    PickListener {
        GLAutoDrawable drawable;
        boolean added = false;
        ShapeFactory2D shapeFactory;
        List<VSpatial> spatials = new ArrayList<VSpatial>();

        public Display2D(ShapeFactory2D shapeFactory) {
            this.shapeFactory = shapeFactory;
        }

        public void run() {
            int width = this.drawable.getSurfaceWidth();
            int height = this.drawable.getSurfaceHeight();
            for (VSpatial spatial : this.spatials) {
                spatial.translate((float)(Math.random() * (double)width), (float)(Math.random() * (double)height), 0.0f);
            }
        }

        @Override
        public void init(GLAutoDrawable drawable, VRoot root) {
            this.drawable = drawable;
        }

        @Override
        public void reshape(GLAutoDrawable drawable, float width, float height, VRoot root) {
            if (!this.added) {
                VLabelLayer layers = new VLabelLayer(new JLabel().getFont());
                Position position = Position.SOUTH;
                int i = 0;
                while (i < 400) {
                    VShape circle = this.shapeFactory.createCircle(4.0f, 16);
                    circle.putProperty("ID", "CIRCLE " + i);
                    circle.scale(4.0f);
                    root.addChild(circle);
                    circle.translate((float)(Math.random() * (double)width), (float)(Math.random() * (double)height), 0.0f);
                    layers.addLabel(new Label("Circle " + i, circle, position));
                    this.spatials.add(circle);
                    ++i;
                }
                root.addChild(layers);
                this.added = true;
            }
        }

        @Override
        public void vSpatialMoved(VSpatial spatial, Point3f localTrans) {
        }

        @Override
        public void dispose(GLAutoDrawable drawable) {
        }

        @Override
        public void pickPerformed(PickEvent evt) {
            System.out.println(evt);
            for (VSpatial node : evt.getPicked()) {
                System.out.println(node.getProperty("ID"));
            }
        }
    }
}

