/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.util;

import com.jogamp.common.nio.Buffers;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.glu.GLU;
import javax.media.opengl.glu.GLUtessellator;
import javax.media.opengl.glu.GLUtessellatorCallback;
import javax.media.opengl.glu.GLUtessellatorCallbackAdapter;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import saf.v3d.render.DisplayListRenderer;
import saf.v3d.render.PolygonRenderer;
import saf.v3d.render.RenderData;
import saf.v3d.util.BezierCurveTessellator;
import saf.v3d.util.GLUErrors;

public class Tessellator {
    private GLUtessellator tess = GLU.gluNewTess();

    public PolygonRenderer createRenderer(Path2D.Float path) {
        int windingRule = this.getGLUWindingRule(path.getWindingRule());
        GLU.gluTessProperty((GLUtessellator)this.tess, (int)100140, (double)windingRule);
        Callback callback = new Callback();
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100100, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100101, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100103, (GLUtessellatorCallback)callback);
        GLU.gluTessCallback((GLUtessellator)this.tess, (int)100105, (GLUtessellatorCallback)callback);
        ArrayList<Contour> contours = new ArrayList<Contour>();
        Contour contour = new Contour();
        float[] coords = new float[6];
        Point3f lastPoint = new Point3f();
        PathIterator iter = path.getPathIterator(null);
        while (!iter.isDone()) {
            int ret = iter.currentSegment(coords);
            if (ret == 0 || ret == 1) {
                contour.addVertex(coords[0], coords[1], 0.0f);
                lastPoint.set(coords[0], coords[1], 0.0f);
            } else if (ret == 3) {
                Point3f b = new Point3f(coords[0], coords[1], 0.0f);
                Point3f c = new Point3f(coords[2], coords[3], 0.0f);
                Point3f d = new Point3f(coords[4], coords[5], 0.0f);
                float[] verts = new BezierCurveTessellator(lastPoint, b, c, d).tessellate(20);
                int i = 0;
                int n = verts.length;
                while (i < n) {
                    contour.addVertex(verts[i], verts[i + 1], 0.0f);
                    i += 2;
                }
                contour.addVertex(d.x, d.y, 0.0f);
                lastPoint.set((Tuple3f)d);
            } else if (ret == 4) {
                contours.add(contour);
                contour = new Contour();
            } else {
                throw new IllegalArgumentException("Unsupported path segment type: " + ret + ". Shape cannot contain quadratic bezier curves.");
            }
            iter.next();
        }
        if (contours.size() == 0) {
            throw new IllegalArgumentException("Invalid path: path is not closed");
        }
        GLU.gluTessBeginPolygon((GLUtessellator)this.tess, null);
        for (Contour cont : contours) {
            cont.addContour(this.tess);
        }
        GLU.gluTessEndPolygon((GLUtessellator)this.tess);
        if (callback.hasError()) {
            throw new IllegalArgumentException(callback.getError());
        }
        FloatBuffer buf = Buffers.newDirectFloatBuffer((int)callback.vertices.size());
        for (Float f : callback.vertices) {
            buf.put(f.floatValue());
        }
        buf.rewind();
        RenderData data = new RenderData(buf);
        for (SliceData slice : callback.slices) {
            data.defineSlice(slice.mode, slice.index);
        }
        return new DisplayListRenderer(data);
    }

    private int getGLUWindingRule(int javaWindingRule) {
        if (javaWindingRule == 0) {
            return 100130;
        }
        if (javaWindingRule == 1) {
            return 100131;
        }
        throw new IllegalArgumentException("Invalid winding rule: " + javaWindingRule);
    }

    private static class Callback
    extends GLUtessellatorCallbackAdapter {
        private Integer error = null;
        private List<Float> vertices = new ArrayList<Float>();
        private int vertIndex;
        private List<SliceData> slices = new ArrayList<SliceData>();

        private Callback() {
        }

        public void begin(int mode) {
            this.slices.add(new SliceData(mode, this.vertIndex));
        }

        public boolean hasError() {
            return this.error != null;
        }

        public String getError() {
            if (this.error != null) {
                return GLUErrors.getTessErrorString(this.error);
            }
            return "";
        }

        public void vertex(Object vertex) {
            double[] vArray;
            double[] dArray = vArray = (double[])vertex;
            int n = vArray.length;
            int n2 = 0;
            while (n2 < n) {
                double val = dArray[n2];
                this.vertices.add(Float.valueOf((float)val));
                ++n2;
            }
            this.vertIndex += vArray.length;
        }

        public void error(int error) {
            this.error = new Integer(error);
        }

        public void combine(double[] coords, Object[] vertexData, float[] weight, Object[] out) {
            double[] vertex = new double[3];
            System.arraycopy(coords, 0, vertex, 0, 3);
            out[0] = vertex;
        }
    }

    private static class Contour {
        List<Point3d> coords = new ArrayList<Point3d>();

        private Contour() {
        }

        void addVertex(float x, float y, float z) {
            this.coords.add(new Point3d((double)x, (double)y, (double)z));
        }

        void addContour(GLUtessellator tessellator) {
            GLU.gluTessBeginContour((GLUtessellator)tessellator);
            for (Point3d pt : this.coords) {
                double[] vals = new double[3];
                pt.get(vals);
                GLU.gluTessVertex((GLUtessellator)tessellator, (double[])vals, (int)0, (Object)vals);
            }
            GLU.gluTessEndContour((GLUtessellator)tessellator);
        }
    }

    private static class SliceData {
        int mode;
        int index;

        public SliceData(int mode, int index) {
            this.mode = mode;
            this.index = index;
        }
    }
}

