/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.util;

import com.jogamp.common.nio.Buffers;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.gl2.GLUgl2;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.math.Ray3f;

public class RayCreator {
    private double[] identity = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private IntBuffer viewport = Buffers.newDirectIntBuffer((int)4);
    private DoubleBuffer mvMatrix = Buffers.newDirectDoubleBuffer((int)16);
    private DoubleBuffer projMatrix = Buffers.newDirectDoubleBuffer((int)16);
    private DoubleBuffer output = Buffers.newDirectDoubleBuffer((int)3);
    private GLUgl2 glu = new GLUgl2();

    public Point3f createOrthoPoint(GL2 gl, int x, int y) {
        int height = gl.getContext().getGLDrawable().getSurfaceHeight();
        int width = gl.getContext().getGLDrawable().getSurfaceWidth();
        gl.glGetIntegerv(2978, this.viewport);
        gl.glGetDoublev(2983, this.projMatrix);
        this.mvMatrix.put(this.identity, 0, this.identity.length);
        this.mvMatrix.put(12, -width / 2);
        this.mvMatrix.put(13, -height / 2);
        this.mvMatrix.rewind();
        int ogY = height - y - 1;
        this.viewport.put(2, width);
        this.viewport.put(3, height);
        this.glu.gluUnProject((double)x, (double)ogY, 0.0, this.mvMatrix, this.projMatrix, this.viewport, this.output);
        return new Point3f((float)this.output.get(0), (float)this.output.get(1), 0.0f);
    }

    public Ray3f createRay(GL2 gl, Point3f viewLocation, int x, int y) {
        gl.glGetIntegerv(2978, this.viewport);
        gl.glGetDoublev(2982, this.mvMatrix);
        gl.glGetDoublev(2983, this.projMatrix);
        int ogY = this.viewport.get(3) - y - 1;
        this.glu.gluUnProject((double)x, (double)ogY, 1.0, this.mvMatrix, this.projMatrix, this.viewport, this.output);
        Vector3f rayDirection = new Vector3f();
        rayDirection.x = (float)this.output.get(0);
        rayDirection.y = (float)this.output.get(1);
        rayDirection.z = (float)this.output.get(2);
        this.glu.gluUnProject((double)x, (double)ogY, 0.0, this.mvMatrix, this.projMatrix, this.viewport, this.output);
        rayDirection.x -= (float)this.output.get(0);
        rayDirection.y -= (float)this.output.get(1);
        rayDirection.z -= (float)this.output.get(2);
        return new Ray3f(viewLocation, rayDirection);
    }
}

