/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.util;

import javax.vecmath.Point3f;

public class BezierCurveTessellator {
    private Point3f p0;
    private Point3f p1;
    private Point3f p2;
    private Point3f p3;

    public BezierCurveTessellator(Point3f a, Point3f b, Point3f c, Point3f d) {
        this.p0 = new Point3f(a);
        this.p1 = new Point3f(b);
        this.p2 = new Point3f(c);
        this.p3 = new Point3f(d);
    }

    public float[] tessellate(int edges) {
        float[] vertices = new float[(edges + 1) * 2];
        int i = 0;
        while (i <= edges) {
            float a = (float)i / (float)edges;
            float b = 1.0f - a;
            vertices[i * 2] = this.p0.x * b * b * b + this.p1.x * 3.0f * b * b * a + this.p2.x * 3.0f * b * a * a + this.p3.x * a * a * a;
            vertices[i * 2 + 1] = this.p0.y * b * b * b + this.p1.y * 3.0f * b * b * a + this.p2.y * 3.0f * b * a * a + this.p3.y * a * a * a;
            ++i;
        }
        return vertices;
    }
}

