/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import saf.v3d.AppearanceFactory;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.render.RenderState;
import saf.v3d.scene.Appearance;
import saf.v3d.scene.VComposite;

public abstract class VSpatial {
    protected static final int NO_CANVAS_ID = -1;
    protected Vector3f localTrans;
    protected Vector3f worldTrans;
    protected float localScale = 1.0f;
    protected float worldScale = 1.0f;
    protected AxisAngle4f localRotation;
    protected Matrix3f worldRotation;
    protected Appearance appearance = AppearanceFactory.COLOR_BLUE;
    protected boolean visible = true;
    protected boolean dirty = true;
    protected AppSetter appSetter;
    protected VComposite parent;
    protected BoundingSphere boundingSphere;
    protected Map<Object, Object> clientMap = new HashMap<Object, Object>();
    public String id = "";

    public VSpatial() {
        this.localTrans = new Vector3f();
        this.worldTrans = new Vector3f();
        this.localRotation = new AxisAngle4f(0.0f, 0.0f, 0.0f, 0.0f);
        this.worldRotation = new Matrix3f();
        this.worldRotation.setIdentity();
        this.appSetter = new DefAppSetter(this);
    }

    public Vector3f getLocalTranslation() {
        return this.localTrans;
    }

    public float getLocalScale() {
        return this.localScale;
    }

    public AxisAngle4f getLocalRotation() {
        return this.localRotation;
    }

    public Vector3f getWorldTranslation() {
        return this.worldTrans;
    }

    public float getWorldScale() {
        return this.worldScale;
    }

    public Matrix3f getWorldRotation() {
        return this.worldRotation;
    }

    public void putProperty(Object key, Object val) {
        this.clientMap.put(key, val);
    }

    public Object getProperty(Object key) {
        return this.clientMap.get(key);
    }

    protected abstract void doDraw(GL2 var1, RenderState var2);

    public void invalidate(GL2 gl) {
    }

    public void draw(GL2 gl, RenderState state) {
        if (this.visible) {
            gl.glPushMatrix();
            gl.glTranslatef(this.localTrans.x, this.localTrans.y, this.localTrans.z);
            gl.glRotatef((float)Math.toDegrees(this.localRotation.angle), this.localRotation.x, this.localRotation.y, this.localRotation.z);
            gl.glScalef(this.localScale, this.localScale, this.localScale);
            if (this.appearance == null) {
                this.appearance = AppearanceFactory.COLOR_BLUE;
            }
            state.appearance = this.appearance;
            this.doDraw(gl, state);
            gl.glPopMatrix();
        }
    }

    public void updateWorldTransformation() {
        if (this.dirty) {
            if (this.parent != null) {
                this.worldScale = this.parent.getWorldScale() * this.localScale;
                this.worldRotation.set(this.localRotation);
                this.worldRotation.mul(this.parent.getWorldRotation());
                Matrix3f matrix = new Matrix3f(this.parent.getWorldRotation());
                Vector3f trans = new Vector3f(this.localTrans);
                matrix.transform((Tuple3f)trans);
                trans.scale(this.parent.getWorldScale());
                this.worldTrans.set((Tuple3f)this.parent.getWorldTranslation());
                this.worldTrans.add((Tuple3f)trans);
            } else {
                this.worldScale = this.localScale;
                this.worldRotation.set(this.localRotation);
                this.worldTrans.set((Tuple3f)this.localTrans);
            }
        }
        this.dirty = false;
    }

    protected void markAsDirty() {
        this.dirty = true;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void rotate(float angle, float x, float y, float z) {
        this.localRotation.set(x, y, z, (float)Math.toRadians(angle));
        this.markAsDirty();
    }

    public void rotate2D(float angle) {
        this.rotate(angle, 0.0f, 0.0f, -1.0f);
    }

    public void rotate(Quat4f rotation) {
        this.localRotation.set(rotation);
        this.markAsDirty();
    }

    public void scale(float scale) {
        if (this.localScale != scale) {
            this.localScale = scale;
            this.markAsDirty();
        }
    }

    public void setAppearance(Appearance app) {
        this.appSetter.set(app);
    }

    public Appearance getAppearance() {
        return this.appearance;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void translate(float x, float y, float z) {
        this.localTrans.set(x, y, z);
        this.markAsDirty();
    }

    public void translate(Tuple3f tuple) {
        this.localTrans.set(tuple);
        this.markAsDirty();
    }

    public VComposite getParent() {
        return this.parent;
    }

    public void setParent(VComposite parent) {
        this.parent = parent;
    }

    public Matrix4f getWorldToLocalTransform() {
        this.percolateDirtyUp();
        Matrix4f matrix = new Matrix4f();
        matrix.setIdentity();
        matrix.setRotation(this.worldRotation);
        matrix.setScale(this.worldScale);
        matrix.setTranslation(this.worldTrans);
        matrix.invert();
        return matrix;
    }

    public Point3f transform(Point3f pt) {
        Matrix3f mat = new Matrix3f();
        mat.set(this.localRotation);
        mat.mul(this.localScale);
        mat.transform((Tuple3f)pt);
        pt.add((Tuple3f)this.localTrans);
        return pt;
    }

    public BoundingSphere getLocalBoundingSphere() {
        return this.boundingSphere;
    }

    protected void percolateDirtyUp() {
        if (this.dirty) {
            if (this.parent == null) {
                this.updateWorldTransformation();
            } else {
                VComposite ancestor = this.parent;
                while (ancestor.parent != null) {
                    ancestor = ancestor.parent;
                }
                ((VSpatial)ancestor).updateWorldTransformation();
            }
        }
    }

    public BoundingSphere getBoundingSphere() {
        this.percolateDirtyUp();
        return this.doGetBoundingSphere();
    }

    protected BoundingSphere doGetBoundingSphere() {
        Quat4f rotation = new Quat4f();
        rotation.set(this.worldRotation);
        rotation.normalize();
        BoundingSphere sphere = new BoundingSphere(this.boundingSphere);
        return sphere.transform(this.worldScale, rotation, this.worldTrans);
    }

    public abstract void intersects(Point3f var1, Accumulator var2);

    public abstract void intersects(Point3f var1, Vector3f var2, Accumulator var3);

    static interface AppSetter {
        public void set(Appearance var1);
    }

    static final class DefAppSetter
    implements AppSetter {
        VSpatial spatial;

        public DefAppSetter(VSpatial spatial) {
            this.spatial = spatial;
        }

        @Override
        public void set(Appearance app) {
            this.spatial.appearance = app;
        }
    }

    static final class EmptyAppSetter
    implements AppSetter {
        EmptyAppSetter() {
        }

        @Override
        public void set(Appearance app) {
        }
    }

    static final class OneTimeAppSetter
    implements AppSetter {
        VSpatial spatial;

        public OneTimeAppSetter(VSpatial spatial) {
            this.spatial = spatial;
        }

        @Override
        public void set(Appearance app) {
            this.spatial.appearance = app;
            this.spatial.appSetter = new EmptyAppSetter();
        }
    }
}

