/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.picking.DefaultAccumulator;
import saf.v3d.scene.Appearance;
import saf.v3d.scene.VComposite;
import saf.v3d.scene.VImage2D;
import saf.v3d.scene.VShape;
import saf.v3d.scene.VSpatial;

public class VNode
extends VComposite {
    public VNode(VShape shape) {
        this.children = new ArrayList();
        this.addChild(shape);
    }

    public VNode(VImage2D image) {
        this.children = new ArrayList();
        this.addChild(image);
    }

    @Override
    public void setAppearance(Appearance app) {
        super.setAppearance(app);
        for (VSpatial child : this.children) {
            child.setAppearance(app);
        }
    }

    @Override
    protected BoundingSphere doGetBoundingSphere() {
        Quat4f rotation = new Quat4f();
        rotation.set(this.worldRotation);
        rotation.normalize();
        BoundingSphere sphere = this.getLocalBoundingSphere();
        return sphere.transform(this.worldScale, rotation, this.worldTrans);
    }

    @Override
    public BoundingSphere getLocalBoundingSphere() {
        List childList = (List)this.children;
        this.boundingSphere = new BoundingSphere(((VSpatial)((List)this.children).get(0)).getLocalBoundingSphere());
        int i = 1;
        int n = childList.size();
        while (i < n) {
            VSpatial child = (VSpatial)childList.get(i);
            BoundingSphere childSphere = new BoundingSphere(child.getLocalBoundingSphere());
            Quat4f rotation = new Quat4f();
            rotation.set(child.getLocalRotation());
            rotation.normalize();
            childSphere.transform(child.getLocalScale(), rotation, child.getLocalTranslation());
            this.boundingSphere.merge(childSphere);
            ++i;
        }
        return this.boundingSphere;
    }

    @Override
    public void intersects(Point3f point, Accumulator accumulator) {
        DefaultAccumulator tmp = new DefaultAccumulator();
        super.intersects(point, tmp);
        if (!tmp.getItems().isEmpty()) {
            accumulator.add(this);
        }
    }

    @Override
    public void intersects(Point3f rayOrigin, Vector3f rayDirection, Accumulator accumulator) {
        DefaultAccumulator tmp = new DefaultAccumulator();
        super.intersects(rayOrigin, rayDirection, accumulator);
        if (!tmp.getItems().isEmpty()) {
            accumulator.add(this);
        }
    }
}

