/*
 * Decompiled with CFR 0.152.
 */
package saf.v3d.scene;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import saf.v3d.picking.Accumulator;
import saf.v3d.picking.BoundingSphere;
import saf.v3d.scene.VSpatial;

public abstract class VGeometry
extends VSpatial {
    @Override
    public void intersects(Point3f point, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(point)) {
            Point3f localPt = new Point3f(point);
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            matrix.setRotation(this.worldRotation);
            matrix.setScale(this.worldScale);
            matrix.setTranslation(this.worldTrans);
            Matrix4f invert = new Matrix4f();
            invert.setIdentity();
            invert.invert(matrix);
            matrix.setTranslation(this.worldTrans);
            invert.setIdentity();
            invert.invert(matrix);
            invert.transform(localPt);
            if (this.intersects(localPt)) {
                accumulator.add(this);
            }
        }
    }

    @Override
    public void intersects(Point3f rayOrigin, Vector3f rayDirection, Accumulator accumulator) {
        BoundingSphere sphere = this.getBoundingSphere();
        if (sphere.intersects(rayOrigin, rayDirection)) {
            Point3f transOrigin = new Point3f(rayOrigin);
            Vector3f transDir = new Vector3f(rayDirection);
            Matrix4f matrix = new Matrix4f();
            matrix.setIdentity();
            matrix.setRotation(this.worldRotation);
            matrix.setScale(this.worldScale);
            Matrix4f invert = new Matrix4f();
            invert.setIdentity();
            invert.invert(matrix);
            invert.transform(transDir);
            transDir.normalize();
            matrix.setTranslation(this.worldTrans);
            invert.setIdentity();
            invert.invert(matrix);
            invert.transform(transOrigin);
            if (this.intersects(transOrigin, transDir)) {
                accumulator.add(this);
            }
        }
    }

    protected abstract boolean intersects(Point3f var1, Vector3f var2);

    protected abstract boolean intersects(Point3f var1);
}

